/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.craftinggrid;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mcjty.rftoolsstorage.craftinggrid.IItemKey;
import mcjty.rftoolsstorage.craftinggrid.IItemSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityItemSource
implements IItemSource {
    private final List<Pair<IItemHandler, Integer>> inventories = new ArrayList<Pair<IItemHandler, Integer>>();

    public TileEntityItemSource add(BlockEntity te, int offset) {
        te.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> this.inventories.add((Pair<IItemHandler, Integer>)Pair.of((Object)h, (Object)offset)));
        return this;
    }

    public TileEntityItemSource add(IItemHandler handler, int offset) {
        this.inventories.add((Pair<IItemHandler, Integer>)Pair.of((Object)handler, (Object)offset));
        return this;
    }

    private static ItemStack getStackInSlot(Object inv, int slot) {
        if (inv instanceof IItemHandler) {
            return ((IItemHandler)inv).getStackInSlot(slot);
        }
        if (inv instanceof Container) {
            return ((Container)inv).m_8020_(slot);
        }
        return ItemStack.f_41583_;
    }

    private static boolean insertStackInSlot(Object inv, int slot, ItemStack stack) {
        if (inv instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)inv;
            if (!handler.insertItem(slot, stack, true).m_41619_()) {
                return false;
            }
            return handler.insertItem(slot, stack, false).m_41619_();
        }
        if (inv instanceof Container) {
            Container inventory = (Container)inv;
            ItemStack oldStack = inventory.m_8020_(slot);
            if (!oldStack.m_41619_()) {
                if (stack.m_41613_() + oldStack.m_41613_() > stack.m_41741_()) {
                    return false;
                }
                stack.m_41769_(oldStack.m_41613_());
            }
            inventory.m_6836_(slot, stack);
            return true;
        }
        return false;
    }

    private static int insertStackInAnySlot(Object inv, ItemStack stack) {
        if (inv instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)inv;
            ItemStack leftOver = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
            return leftOver.m_41613_();
        }
        if (inv instanceof Container) {
            Container inventory = (Container)inv;
            return 0;
        }
        return stack.m_41613_();
    }

    private static int getSizeInventory(Object inv) {
        if (inv instanceof IItemHandler) {
            return ((IItemHandler)inv).getSlots();
        }
        if (inv instanceof Container) {
            return ((Container)inv).m_6643_();
        }
        return 0;
    }

    @Override
    public Iterable<Pair<IItemKey, ItemStack>> getItems() {
        return () -> new Iterator<Pair<IItemKey, ItemStack>>(){
            private int inventoryIndex = 0;
            private int slotIndex = 0;

            private boolean firstValidItem() {
                while (this.inventoryIndex < TileEntityItemSource.this.inventories.size()) {
                    Object inventory = TileEntityItemSource.this.inventories.get(this.inventoryIndex).getLeft();
                    if (this.slotIndex < TileEntityItemSource.getSizeInventory(inventory)) {
                        return true;
                    }
                    this.slotIndex = 0;
                    ++this.inventoryIndex;
                }
                return false;
            }

            @Override
            public boolean hasNext() {
                return this.firstValidItem();
            }

            @Override
            public Pair<IItemKey, ItemStack> next() {
                IItemHandler te = (IItemHandler)TileEntityItemSource.this.inventories.get(this.inventoryIndex).getLeft();
                ItemKey key = new ItemKey(te, this.slotIndex);
                Pair result = Pair.of((Object)key, (Object)TileEntityItemSource.getStackInSlot(te, this.slotIndex));
                ++this.slotIndex;
                return result;
            }
        };
    }

    @Override
    public ItemStack decrStackSize(IItemKey key, int amount) {
        ItemKey realKey = (ItemKey)key;
        IItemHandler handler = realKey.inventory();
        if (handler != null) {
            return handler.extractItem(realKey.slot(), amount, false);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public boolean insertStack(IItemKey key, ItemStack stack) {
        ItemKey realKey = (ItemKey)key;
        return TileEntityItemSource.insertStackInSlot(realKey.inventory(), realKey.slot(), stack);
    }

    @Override
    public int insertStackAnySlot(IItemKey key, ItemStack stack) {
        ItemKey realKey = (ItemKey)key;
        return TileEntityItemSource.insertStackInAnySlot(realKey.inventory(), stack);
    }

    private record ItemKey(IItemHandler inventory, int slot) implements IItemKey
    {
    }
}

