/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.craftinggrid;

import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsstorage.craftinggrid.CraftingGrid;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridInventory;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridProvider;
import mcjty.rftoolsstorage.craftinggrid.PacketGridSync;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public record PacketGridToServer(PacketGridSync sync, ItemStack[] stacks) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("rftoolsstorage", "gridtoserver");

    public void write(FriendlyByteBuf buf) {
        this.sync.convertToBytes(buf);
        buf.writeInt(this.stacks.length);
        for (ItemStack stack : this.stacks) {
            buf.m_130055_(stack);
        }
    }

    public ResourceLocation id() {
        return ID;
    }

    public static PacketGridToServer create(FriendlyByteBuf buf) {
        PacketGridSync sync = new PacketGridSync();
        sync.convertFromBytes(buf);
        int len = buf.readInt();
        ItemStack[] stacks = new ItemStack[len];
        for (int i = 0; i < len; ++i) {
            stacks[i] = buf.m_130267_();
        }
        return new PacketGridToServer(sync, stacks);
    }

    public static PacketGridToServer create(BlockPos pos, ResourceKey<Level> type, CraftingGrid grid) {
        PacketGridSync sync = new PacketGridSync();
        sync.init(pos, type, grid);
        ItemStack[] stacks = new ItemStack[10];
        for (int i = 0; i < 10; ++i) {
            stacks[i] = grid.getCraftingGridInventory().getStackInSlot(i);
        }
        return new PacketGridToServer(sync, stacks);
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> ctx.player().ifPresent(player -> {
            Level world = player.m_20193_();
            CraftingGridProvider provider = this.sync.handleMessage((Level)LevelTools.getLevel((Level)world, this.sync.type), (Player)player);
            if (provider != null) {
                CraftingGridInventory inventory = provider.getCraftingGrid().getCraftingGridInventory();
                for (int i = 0; i < 10; ++i) {
                    inventory.setStackInSlot(i, this.stacks[i]);
                }
                provider.markInventoryDirty();
            }
        }));
    }
}

