/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.client;

import com.blakebr0.ironjetpacks.client.layer.JetpackRenderLayer;
import com.blakebr0.ironjetpacks.client.model.JetpackModel;
import com.blakebr0.ironjetpacks.config.ModConfigs;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ModelHandler {
    public static final ModelLayerLocation JETPACK_LAYER = new ModelLayerLocation(new ResourceLocation("minecraft:player"), "ironjetpacks:jetpack");

    @SubscribeEvent
    public void onRegisterLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(JETPACK_LAYER, JetpackModel::createBodyLayer);
    }

    @SubscribeEvent
    public void onAddLayers(EntityRenderersEvent.AddLayers event) {
        if (ModConfigs.isCuriosEnabled()) {
            ModelHandler.addJetpackLayerToPlayerSkin(event, "default");
            ModelHandler.addJetpackLayerToPlayerSkin(event, "slim");
        }
    }

    private static void addJetpackLayerToPlayerSkin(EntityRenderersEvent.AddLayers event, String skinName) {
        LivingEntityRenderer renderer = event.getSkin(skinName);
        if (renderer != null) {
            renderer.m_115326_(new JetpackRenderLayer(renderer));
        }
    }
}

