/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutilities.features.tomes;

import javax.annotation.Nullable;
import net.darkhax.darkutilities.features.flatblocks.BlockFlatTile;
import net.darkhax.darkutilities.features.tomes.TomeEffect;
import net.darkhax.darkutilities.mixin.AccessorPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TomeEffects {
    public static final TomeEffect<Player, InteractionResultHolder<ItemStack>> RESET_ENCHANTMENT_SEED = TomeEffect.withExpCost(TomeEffect.withCooldown(TomeEffects::resetEnchantmentSeed, 600), 20);
    public static final TomeEffect<BlockPos, InteractionResult> HIDE_BLOCK = TomeEffect.withCooldown(TomeEffects::hideBlocks, 20);
    public static final TomeEffect<Entity, InteractionResult> HIDE_ENTITY = TomeEffect.withCooldown(TomeEffects::hideEntity, 100);

    @Nullable
    private static InteractionResultHolder<ItemStack> resetEnchantmentSeed(ItemStack usedStack, Player player, InteractionHand hand, Player target) {
        if (player instanceof AccessorPlayer) {
            AccessorPlayer accessor = (AccessorPlayer)player;
            accessor.darkutils$setEnchantmentSeed(player.m_217043_().m_188502_());
            return InteractionResultHolder.m_19090_((Object)usedStack);
        }
        return null;
    }

    @Nullable
    private static InteractionResult hideBlocks(ItemStack usedStack, Player player, InteractionHand hand, BlockPos target) {
        BlockState state = player.m_9236_().m_8055_(target);
        if (state.m_60734_() instanceof BlockFlatTile && !((Boolean)state.m_61143_((Property)BlockFlatTile.HIDDEN)).booleanValue()) {
            player.m_9236_().m_46597_(target, (BlockState)state.m_61124_((Property)BlockFlatTile.HIDDEN, (Comparable)Boolean.valueOf(true)));
            return InteractionResult.SUCCESS;
        }
        return null;
    }

    @Nullable
    private static InteractionResult hideEntity(ItemStack usedStack, Player player, InteractionHand hand, Entity target) {
        LivingEntity living;
        if ((target instanceof ItemFrame || target instanceof ArmorStand) && !target.m_20145_()) {
            target.m_6842_(true);
            return InteractionResult.SUCCESS;
        }
        if (target instanceof LivingEntity && !(living = (LivingEntity)target).m_21023_(MobEffects.f_19609_)) {
            living.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 3600));
            return InteractionResult.SUCCESS;
        }
        return null;
    }
}

