/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutilities.features.filters;

import java.util.function.Predicate;
import net.darkhax.bookshelf.api.block.IBindRenderLayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockEntityFilter
extends Block
implements IBindRenderLayer {
    public static final BlockBehaviour.Properties BLOCK_PROPERTIES = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60913_(3.0f, 10.0f).m_60960_((a, b, c) -> false).m_60971_((a, b, c) -> false).m_60955_();
    private final Predicate<Entity> filter;

    public BlockEntityFilter(Predicate<Entity> filter) {
        this(filter, BLOCK_PROPERTIES);
    }

    public BlockEntityFilter(Predicate<Entity> filter, BlockBehaviour.Properties properties) {
        super(properties);
        this.filter = filter;
        BlockState defaultState = this.m_49966_();
        defaultState = (BlockState)defaultState.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false));
        defaultState = (BlockState)defaultState.m_61124_((Property)BlockStateProperties.f_61441_, (Comparable)Boolean.valueOf(false));
        this.m_49959_(defaultState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61448_, BlockStateProperties.f_61441_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState placedState = super.m_5573_(context);
        if (placedState != null) {
            placedState = (BlockState)placedState.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(context.m_43725_().m_276867_(context.m_8083_())));
        }
        return placedState;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_6047_()) {
            if (!world.f_46443_) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61441_, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)BlockStateProperties.f_61441_) == false)), 3);
                world.m_46796_(1008, pos, 0);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean isBlockPowered = world.m_276867_(pos);
        if (!world.f_46443_ && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != isBlockPowered) {
            world.m_5594_(null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, 0.5f);
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(isBlockPowered)));
        }
        super.m_6861_(state, world, pos, block, fromPos, isMoving);
    }

    public boolean m_48673_(BlockState state) {
        return true;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityContext;
        Entity entity;
        if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue() && context instanceof EntityCollisionContext && (entity = (entityContext = (EntityCollisionContext)context).m_193113_()) != null) {
            boolean filterMatch = this.filter.test(entity);
            if ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61441_) != filterMatch) {
                return Shapes.m_83040_();
            }
        }
        return super.m_5939_(state, world, pos, context);
    }

    public boolean m_6104_(BlockState ourState, BlockState neighborState, Direction side) {
        return neighborState.m_60713_((Block)this);
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return state.m_60819_().m_76178_();
    }

    public RenderType getRenderLayerToBind() {
        return RenderType.m_110466_();
    }
}

