/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.HostileNetworks;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.data.DataModelRegistry;
import dev.shadowsoffire.hostilenetworks.data.ModelTier;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;

public class GenerateModelCommand {
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_ENTITY_TYPE = (ctx, builder) -> SharedSuggestionProvider.m_82981_(ForgeRegistries.ENTITY_TYPES.getKeys().stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder);
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_DATA_MODEL = (ctx, builder) -> SharedSuggestionProvider.m_82981_(DataModelRegistry.INSTANCE.getKeys().stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder);
    public static final Method dropFromLootTable = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"m_7625_", (Class[])new Class[]{DamageSource.class, Boolean.TYPE});
    public static final MethodHandle DROP_LOOT = GenerateModelCommand.lootMethodHandle();
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void register(LiteralArgumentBuilder<CommandSourceStack> root) {
        root.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"generate_model_json").requires(c -> c.m_6761_(2))).then(Commands.m_82129_((String)"entity_type", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_ENTITY_TYPE).then(Commands.m_82129_((String)"max_stack_size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(c -> {
            ServerPlayer p = ((CommandSourceStack)c.getSource()).m_81375_();
            ResourceLocation name = (ResourceLocation)c.getArgument("entity_type", ResourceLocation.class);
            EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(name);
            List<ItemStack> results = GenerateModelCommand.runSimulation(type, (Player)p, 7500, ((Integer)c.getArgument("max_stack_size", Integer.class)).intValue());
            DataModel model = new DataModel((EntityType<? extends LivingEntity>)type, Collections.emptyList(), Component.m_237115_((String)type.m_20675_()).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)p.m_217043_().m_188503_(0xFFFFFF)))), new CompoundTag(), 1.0f, 0.0f, 0.0f, 0.0f, 256, new ItemStack((ItemLike)Hostile.Items.PREDICTION_MATRIX.get()), new ItemStack((ItemLike)Items.f_42398_), "hostilenetworks.trivia." + name.m_135815_(), results, ModelTier.defaultData(), ModelTier.defaultDataPerKill());
            GenerateModelCommand.write(name.m_135827_(), name.m_135815_(), model);
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)("Data Model JSON generated at datagen/data_models/" + name.m_135827_() + "/" + name.m_135815_() + ".json")), true);
            return 0;
        }))));
        root.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"update_model_json").requires(c -> c.m_6761_(2))).then(Commands.m_82129_((String)"data_model", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_DATA_MODEL).then(Commands.m_82129_((String)"max_stack_size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(c -> {
            ServerPlayer p = ((CommandSourceStack)c.getSource()).m_81375_();
            ResourceLocation name = (ResourceLocation)c.getArgument("data_model", ResourceLocation.class);
            DataModel model = (DataModel)DataModelRegistry.INSTANCE.getValue(name);
            EntityType<? extends LivingEntity> type = model.type();
            List<ItemStack> results = GenerateModelCommand.runSimulation(type, (Player)p, 7500, ((Integer)c.getArgument("max_stack_size", Integer.class)).intValue());
            DataModel newModel = new DataModel(model, results);
            GenerateModelCommand.write(name.m_135827_(), name.m_135815_(), newModel);
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)("Data Model JSON generated at datagen/data_models/" + name.m_135827_() + "/" + name.m_135815_() + ".json")), true);
            return 0;
        }))));
        root.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"generate_all").requires(c -> c.m_6761_(2))).then(Commands.m_82129_((String)"max_stack_size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(c -> {
            ServerPlayer p = ((CommandSourceStack)c.getSource()).m_81375_();
            for (EntityType type : ForgeRegistries.ENTITY_TYPES) {
                if (!(type.m_20615_(p.m_9236_()) instanceof Mob)) continue;
                ResourceLocation name = EntityType.m_20613_((EntityType)type);
                List<ItemStack> results = GenerateModelCommand.runSimulation(type, (Player)p, 7500, ((Integer)c.getArgument("max_stack_size", Integer.class)).intValue());
                if (results.isEmpty()) continue;
                DataModel model = new DataModel((EntityType<? extends LivingEntity>)type, Collections.emptyList(), Component.m_237115_((String)type.m_20675_()).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)p.m_217043_().m_188503_(0xFFFFFF)))), new CompoundTag(), 1.0f, 0.0f, 0.0f, 0.0f, 256, new ItemStack((ItemLike)Hostile.Items.PREDICTION_MATRIX.get()), new ItemStack((ItemLike)Items.f_42398_), "hostilenetworks.trivia." + name.m_135815_(), results, ModelTier.defaultData(), ModelTier.defaultDataPerKill());
                GenerateModelCommand.write(name.m_135827_(), name.m_135815_(), model);
            }
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Data Model JSON files generated at datagen/data_models/"), true);
            return 0;
        })));
        root.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"datafix_all").requires(c -> c.m_6761_(2))).executes(c -> {
            ResourceManager resman = ((CommandSourceStack)c.getSource()).m_81377_().m_177941_();
            ProfilerFiller profiler = ((CommandSourceStack)c.getSource()).m_81377_().m_129905_();
            Object map = DataModelRegistry.INSTANCE.m_5944_(resman, profiler);
            for (Map.Entry entry : map.entrySet()) {
                JsonObject out = new JsonObject();
                JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
                if (obj.has("conditions")) {
                    out.add("conditions", obj.remove("conditions"));
                }
                out.add("entity", obj.remove("type"));
                if (obj.has("subtypes")) {
                    out.add("variants", obj.remove("subtypes"));
                } else {
                    out.add("variants", (JsonElement)new JsonArray());
                }
                out.add("name", obj.remove("name"));
                if (obj.has("name_color")) {
                    String str;
                    JsonPrimitive colorJson = obj.remove("name_color").getAsJsonPrimitive();
                    TextColor color = colorJson.isNumber() ? TextColor.m_131266_((int)colorJson.getAsInt()) : ((str = colorJson.getAsString()).startsWith("0x") ? TextColor.m_131266_((int)Integer.decode(str)) : TextColor.m_131268_((String)str));
                    out.addProperty("name_color", color.m_131274_());
                }
                for (String s : obj.keySet()) {
                    out.add(s, obj.get(s));
                }
                GenerateModelCommand.write(((ResourceLocation)entry.getKey()).m_135827_(), ((ResourceLocation)entry.getKey()).m_135815_(), (JsonElement)out);
            }
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Data Model JSON files generated at datagen/data_models/"), true);
            return 0;
        }));
    }

    private static List<ItemStack> runSimulation(EntityType<?> type, Player p, int runs, float maxStackSize) {
        ArrayList allDrops = new ArrayList();
        try {
            Entity entity = type.m_20615_(p.m_9236_());
            DamageSource src = new DamageSource((Holder)p.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_286979_), (Entity)p);
            for (int i = 0; i < 2500; ++i) {
                entity.m_7678_(p.m_20185_(), p.m_20186_(), p.m_20189_(), 0.0f, 0.0f);
                entity.m_6469_(src, 1.0f);
                entity.captureDrops(allDrops);
                DROP_LOOT.invoke(entity, src, true);
            }
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        List<ItemStack> items = allDrops.stream().map(ItemEntity::m_32055_).toList();
        ArrayList<CountedStack> count = new ArrayList<CountedStack>();
        for (ItemStack s : items) {
            boolean found = false;
            for (CountedStack cs2 : count) {
                if (!ItemStack.m_150942_((ItemStack)cs2.stack, (ItemStack)s)) continue;
                cs2.count.incrementAndGet();
                found = true;
                break;
            }
            if (found) continue;
            count.add(new CountedStack(s, new AtomicInteger(1)));
        }
        List<Pair> avgs = count.stream().map(cs -> Pair.of((Object)cs.stack, (Object)Float.valueOf((float)cs.count.get() / 2500.0f))).toList();
        float factor = avgs.stream().map(Pair::getRight).max(Float::compareTo).orElse(Float.valueOf(0.0f)).floatValue() / maxStackSize;
        return avgs.stream().map(pair -> {
            ItemStack s = (ItemStack)pair.getLeft();
            s.m_41764_(Mth.m_14167_((float)(((Float)pair.getRight()).floatValue() / factor)));
            return s;
        }).sorted((s1, s2) -> Integer.compare(s1.m_41613_(), s2.m_41613_()) == 0 ? -ForgeRegistries.ITEMS.getKey((Object)s1.m_41720_()).compareTo(ForgeRegistries.ITEMS.getKey((Object)s2.m_41720_())) : -Integer.compare(s1.m_41613_(), s2.m_41613_())).toList();
    }

    private static void write(String namespace, String path, DataModel model) {
        JsonElement json = (JsonElement)DataModel.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)model).getOrThrow(false, arg_0 -> ((Logger)HostileNetworks.LOGGER).error(arg_0));
        if (!"minecraft".equals(namespace)) {
            ModLoadedCondition condition = new ModLoadedCondition(namespace);
            JsonArray arr = new JsonArray();
            arr.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
            JsonObject copy = new JsonObject();
            copy.add("conditions", (JsonElement)arr);
            json.getAsJsonObject().entrySet().forEach(entry -> copy.add((String)entry.getKey(), (JsonElement)entry.getValue()));
            json = copy;
        }
        GenerateModelCommand.write(namespace, path, json);
    }

    private static void write(String namespace, String path, JsonElement json) {
        File file = new File(FMLPaths.GAMEDIR.get().toFile(), "datagen/data/" + namespace + "/data_models/" + path + ".json");
        file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(file);){
            JsonWriter jWriter = new JsonWriter((Writer)writer);
            jWriter.setIndent("    ");
            GSON.toJson(json, jWriter);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static MethodHandle lootMethodHandle() {
        dropFromLootTable.setAccessible(true);
        try {
            return MethodHandles.lookup().unreflect(dropFromLootTable);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private record CountedStack(ItemStack stack, AtomicInteger count) {
    }
}

