/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.content.blocks;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.CoreTags;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.IColored;
import tv.soaryn.xycraft.core.content.blocks.SidePartBlock;
import tv.soaryn.xycraft.core.content.items.XyBlockItem;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.core.utils.ShapeUtils;
import tv.soaryn.xycraft.world.content.WorldContent;

public class LampSideBlock
extends SidePartBlock
implements IColored {
    private final int _color;
    private static final VoxelShape _baseShape = LampSideBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.25, (double)12.0);
    private static final VoxelShape _lightShape = LampSideBlock.m_49796_((double)7.0, (double)4.0, (double)7.0, (double)9.0, (double)12.0, (double)9.0);
    private final HashMap<Direction.Axis, VoxelShape[]> SHAPES = (HashMap)Util.m_137537_(() -> {
        HashMap<Direction.Axis, VoxelShape[]> map = new HashMap<Direction.Axis, VoxelShape[]>();
        VoxelShape[] baseArray = new VoxelShape[6];
        Arrays.setAll(baseArray, i -> ShapeUtils.rotate((VoxelShape)_baseShape, (Direction)Direction.m_122376_((int)i)));
        VoxelShape[] yAxisArray = new VoxelShape[6];
        VoxelShape[] xAxisArray = new VoxelShape[6];
        VoxelShape[] zAxisArray = new VoxelShape[6];
        VoxelShape xLight = ShapeUtils.rotate((VoxelShape)_lightShape, (Direction)Direction.WEST);
        VoxelShape zLight = ShapeUtils.rotate((VoxelShape)_lightShape, (Direction)Direction.NORTH);
        Arrays.setAll(yAxisArray, i -> Shapes.m_83110_((VoxelShape)baseArray[i], (VoxelShape)_lightShape));
        Arrays.setAll(xAxisArray, i -> Shapes.m_83110_((VoxelShape)baseArray[i], (VoxelShape)xLight));
        Arrays.setAll(zAxisArray, i -> Shapes.m_83110_((VoxelShape)baseArray[i], (VoxelShape)zLight));
        map.put(Direction.Axis.Y, yAxisArray);
        map.put(Direction.Axis.X, xAxisArray);
        map.put(Direction.Axis.Z, zAxisArray);
        return map;
    });

    public LampSideBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this._color = ColorUtils.getColorFromDye((DyeColor)color);
        this.m_49966_().m_61124_((Property)CoreStateProperties.Axis, (Comparable)Direction.Axis.Y);
    }

    public static Supplier<Block> blockSupplier(DyeColor color) {
        return () -> new LampSideBlock(color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50681_).m_60918_(SoundType.f_154677_).m_60953_(state -> 15).m_60910_().m_60955_().m_60966_());
    }

    public static Supplier<Item> itemSupplier(DyeColor dyeColor, RegistryObject<Block> blockRegistryObject) {
        return () -> new XyBlockItem((Block)blockRegistryObject.get(), new Item.Properties());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CoreStateProperties.Axis});
    }

    private EnumMap<DyeColor, BlockContent> getCurrentMap(int light, BlockState state) {
        return WorldContent.LampPillar;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        if (player.m_7500_()) {
            return super.getCloneItemStack(state, target, level, pos, player);
        }
        EnumMap<DyeColor, BlockContent> currentMap = this.getCurrentMap(0, state);
        return new ItemStack((ItemLike)currentMap.get(DyeColor.WHITE).block(), 1);
    }

    @NotNull
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        ItemStack offhandStack = Objects.requireNonNull(context.m_43723_()).m_21206_();
        BlockState state = (BlockState)super.m_5573_(context).m_61124_((Property)CoreStateProperties.Axis, (Comparable)Direction.Axis.Y);
        int light = state.getLightEmission((BlockGetter)context.m_43725_(), context.m_8083_());
        DyeColor color = DyeColor.getColor((ItemStack)offhandStack);
        if (color != null) {
            FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
            state = (BlockState)((BlockState)this.getCurrentMap(light, state).get(color).block().m_49966_().m_61124_((Property)CoreStateProperties.StateDirection, (Comparable)context.m_43719_().m_122424_())).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        }
        return state;
    }

    public VoxelShape getDownShapeForBaking() {
        return _baseShape;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hit) {
        ItemStack stack = player.m_21120_(interactionHand);
        DyeColor dyeColor = DyeColor.getColor((ItemStack)stack);
        if (dyeColor != null) {
            EnumMap<DyeColor, BlockContent> currentMap = this.getCurrentMap(state.getLightEmission((BlockGetter)level, pos), state);
            BlockContent blockType = currentMap.get(dyeColor);
            if (blockType.block() != this) {
                BlockState newState = blockType.block().m_49966_();
                newState = (BlockState)newState.m_61124_((Property)CoreStateProperties.StateDirection, (Comparable)((Direction)state.m_61143_((Property)CoreStateProperties.StateDirection)));
                newState = (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)));
                newState = (BlockState)newState.m_61124_((Property)CoreStateProperties.Axis, (Comparable)((Direction.Axis)state.m_61143_((Property)CoreStateProperties.Axis)));
                level.m_7731_(pos, newState, 11);
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        } else if (stack.m_204117_(CoreTags.Items.ForgeWrench) || player.m_6144_()) {
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)CoreStateProperties.Axis), 11);
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6227_(state, level, pos, player, interactionHand, hit);
    }

    public int getColorOfBlock(BlockState state, BlockAndTintGetter level, BlockPos pos, int index) {
        return this._color;
    }

    public int getColorOfItem(ItemStack stack, int index) {
        if (index != 0) {
            return -1;
        }
        return this._color;
    }

    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return super.m_5940_(state, level, pos, context);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)CoreStateProperties.Axis);
        Direction dir = (Direction)state.m_61143_((Property)CoreStateProperties.StateDirection);
        return this.SHAPES.get(axis)[dir.m_122411_()];
    }

    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull PathComputationType pathComputationType) {
        return pathComputationType == PathComputationType.AIR;
    }
}

