/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.multiblock.matcher;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.StateMatcher;
import com.klikli_dev.modonomicon.api.multiblock.TriPredicate;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class PredicateMatcher
implements StateMatcher {
    public static final ResourceLocation TYPE = Modonomicon.loc("predicate");
    private final BlockState displayState;
    private final ResourceLocation predicateId;
    private final Supplier<TriPredicate<BlockGetter, BlockPos, BlockState>> predicate;
    private final boolean countsTowardsTotalBlocks;

    protected PredicateMatcher(BlockState displayState, ResourceLocation predicateId, boolean countsTowardsTotalBlocks) {
        this.displayState = displayState;
        this.predicateId = predicateId;
        this.predicate = Suppliers.memoize(() -> LoaderRegistry.getPredicate(this.predicateId));
        this.countsTowardsTotalBlocks = countsTowardsTotalBlocks;
    }

    public static PredicateMatcher fromJson(JsonObject json) {
        try {
            BlockState displayState = BlockStateParser.m_234691_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (StringReader)new StringReader(GsonHelper.m_13906_((JsonObject)json, (String)"display")), (boolean)false).f_234748_();
            ResourceLocation predicateId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"predicate"));
            boolean countsTowardsTotalBlocks = GsonHelper.m_13855_((JsonObject)json, (String)"counts_towards_total_blocks", (boolean)true);
            return new PredicateMatcher(displayState, predicateId, countsTowardsTotalBlocks);
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Failed to parse BlockState from json member \"display\" for PredicateMatcher.", e);
        }
    }

    public static PredicateMatcher fromNetwork(FriendlyByteBuf buffer) {
        try {
            BlockState displayState = BlockStateParser.m_234691_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (StringReader)new StringReader(buffer.m_130277_()), (boolean)false).f_234748_();
            ResourceLocation predicateId = buffer.m_130281_();
            boolean countsTowardsTotalBlocks = buffer.readBoolean();
            return new PredicateMatcher(displayState, predicateId, countsTowardsTotalBlocks);
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Failed to parse PredicateMatcher from network.", e);
        }
    }

    public ResourceLocation getPredicateId() {
        return this.predicateId;
    }

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public BlockState getDisplayedState(long ticks) {
        return this.displayState;
    }

    @Override
    public TriPredicate<BlockGetter, BlockPos, BlockState> getStatePredicate() {
        return (TriPredicate)this.predicate.get();
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130070_(BlockStateParser.m_116769_((BlockState)this.displayState));
        buffer.m_130070_(this.predicateId.toString());
        buffer.writeBoolean(this.countsTowardsTotalBlocks);
    }

    @Override
    public boolean countsTowardsTotalBlocks() {
        return this.countsTowardsTotalBlocks;
    }

    public int hashCode() {
        return Objects.hash(this.predicateId, this.displayState);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PredicateMatcher that = (PredicateMatcher)o;
        return this.predicateId.equals((Object)that.predicateId) && this.displayState.equals(that.displayState);
    }
}

