/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.multiblock;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.api.multiblock.StateMatcher;
import com.klikli_dev.modonomicon.api.multiblock.TriPredicate;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMultiblock
implements Multiblock {
    private final Map<BlockPos, BlockEntity> blockEntityCache = new Object2ObjectOpenHashMap();
    public ResourceLocation id;
    protected int offX;
    protected int offY;
    protected int offZ;
    protected int viewOffX;
    protected int viewOffY;
    protected int viewOffZ;
    protected boolean symmetrical;
    Level level;

    public static Map<Character, StateMatcher> mappingFromJson(JsonObject jsonMapping) {
        HashMap<Character, StateMatcher> mapping = new HashMap<Character, StateMatcher>();
        for (Map.Entry entry : jsonMapping.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Mapping key needs to be only 1 character");
            }
            char key = ((String)entry.getKey()).charAt(0);
            JsonObject value = ((JsonElement)entry.getValue()).getAsJsonObject();
            ResourceLocation stateMatcherType = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)value, (String)"type"));
            StateMatcher stateMatcher = LoaderRegistry.getStateMatcherJsonLoader(stateMatcherType).fromJson(value);
            mapping.put(Character.valueOf(key), stateMatcher);
        }
        return mapping;
    }

    public static <T extends AbstractMultiblock> T additionalPropertiesFromJson(T multiblock, JsonObject json) {
        if (json.has("symmetrical")) {
            multiblock.symmetrical = GsonHelper.m_13912_((JsonObject)json, (String)"symmetrical");
        }
        if (json.has("offset")) {
            JsonArray jsonOffset = GsonHelper.m_13933_((JsonObject)json, (String)"offset");
            if (jsonOffset.size() != 3) {
                throw new JsonSyntaxException("Offset needs to be an array of 3 integers");
            }
            multiblock.offset(jsonOffset.get(0).getAsInt(), jsonOffset.get(1).getAsInt(), jsonOffset.get(2).getAsInt());
        }
        return multiblock;
    }

    public static Rotation fixHorizontal(Rotation rot) {
        return switch (rot) {
            case Rotation.CLOCKWISE_90 -> Rotation.COUNTERCLOCKWISE_90;
            case Rotation.COUNTERCLOCKWISE_90 -> Rotation.CLOCKWISE_90;
            default -> rot;
        };
    }

    public static Rotation rotationFromFacing(Direction facing) {
        return switch (facing) {
            case Direction.EAST -> Rotation.CLOCKWISE_90;
            case Direction.SOUTH -> Rotation.CLOCKWISE_180;
            case Direction.WEST -> Rotation.COUNTERCLOCKWISE_90;
            default -> Rotation.NONE;
        };
    }

    public Multiblock setOffset(int x, int y, int z) {
        this.offX = x;
        this.offY = y;
        this.offZ = z;
        return this.setViewOffset(x, y, z);
    }

    public Multiblock setViewOffset(int x, int y, int z) {
        this.viewOffX = x;
        this.viewOffY = y;
        this.viewOffZ = z;
        return this;
    }

    @Override
    public void setLevel(Level level) {
        this.level = level;
    }

    @Override
    public Multiblock offset(int x, int y, int z) {
        return this.setOffset(this.offX + x, this.offY + y, this.offZ + z);
    }

    @Override
    public Multiblock offsetView(int x, int y, int z) {
        return this.setViewOffset(this.viewOffX + x, this.viewOffY + y, this.viewOffZ + z);
    }

    @Override
    public Multiblock setSymmetrical(boolean symmetrical) {
        this.symmetrical = symmetrical;
        return this;
    }

    @Override
    public Multiblock setId(ResourceLocation res) {
        this.id = res;
        return this;
    }

    @Override
    public boolean isSymmetrical() {
        return this.symmetrical;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public void place(Level world, BlockPos pos, Rotation rotation) {
        this.setLevel(world);
        ((Collection)this.simulate(world, pos, rotation, false, false).getSecond()).forEach(r -> {
            BlockPos placePos = r.getWorldPosition();
            BlockState targetState = r.getStateMatcher().getDisplayedState(world.m_46467_()).m_60717_(rotation);
            if (!targetState.m_60795_() && targetState.m_60710_((LevelReader)world, placePos) && world.m_8055_(placePos).m_247087_()) {
                world.m_46597_(placePos, targetState);
            }
        });
    }

    @Override
    public Rotation validate(Level world, BlockPos pos) {
        if (this.isSymmetrical() && this.validate(world, pos, Rotation.NONE)) {
            return Rotation.NONE;
        }
        for (Rotation rot : Rotation.values()) {
            if (!this.validate(world, pos, rot)) continue;
            return rot;
        }
        return null;
    }

    @Override
    public boolean validate(Level world, BlockPos pos, Rotation rotation) {
        this.setLevel(world);
        Pair<BlockPos, Collection<Multiblock.SimulateResult>> sim = this.simulate(world, pos, rotation, false, false);
        return ((Collection)sim.getSecond()).stream().allMatch(r -> {
            BlockPos checkPos = r.getWorldPosition();
            TriPredicate<BlockGetter, BlockPos, BlockState> pred = r.getStateMatcher().getStatePredicate();
            BlockState state = world.m_8055_(checkPos).m_60717_(AbstractMultiblock.fixHorizontal(rotation));
            return pred.test((BlockGetter)world, checkPos, state);
        });
    }

    @Override
    public abstract Vec3i getSize();

    @Override
    public Vec3i getOffset() {
        return new Vec3i(this.offX, this.offY, this.offZ);
    }

    @Override
    public Vec3i getViewOffset() {
        return new Vec3i(this.viewOffX, this.viewOffY, this.viewOffZ);
    }

    void setViewOffset() {
        this.setViewOffset(this.offX, this.offY, this.offZ);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractMultiblock that = (AbstractMultiblock)o;
        return this.id.equals((Object)that.id);
    }

    @Nullable
    public BlockEntity m_7702_(BlockPos pos) {
        BlockState state = this.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof EntityBlock) {
            EntityBlock eb = (EntityBlock)block;
            return this.blockEntityCache.computeIfAbsent(pos.m_7949_(), p -> eb.m_142194_(p, state));
        }
        return null;
    }

    public FluidState m_6425_(BlockPos pos) {
        return Fluids.f_76191_.m_76145_();
    }

    public float m_7717_(Direction direction, boolean shaded) {
        return 1.0f;
    }

    public LevelLightEngine m_5518_() {
        return null;
    }

    public int m_6171_(BlockPos pos, ColorResolver color) {
        Biome plains = (Biome)this.level.m_9598_().m_175515_(Registries.f_256952_).m_123013_(Biomes.f_48202_);
        return color.m_130045_(plains, (double)pos.m_123341_(), (double)pos.m_123343_());
    }

    public int m_45517_(LightLayer type, BlockPos pos) {
        return 15;
    }

    public int m_45524_(BlockPos pos, int ambientDarkening) {
        return 15 - ambientDarkening;
    }

    public int m_141928_() {
        return 255;
    }

    public int m_141937_() {
        return 0;
    }
}

