/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.events;

import com.klikli_dev.modonomicon.api.events.EntryClickedEvent;
import com.klikli_dev.modonomicon.api.events.EventPriority;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class ModonomiconEvents {
    private static final Client client = new Client();
    private static final Server server = new Server();

    public static Client client() {
        return client;
    }

    public static Server server() {
        return server;
    }

    public static class Client {
        private final List<Pair<Consumer<EntryClickedEvent>, EventPriority>> entryClickedCallbacks = new ArrayList<Pair<Consumer<EntryClickedEvent>, EventPriority>>();

        public void onEntryClicked(Consumer<EntryClickedEvent> callback) {
            this.onEntryClicked(callback, EventPriority.NORMAL);
        }

        public void onEntryClicked(Consumer<EntryClickedEvent> callback, EventPriority priority) {
            this.entryClickedCallbacks.add((Pair<Consumer<EntryClickedEvent>, EventPriority>)Pair.of(callback, (Object)((Object)priority)));
            this.entryClickedCallbacks.sort((a, b) -> ((EventPriority)((Object)((Object)b.getSecond()))).compareTo((EventPriority)((Object)((Object)a.getSecond()))));
        }

        public boolean entryClicked(EntryClickedEvent event) {
            for (Pair<Consumer<EntryClickedEvent>, EventPriority> callback : this.entryClickedCallbacks) {
                ((Consumer)callback.getFirst()).accept(event);
                if (!event.isCanceled()) continue;
                break;
            }
            return event.isCanceled();
        }
    }

    public static class Server {
    }
}

