/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen.book;

import com.google.gson.JsonObject;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class BookIconModel {
    private final ItemStack itemStack;
    private final ResourceLocation texture;
    private final int width;
    private final int height;

    protected BookIconModel(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.texture = null;
        this.width = 16;
        this.height = 16;
    }

    protected BookIconModel(ResourceLocation texture, int width, int height) {
        this.texture = texture;
        this.itemStack = ItemStack.f_41583_;
        this.width = width;
        this.height = height;
    }

    public static BookIconModel create(ItemLike item) {
        return new BookIconModel(new ItemStack(item));
    }

    public static BookIconModel create(ItemStack stack) {
        return new BookIconModel(stack);
    }

    public static BookIconModel create(ResourceLocation texture) {
        return BookIconModel.create(texture, 16, 16);
    }

    public static BookIconModel create(ResourceLocation texture, int width, int height) {
        return new BookIconModel(texture, width, height);
    }

    public JsonObject toJson() {
        if (this.texture != null) {
            JsonObject json = new JsonObject();
            json.addProperty("texture", this.texture.toString());
            json.addProperty("width", (Number)this.width);
            json.addProperty("height", (Number)this.height);
            return json;
        }
        JsonObject json = new JsonObject();
        json.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.itemStack.m_41720_()).toString());
        return json;
    }
}

