/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.tileentity;

import com.blakebr0.cucumber.energy.DynamicEnergyStorage;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.CachedRecipe;
import com.blakebr0.cucumber.inventory.SidedItemStackHandlerWrapper;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.mysticalagriculture.api.crafting.ISouliumSpawnerRecipe;
import com.blakebr0.mysticalagriculture.block.SouliumSpawnerBlock;
import com.blakebr0.mysticalagriculture.container.SouliumSpawnerContainer;
import com.blakebr0.mysticalagriculture.container.inventory.UpgradeItemStackHandler;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.blakebr0.mysticalagriculture.init.ModTileEntities;
import com.blakebr0.mysticalagriculture.util.IUpgradeableMachine;
import com.blakebr0.mysticalagriculture.util.MachineUpgradeTier;
import com.blakebr0.mysticalagriculture.util.RecipeIngredientCache;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandlerModifiable;

public class SouliumSpawnerTileEntity
extends BaseInventoryTileEntity
implements MenuProvider,
IUpgradeableMachine {
    private static final int FUEL_TICK_MULTIPLIER = 20;
    public static final int OPERATION_TIME = 200;
    public static final int FUEL_USAGE = 20;
    public static final int FUEL_CAPACITY = 80000;
    public static final int SPAWN_RADIUS = 3;
    private final BaseItemStackHandler inventory;
    private final UpgradeItemStackHandler upgradeInventory;
    private final DynamicEnergyStorage energy;
    private final LazyOptional<IItemHandlerModifiable>[] inventoryCapabilities;
    private final LazyOptional<IEnergyStorage> energyCapability = LazyOptional.of(this::getEnergy);
    private final CachedRecipe<ISouliumSpawnerRecipe> recipe;
    private MachineUpgradeTier tier;
    private int progress;
    private int fuelLeft;
    private int fuelItemValue;
    private boolean isRunning;
    private double spin;
    private double oSpin;
    private DisplayEntity[] displayEntities;

    public SouliumSpawnerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.SOULIUM_SPAWNER.get(), pos, state);
        this.inventory = SouliumSpawnerTileEntity.createInventoryHandler(this::onInventoryChanged);
        this.upgradeInventory = new UpgradeItemStackHandler();
        this.energy = new DynamicEnergyStorage(80000, () -> ((SouliumSpawnerTileEntity)this).setChangedFast());
        this.inventoryCapabilities = SidedItemStackHandlerWrapper.create((BaseItemStackHandler)this.inventory, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH}, this::canInsertStackSided, null);
        this.recipe = new CachedRecipe((RecipeType)ModRecipeTypes.SOULIUM_SPAWNER.get());
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("Progress");
        this.fuelLeft = tag.m_128451_("FuelLeft");
        this.fuelItemValue = tag.m_128451_("FuelItemValue");
        this.energy.deserializeNBT(tag.m_128423_("Energy"));
        this.upgradeInventory.deserializeNBT(tag.m_128469_("UpgradeInventory"));
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Progress", this.progress);
        tag.m_128405_("FuelLeft", this.fuelLeft);
        tag.m_128405_("FuelItemValue", this.fuelItemValue);
        tag.m_128365_("Energy", this.energy.serializeNBT());
        tag.m_128365_("UpgradeInventory", (Tag)this.upgradeInventory.serializeNBT());
    }

    public void onLoad() {
        super.onLoad();
        this.reloadActiveRecipe();
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet) {
        super.onDataPacket(connection, packet);
        this.reloadActiveRecipe();
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.reloadActiveRecipe();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.m_58901_()) {
            if (cap == ForgeCapabilities.ENERGY) {
                return ForgeCapabilities.ENERGY.orEmpty(cap, this.energyCapability);
            }
            if (side != null && cap == ForgeCapabilities.ITEM_HANDLER) {
                if (side == Direction.UP) {
                    return this.inventoryCapabilities[0].cast();
                }
                if (side == Direction.DOWN) {
                    return this.inventoryCapabilities[1].cast();
                }
                return this.inventoryCapabilities[2].cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public Component m_5446_() {
        return Localizable.of((String)"container.mysticalagriculture.soulium_spawner").build();
    }

    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return SouliumSpawnerContainer.create(id, playerInventory, this.inventory, this.upgradeInventory, this.m_58899_());
    }

    @Override
    public UpgradeItemStackHandler getUpgradeInventory() {
        return this.upgradeInventory;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SouliumSpawnerTileEntity tile) {
        MachineUpgradeTier tier;
        if (tile.energy.getEnergyStored() < tile.energy.getMaxEnergyStored()) {
            ItemStack fuel = tile.inventory.getStackInSlot(1);
            if (tile.fuelLeft <= 0 && !fuel.m_41619_()) {
                tile.fuelItemValue = ForgeHooks.getBurnTime((ItemStack)fuel, null);
                if (tile.fuelItemValue > 0) {
                    tile.fuelLeft = tile.fuelItemValue *= 20;
                    tile.inventory.setStackInSlot(1, StackHelper.shrink((ItemStack)fuel, (int)1, (boolean)true));
                    tile.setChangedFast();
                }
            }
            if (tile.fuelLeft > 0) {
                int fuelPerTick = Math.min(Math.min(tile.fuelLeft, tile.getFuelUsage() * 2), tile.energy.getMaxEnergyStored() - tile.energy.getEnergyStored());
                tile.fuelLeft -= tile.energy.receiveEnergy(fuelPerTick, false);
                if (tile.fuelLeft <= 0) {
                    tile.fuelItemValue = 0;
                }
                tile.setChangedFast();
            }
        }
        if ((tier = tile.getMachineTier()) != tile.tier) {
            tile.tier = tier;
            if (tier == null) {
                tile.energy.resetMaxEnergyStorage();
            } else {
                tile.energy.setMaxEnergyStorage((int)(80000.0 * tier.getFuelCapacityMultiplier()));
            }
            tile.setChangedFast();
        }
        boolean isDisabled = level.m_276867_(tile.m_58899_());
        boolean wasRunning = tile.isRunning;
        tile.isRunning = false;
        if (tile.energy.getEnergyStored() >= tile.getFuelUsage() && !isDisabled) {
            ItemStack input = tile.inventory.getStackInSlot(0);
            if (!input.m_41619_()) {
                ISouliumSpawnerRecipe recipe = tile.getActiveRecipe();
                if (recipe != null && input.m_41613_() >= recipe.getInputCount()) {
                    tile.isRunning = true;
                    ++tile.progress;
                    tile.energy.extractEnergy(tile.getFuelUsage(), false);
                    if (tile.progress >= tile.getOperationTime() && tile.attemptSpawn(recipe)) {
                        tile.inventory.setStackInSlot(0, StackHelper.shrink((ItemStack)input, (int)recipe.getInputCount(), (boolean)false));
                        tile.progress = 0;
                        tile.sendSpawnParticles();
                    }
                    tile.setChangedFast();
                }
            } else {
                tile.isRunning = false;
                if (tile.progress > 0) {
                    tile.progress = 0;
                    tile.setChangedFast();
                }
            }
        }
        if (wasRunning != tile.isRunning) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SouliumSpawnerBlock.RUNNING, (Comparable)Boolean.valueOf(tile.isRunning)), 3);
            tile.setChangedFast();
        }
        tile.dispatchIfChanged();
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, SouliumSpawnerTileEntity tile) {
        Boolean isRunning = (Boolean)state.m_61143_((Property)SouliumSpawnerBlock.RUNNING);
        double spinSpeed = isRunning != false ? 200.0 : 400.0;
        tile.oSpin = tile.spin;
        tile.spin = (tile.spin + 1000.0 / spinSpeed) % 360.0;
        if (isRunning.booleanValue()) {
            tile.sendRunningParticles();
        }
    }

    public static BaseItemStackHandler createInventoryHandler() {
        return SouliumSpawnerTileEntity.createInventoryHandler(null);
    }

    public static BaseItemStackHandler createInventoryHandler(Runnable onContentsChanged) {
        return BaseItemStackHandler.create((int)2, (Runnable)onContentsChanged, builder -> builder.addSlotLimit(0, 512));
    }

    public ISouliumSpawnerRecipe getActiveRecipe() {
        return (ISouliumSpawnerRecipe)this.recipe.get();
    }

    public DynamicEnergyStorage getEnergy() {
        return this.energy;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getOperationTime() {
        if (this.tier == null) {
            return 200;
        }
        return (int)(200.0 * this.tier.getOperationTimeMultiplier());
    }

    public int getFuelLeft() {
        return this.fuelLeft;
    }

    public int getFuelItemValue() {
        return this.fuelItemValue;
    }

    public int getFuelUsage() {
        if (this.tier == null) {
            return 20;
        }
        return (int)(20.0 * this.tier.getFuelUsageMultiplier());
    }

    public double getSpin() {
        return this.spin;
    }

    public double getoSpin() {
        return this.oSpin;
    }

    public DisplayEntity getDisplayEntity() {
        if (this.displayEntities == null) {
            return null;
        }
        int index = Math.toIntExact(System.currentTimeMillis() / 2000L % (long)this.displayEntities.length);
        return this.displayEntities[index];
    }

    private boolean attemptSpawn(ISouliumSpawnerRecipe recipe) {
        if (this.f_58857_ == null) {
            return false;
        }
        Entity entity = recipe.getRandomEntityType(this.f_58857_.f_46441_).map(e -> ((EntityType)e.m_146310_()).m_20615_(this.f_58857_)).orElse(null);
        if (entity == null) {
            return false;
        }
        long entities = this.f_58857_.m_45976_(entity.getClass(), AABB.m_165882_((Vec3)this.m_58899_().m_252807_(), (double)6.0, (double)6.0, (double)6.0)).stream().filter(Entity::m_6084_).count();
        if (entities >= 32L) {
            return false;
        }
        List<BlockPos> positions = BlockPos.m_121990_((BlockPos)this.m_58899_().m_7918_(-3, 0, -3), (BlockPos)this.m_58899_().m_7918_(3, 0, 3)).map(BlockPos::m_7949_).toList();
        BlockPos pos = positions.get(this.f_58857_.f_46441_.m_188503_(positions.size()));
        entity.m_20084_(UUID.randomUUID());
        entity.m_7678_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), this.f_58857_.f_46441_.m_188501_() * 360.0f, 0.0f);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_6518_((ServerLevelAccessor)this.f_58857_, this.f_58857_.m_6436_(this.m_58899_()), MobSpawnType.MOB_SUMMONED, null, null);
        }
        int attempts = 20;
        while (attempts-- > 0 && !this.canEntitySpawn(entity)) {
            pos = positions.get(this.f_58857_.f_46441_.m_188503_(positions.size()));
            entity.m_7678_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), this.f_58857_.f_46441_.m_188501_() * 360.0f, 0.0f);
        }
        if (attempts <= 0) {
            return false;
        }
        this.f_58857_.m_7967_(entity);
        return true;
    }

    private boolean canEntitySpawn(Entity entity) {
        return this.f_58857_ != null && this.f_58857_.m_45784_(entity) && !this.f_58857_.m_46855_(entity.m_20191_());
    }

    private void onInventoryChanged() {
        this.reloadActiveRecipe();
        this.setChangedFast();
    }

    private void reloadActiveRecipe() {
        if (this.f_58857_ == null) {
            return;
        }
        ISouliumSpawnerRecipe recipe = (ISouliumSpawnerRecipe)this.recipe.checkAndGet(this.inventory, this.f_58857_);
        if (recipe != null) {
            List entities = recipe.getEntityTypes().m_146338_();
            Integer totalWeight = entities.stream().map(e -> e.m_142631_().m_146281_()).reduce(0, Integer::sum);
            this.displayEntities = (DisplayEntity[])entities.stream().map(e -> new DisplayEntity(((EntityType)e.m_146310_()).m_20615_(this.f_58857_), (double)e.m_142631_().m_146281_() / (double)totalWeight.intValue() * 100.0)).toArray(DisplayEntity[]::new);
        } else {
            this.displayEntities = null;
        }
    }

    private void sendRunningParticles() {
        if (this.f_58857_ == null) {
            return;
        }
        BlockPos pos = this.m_58899_();
        double x = (double)pos.m_123341_() + Math.random() / 2.0 + 0.25;
        double y = (double)pos.m_123342_() + Math.random() / 2.0 + 0.25;
        double z = (double)pos.m_123343_() + Math.random() / 2.0 + 0.25;
        this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 0.0, 0.0, 0.0);
    }

    private void sendSpawnParticles() {
        if (this.m_58904_() == null || this.m_58904_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.m_58904_();
        BlockPos pos = this.m_58899_();
        for (int i = 0; i < 20; ++i) {
            double x = (double)pos.m_123341_() + Math.random();
            double y = (double)pos.m_123342_() + Math.random();
            double z = (double)pos.m_123343_() + Math.random();
            level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
        }
    }

    private boolean canInsertStackSided(int slot, ItemStack stack, Direction direction) {
        if (direction == null) {
            return true;
        }
        if (slot == 0 && direction == Direction.UP) {
            return RecipeIngredientCache.INSTANCE.isValidInput(stack, (RecipeType)ModRecipeTypes.SOULIUM_SPAWNER.get());
        }
        if (slot == 1 && direction == Direction.NORTH) {
            return FurnaceBlockEntity.m_58399_((ItemStack)stack);
        }
        return false;
    }

    public record DisplayEntity(Entity entity, double chance) {
    }
}

