/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.lib;

import com.blakebr0.mysticalagriculture.api.IMysticalAgriculturePlugin;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalagriculture.api.crop.CropType;
import com.blakebr0.mysticalagriculture.api.lib.PluginConfig;
import com.blakebr0.mysticalagriculture.api.registry.IAugmentRegistry;
import com.blakebr0.mysticalagriculture.api.registry.ICropRegistry;
import com.blakebr0.mysticalagriculture.api.registry.IMobSoulTypeRegistry;
import com.blakebr0.mysticalagriculture.init.ModBlocks;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.lib.ModAugments;
import com.blakebr0.mysticalagriculture.lib.ModCrops;
import com.blakebr0.mysticalagriculture.lib.ModMobSoulTypes;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public final class ModCorePlugin
implements IMysticalAgriculturePlugin {
    @Override
    public void configure(PluginConfig config) {
        config.setModId("mysticalagriculture");
        config.disableDynamicSeedCraftingRecipes();
        config.disableDynamicSeedInfusionRecipes();
        config.disableDynamicSeedReprocessingRecipes();
    }

    @Override
    public void onRegisterCrops(ICropRegistry registry) {
        registry.registerTier(CropTier.ELEMENTAL);
        registry.registerTier(CropTier.ONE);
        registry.registerTier(CropTier.TWO);
        registry.registerTier(CropTier.THREE);
        registry.registerTier(CropTier.FOUR);
        registry.registerTier(CropTier.FIVE);
        registry.registerType(CropType.RESOURCE);
        registry.registerType(CropType.MOB);
        ModCrops.onRegisterCrops(registry);
    }

    @Override
    public void onPostRegisterCrops(ICropRegistry registry) {
        CropTier.ELEMENTAL.setFarmland((Supplier<? extends Block>)ModBlocks.INFERIUM_FARMLAND).setEssence((Supplier<? extends Item>)ModItems.INFERIUM_ESSENCE);
        CropTier.ONE.setFarmland((Supplier<? extends Block>)ModBlocks.INFERIUM_FARMLAND).setEssence((Supplier<? extends Item>)ModItems.INFERIUM_ESSENCE);
        CropTier.TWO.setFarmland((Supplier<? extends Block>)ModBlocks.PRUDENTIUM_FARMLAND).setEssence((Supplier<? extends Item>)ModItems.PRUDENTIUM_ESSENCE);
        CropTier.THREE.setFarmland((Supplier<? extends Block>)ModBlocks.TERTIUM_FARMLAND).setEssence((Supplier<? extends Item>)ModItems.TERTIUM_ESSENCE);
        CropTier.FOUR.setFarmland((Supplier<? extends Block>)ModBlocks.IMPERIUM_FARMLAND).setEssence((Supplier<? extends Item>)ModItems.IMPERIUM_ESSENCE);
        CropTier.FIVE.setFarmland((Supplier<? extends Block>)ModBlocks.SUPREMIUM_FARMLAND).setEssence((Supplier<? extends Item>)ModItems.SUPREMIUM_ESSENCE);
        CropType.RESOURCE.setCraftingSeed((Supplier<? extends Item>)ModItems.PROSPERITY_SEED_BASE);
        CropType.MOB.setCraftingSeed((Supplier<? extends Item>)ModItems.SOULIUM_SEED_BASE);
    }

    @Override
    public void onRegisterMobSoulTypes(IMobSoulTypeRegistry registry) {
        ModMobSoulTypes.onRegisterMobSoulTypes(registry);
    }

    @Override
    public void onRegisterAugments(IAugmentRegistry registry) {
        ModAugments.onRegisterAugments(registry);
    }
}

