/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.data.recipe;

import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.lib.LazyIngredient;
import com.blakebr0.mysticalagriculture.crafting.condition.CropEnabledCondition;
import com.blakebr0.mysticalagriculture.crafting.condition.CropHasMaterialCondition;
import com.blakebr0.mysticalagriculture.crafting.condition.SeedCraftingRecipesEnabledCondition;
import com.blakebr0.mysticalagriculture.crafting.ingredient.CropComponentIngredient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.registries.ForgeRegistries;

public class CraftingRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<String> pattern = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private final JsonArray conditions = new JsonArray();
    private String group = "";

    public CraftingRecipeBuilder(ItemLike output, int count) {
        this.result = output.m_5456_();
        this.count = count;
    }

    public void addKey(char key, Ingredient ingredient) {
        this.key.put(Character.valueOf(key), ingredient);
    }

    public void addPatternLine(String line) {
        this.pattern.add(line);
    }

    public void addCondition(JsonObject condition) {
        this.conditions.add((JsonElement)condition);
    }

    public static CraftingRecipeBuilder newSeedRecipe(Crop crop) {
        CraftingRecipeBuilder builder = new CraftingRecipeBuilder((ItemLike)crop.getSeedsItem(), 1);
        CropComponentIngredient essence = new CropComponentIngredient(crop, CropComponentIngredient.ComponentType.ESSENCE);
        CropComponentIngredient seed = new CropComponentIngredient(crop, CropComponentIngredient.ComponentType.SEED);
        CropComponentIngredient material = new CropComponentIngredient(crop, CropComponentIngredient.ComponentType.MATERIAL);
        builder.group = "mysticalagriculture:seeds";
        builder.addKey('E', essence);
        builder.addKey('S', seed);
        builder.addKey('M', material);
        builder.addPatternLine("MEM");
        builder.addPatternLine("ESE");
        builder.addPatternLine("MEM");
        JsonObject condition = new JsonObject();
        condition.addProperty("type", SeedCraftingRecipesEnabledCondition.Serializer.INSTANCE.getID().toString());
        builder.addCondition(condition);
        condition = new JsonObject();
        condition.addProperty("type", CropEnabledCondition.Serializer.INSTANCE.getID().toString());
        condition.addProperty("crop", crop.getId().toString());
        builder.addCondition(condition);
        condition = new JsonObject();
        condition.addProperty("type", CropHasMaterialCondition.Serializer.INSTANCE.getID().toString());
        condition.addProperty("crop", crop.getId().toString());
        builder.addCondition(condition);
        LazyIngredient ingredient = crop.getLazyIngredient();
        if (ingredient.isTag()) {
            JsonObject tagEmptyCondition = new JsonObject();
            tagEmptyCondition.addProperty("type", TagEmptyCondition.Serializer.INSTANCE.getID().toString());
            tagEmptyCondition.addProperty("tag", ingredient.getId());
            condition = new JsonObject();
            condition.addProperty("type", "forge:not");
            condition.add("value", (JsonElement)tagEmptyCondition);
            builder.addCondition(condition);
        }
        return builder;
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.result, this.count, this.group, this.pattern, this.key, this.conditions));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, Ingredient> key;
        private final JsonArray conditions;

        public Result(ResourceLocation id, Item result, int count, String group, List<String> pattern, Map<Character, Ingredient> key, JsonArray conditions) {
            this.id = id;
            this.result = result;
            this.count = count;
            this.group = group;
            this.pattern = pattern;
            this.key = key;
            this.conditions = conditions;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("conditions", (JsonElement)this.conditions);
            JsonArray pattern = new JsonArray();
            this.pattern.forEach(arg_0 -> ((JsonArray)pattern).add(arg_0));
            json.add("pattern", (JsonElement)pattern);
            JsonObject key = new JsonObject();
            this.key.forEach((c, i) -> key.add(c.toString(), i.m_43942_()));
            json.add("key", (JsonElement)key);
            JsonObject result = new JsonObject();
            result.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.result).toString());
            if (this.count > 1) {
                result.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)result);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return RecipeSerializer.f_44076_;
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

