/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.client;

import com.blakebr0.cucumber.helper.ParsingHelper;
import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.google.common.base.Stopwatch;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.registries.ForgeRegistries;

public class EssenceVesselColorManager
implements PreparableReloadListener {
    public static final EssenceVesselColorManager INSTANCE = new EssenceVesselColorManager();
    private final HashMap<String, Integer> colors = new HashMap();

    @SubscribeEvent
    public void onRegisterClientReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)this);
    }

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier barrier, ResourceManager manager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return CompletableFuture.runAsync(() -> {
            if (ModLoader.isLoadingStateValid()) {
                this.load(manager);
            }
        }, backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)barrier).m_6769_(arg_0));
    }

    public int getColor(ItemStack stack) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (id == null) {
            return 0xFFFFFF;
        }
        return this.colors.getOrDefault(id.toString(), 0xFFFFFF);
    }

    private void load(ResourceManager manager) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Map resources = manager.m_214159_("essence_vessel_colors.json", s -> s.m_135815_().endsWith(".json"));
        this.colors.clear();
        for (Map.Entry resource : resources.entrySet()) {
            try {
                BufferedReader reader = ((Resource)resource.getValue()).m_215508_();
                try {
                    JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    for (Map.Entry entry : json.entrySet()) {
                        String item = (String)entry.getKey();
                        int color = ParsingHelper.parseHex((String)((JsonElement)entry.getValue()).getAsString(), (String)item);
                        this.colors.put(item, color);
                    }
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException e) {
                MysticalAgriculture.LOGGER.error("Failed to load {}", resource.getKey(), (Object)e);
            }
        }
        MysticalAgriculture.LOGGER.info("Loaded {} essence vessel colors in {} ms", (Object)this.colors.size(), (Object)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
    }
}

