/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.augment;

import com.blakebr0.cucumber.helper.ColorHelper;
import com.blakebr0.mysticalagriculture.api.lib.AbilityCache;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import java.util.EnumSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SpeedAugment
extends Augment {
    private final int amplifier;

    public SpeedAugment(ResourceLocation id, int tier, int amplifier) {
        super(id, tier, EnumSet.of(AugmentType.LEGGINGS), SpeedAugment.getColor(11358797, tier), SpeedAugment.getColor(2361349, tier));
        this.amplifier = amplifier;
    }

    @Override
    public void onPlayerTick(Level level, Player player, AbilityCache cache) {
        boolean flying = player.m_150110_().f_35935_;
        boolean swimming = player.m_6069_();
        boolean inWater = player.m_20069_();
        if (player.m_20096_() || flying || swimming || inWater) {
            boolean sneaking = player.m_6047_();
            boolean sprinting = player.m_20142_();
            float speed = 0.1f * (flying ? 0.6f : 1.0f) * (sneaking ? 0.1f : 1.0f) * (!sprinting ? 0.6f : 1.2f) * (inWater ? 0.5f : 1.0f) * (swimming ? 0.8f : 1.0f) * (float)this.amplifier;
            if (player.f_20902_ > 0.0f) {
                player.m_19920_(1.0f, new Vec3(0.0, 0.0, (double)speed));
            } else if (player.f_20902_ < 0.0f) {
                player.m_19920_(1.0f, new Vec3(0.0, 0.0, (double)(-speed * 0.3f)));
            }
            if (player.f_20900_ != 0.0f) {
                player.m_19920_(1.0f, new Vec3((double)(speed * 0.5f * Math.signum(player.f_20900_)), 0.0, 0.0));
            }
        }
    }

    private static int getColor(int color, int tier) {
        return ColorHelper.saturate((int)color, (float)Math.min((float)tier / 4.0f, 1.0f));
    }
}

