/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.util;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ExperienceCapsuleUtils {
    public static final int MAX_XP_POINTS = 1200;

    public static CompoundTag makeTag(int xp) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("Experience", Math.min(1200, xp));
        return nbt;
    }

    public static ItemStack getExperienceCapsule(int xp, Item item) {
        CompoundTag nbt = ExperienceCapsuleUtils.makeTag(xp);
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.m_41751_(nbt);
        return stack;
    }

    public static int getExperience(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_("Experience")) {
            return nbt.m_128451_("Experience");
        }
        return 0;
    }

    public static int addExperienceToCapsule(ItemStack stack, int amount) {
        int xp = ExperienceCapsuleUtils.getExperience(stack);
        if (xp >= 1200) {
            return amount;
        }
        int newAmount = Math.min(1200, xp + amount);
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            CompoundTag tag = ExperienceCapsuleUtils.makeTag(newAmount);
            stack.m_41751_(tag);
        } else {
            nbt.m_128405_("Experience", newAmount);
        }
        return Math.max(0, amount - (newAmount - xp));
    }

    public static int removeExperienceFromCapsule(ItemStack stack, int amount) {
        int xp = ExperienceCapsuleUtils.getExperience(stack);
        int newAmount = Math.max(0, xp - amount);
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            CompoundTag tag = ExperienceCapsuleUtils.makeTag(newAmount);
            stack.m_41751_(tag);
        } else {
            nbt.m_128405_("Experience", newAmount);
        }
        return Math.max(0, amount - xp);
    }
}

