/*
 * Decompiled with CFR 0.152.
 */
package jackyy.gunpowderlib.helper;

import jackyy.gunpowderlib.capability.FEStorageCapability;
import jackyy.gunpowderlib.helper.NBTHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class EnergyHelper {
    public static final String ENERGY_NBT = "Energy";

    public static ItemStack setDefaultEnergyTag(ItemStack stack, int energy) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        stack.m_41784_().m_128405_(ENERGY_NBT, energy);
        return stack;
    }

    public static int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (!container.m_41782_()) {
            EnergyHelper.setDefaultEnergyTag(container, 0);
        }
        int stored = EnergyHelper.getEnergyStored(container);
        int received = Math.min(EnergyHelper.getMaxEnergyStored(container) - stored, Math.min(EnergyHelper.getMaxEnergyStored(container) / 4, maxReceive));
        if (!simulate) {
            NBTHelper.setInt(container, ENERGY_NBT, stored += received);
        }
        return received;
    }

    public static int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (!container.m_41784_().m_128441_(ENERGY_NBT)) {
            return 0;
        }
        int stored = EnergyHelper.getEnergyStored(container);
        int extracted = Math.min(stored, Math.min(EnergyHelper.getMaxEnergyStored(container) / 4, maxExtract));
        if (!simulate) {
            NBTHelper.setInt(container, ENERGY_NBT, stored -= extracted);
        }
        return extracted;
    }

    public static int getEnergyStored(ItemStack container) {
        if (!container.m_41784_().m_128441_(ENERGY_NBT)) {
            return 0;
        }
        return Math.min(NBTHelper.getInt(container, ENERGY_NBT), EnergyHelper.getMaxEnergyStored(container));
    }

    public static int getMaxEnergyStored(ItemStack container) {
        FEStorageCapability storage = (FEStorageCapability)container.getCapability(ForgeCapabilities.ENERGY, null).orElse(null);
        return storage != null ? storage.getMaxEnergyStored() : 0;
    }
}

