/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.block;

import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.ForceRelayBlock;
import vazkii.botania.test.TestingUtil;

public class ForceRelayTest {
    @GameTest(m_177046_="botania:block/piston_relay_basic")
    public void testBasic(GameTestHelper helper) {
        BlockPos initialRelay = new BlockPos(4, 2, 2);
        BlockPos initialAndesite = new BlockPos(4, 4, 5);
        BlockPos initialSlimeUnderAndesite = initialAndesite.m_7495_();
        BlockPos initialDiorite = new BlockPos(3, 4, 5);
        BlockPos initialSlimeUnderDiorite = initialDiorite.m_7495_();
        ForceRelayBlock.WorldData data = ForceRelayBlock.WorldData.get((Level)helper.m_177100_());
        data.mapping.put(helper.m_177449_(initialRelay), helper.m_177449_(initialSlimeUnderDiorite));
        helper.m_177425_().m_177562_(() -> {
            BlockPos activateFirstPiston = new BlockPos(4, 2, 0);
            helper.m_177245_(activateFirstPiston, Blocks.f_50330_);
        }).m_177546_(4, () -> {
            helper.m_177208_(BotaniaBlocks.pistonRelay, initialRelay.m_122019_());
            helper.m_177208_(Blocks.f_50334_, initialAndesite.m_122019_());
            helper.m_177208_(Blocks.f_50374_, initialSlimeUnderAndesite.m_122019_());
            helper.m_177208_(Blocks.f_50228_, initialDiorite.m_122019_());
            helper.m_177208_(Blocks.f_50374_, initialSlimeUnderDiorite.m_122019_());
        }).m_177562_(() -> {
            BlockPos activateSecondPiston = new BlockPos(6, 2, 3);
            helper.m_177245_(activateSecondPiston, Blocks.f_50330_);
        }).m_177546_(4, () -> {
            BlockPos relayPos = initialRelay.m_122019_().m_122024_();
            helper.m_177208_(BotaniaBlocks.pistonRelay, relayPos);
            helper.m_177208_(Blocks.f_50334_, initialAndesite.m_122019_().m_122024_());
            helper.m_177208_(Blocks.f_50374_, initialSlimeUnderAndesite.m_122019_().m_122024_());
            helper.m_177208_(Blocks.f_50228_, initialDiorite.m_122019_().m_122024_());
            helper.m_177208_(Blocks.f_50374_, initialSlimeUnderDiorite.m_122019_().m_122024_());
            helper.m_177434_(relayPos);
            TestingUtil.assertThat(!data.mapping.containsKey(relayPos), () -> "Removing relay should remove internal mapping");
        }).m_177543_();
    }

    @GameTest(m_177046_="botania:block/piston_relay_immovable")
    public void testImmovable(GameTestHelper helper) {
        BlockPos initialRelay = new BlockPos(1, 2, 1);
        BlockPos initialCobble = new BlockPos(1, 2, 0);
        ForceRelayBlock.WorldData data = ForceRelayBlock.WorldData.get((Level)helper.m_177100_());
        data.mapping.put(helper.m_177449_(initialRelay), helper.m_177449_(initialCobble));
        helper.m_177425_().m_177562_(() -> {
            BlockPos lever = new BlockPos(2, 2, 2);
            helper.m_177421_(lever);
        }).m_177546_(4, () -> {
            BlockPos relayAfter = new BlockPos(0, 2, 1);
            helper.m_177208_(BotaniaBlocks.pistonRelay, relayAfter);
            helper.m_177208_(Blocks.f_50652_, initialCobble);
            TestingUtil.assertEquals(data.mapping.get(helper.m_177449_(relayAfter)), helper.m_177449_(initialCobble), () -> "If destination block cannot move, the relay should move but retain binding to the destination block's original position");
        }).m_177543_();
    }

    @GameTest(m_177046_="botania:block/piston_relay_sticky_move_no_pull")
    public void testStickyPistonMoveNotPropagated(GameTestHelper helper) {
        BlockPos initialRelay = new BlockPos(1, 2, 2);
        BlockPos initialGranite = new BlockPos(3, 2, 3);
        BlockPos stickyPistonButton = new BlockPos(1, 2, 0);
        BlockPos nonstickyPistonButton = new BlockPos(1, 2, 5);
        ForceRelayBlock.WorldData data = ForceRelayBlock.WorldData.get((Level)helper.m_177100_());
        data.mapping.put(helper.m_177449_(initialRelay), helper.m_177449_(initialGranite));
        helper.m_177425_().m_177562_(() -> helper.m_177385_(stickyPistonButton)).m_177546_(4, () -> {
            BlockPos relayAfter = initialRelay.m_122019_();
            helper.m_177208_(BotaniaBlocks.pistonRelay, relayAfter);
            helper.m_177208_(Blocks.f_50175_, initialGranite);
            TestingUtil.assertEquals(data.mapping.get(helper.m_177449_(relayAfter)), helper.m_177449_(initialGranite), () -> "If relay is moved directly via sticky piston, it should update its source location, but retain the binding to the destination block's original position");
            TestingUtil.assertEquals(data.mapping.get(helper.m_177449_(initialRelay)), null, () -> "If relay is moved for whatever reason, its location data should be updated");
        }).m_177546_(20, () -> {
            BlockPos relayAfter = initialRelay.m_122019_();
            helper.m_177208_(BotaniaBlocks.pistonRelay, relayAfter);
            helper.m_177208_(Blocks.f_50175_, initialGranite);
            TestingUtil.assertEquals(data.mapping.get(helper.m_177449_(relayAfter)), helper.m_177449_(initialGranite), () -> "If a sticky piston retracts from the relay, neither the relay nor its bound location should change");
            TestingUtil.assertEquals(data.mapping.get(helper.m_177449_(initialRelay)), null, () -> "If relay is not moved, its location data should not change");
        }).m_177562_(() -> helper.m_177385_(nonstickyPistonButton)).m_177546_(4, () -> {
            BlockPos graniteAfter = initialGranite.m_122012_();
            helper.m_177208_(BotaniaBlocks.pistonRelay, initialRelay);
            helper.m_177208_(Blocks.f_50175_, graniteAfter);
            TestingUtil.assertEquals(data.mapping.get(helper.m_177449_(initialRelay)), helper.m_177449_(graniteAfter), () -> "If relay is moved directly via non-sticky piston, it should update its source and bound locations");
            TestingUtil.assertEquals(data.mapping.get(helper.m_177449_(initialRelay.m_122019_())), null, () -> "If relay is moved for whatever reason, its location data should be updated");
        }).m_177543_();
    }

    @GameTest(m_177046_="botania:block/piston_relay_structure_pull")
    public void testMovingInPistonStructure(GameTestHelper helper) {
        BlockPos button = new BlockPos(0, 2, 1);
        BlockPos initialRelay1 = new BlockPos(3, 2, 2);
        BlockPos initialRelay2 = new BlockPos(3, 2, 5);
        BlockPos initialBoundSlime = new BlockPos(2, 2, 4);
        BlockPos initialAndesite = new BlockPos(3, 4, 3);
        ForceRelayBlock.WorldData data = ForceRelayBlock.WorldData.get((Level)helper.m_177100_());
        data.mapping.put(helper.m_177449_(initialRelay1), helper.m_177449_(initialBoundSlime));
        data.mapping.put(helper.m_177449_(initialRelay2), helper.m_177449_(initialAndesite));
        helper.m_177425_().m_177562_(() -> helper.m_177385_(button)).m_177546_(4, () -> {
            helper.m_177208_(BotaniaBlocks.pistonRelay, initialRelay1.m_122029_());
            helper.m_177208_(BotaniaBlocks.pistonRelay, initialRelay2.m_122029_());
            helper.m_177357_(initialBoundSlime, BlockBehaviour.BlockStateBase::m_60795_, () -> "Second slime block structure should have moved, leaving behind an air block at the originally bound location");
            helper.m_177208_(Blocks.f_50387_, initialAndesite.m_122029_());
            TestingUtil.assertEquals(data.mapping.get(helper.m_177449_(initialRelay1.m_122029_())), helper.m_177449_(initialBoundSlime.m_122029_()), () -> "Even if the structure was pushed by a sticky piston, the relay and bound locations should have been updated, since the relay was not pushed directly.");
            TestingUtil.assertEquals(data.mapping.get(helper.m_177449_(initialRelay2.m_122029_())), helper.m_177449_(initialAndesite.m_122029_()), () -> "If a relay is moved indirectly as part of a block structure, its location and the bound block's location data should have been updated.");
            TestingUtil.assertEquals(data.mapping.get(helper.m_177449_(initialRelay1)), null, () -> "If relay is moved for whatever reason, its location data should be updated");
            TestingUtil.assertEquals(data.mapping.get(helper.m_177449_(initialRelay2)), null, () -> "If relay is moved for whatever reason, its location data should be updated");
        }).m_177546_(24, () -> {
            helper.m_177208_(BotaniaBlocks.pistonRelay, initialRelay1);
            helper.m_177208_(BotaniaBlocks.pistonRelay, initialRelay2);
            helper.m_177208_(Blocks.f_50374_, initialBoundSlime);
            helper.m_177208_(Blocks.f_50387_, initialAndesite);
            TestingUtil.assertEquals(data.mapping.get(helper.m_177449_(initialRelay1)), helper.m_177449_(initialBoundSlime), () -> "Even if the structure was pushed by a sticky piston, the relay and bound locations should have been updated, since the relay was not pushed directly.");
            TestingUtil.assertEquals(data.mapping.get(helper.m_177449_(initialRelay2)), helper.m_177449_(initialAndesite), () -> "If a relay is moved indirectly as part of a block structure, its location and the bound block's location data should have been updated.");
            TestingUtil.assertEquals(data.mapping.get(helper.m_177449_(initialRelay1.m_122029_())), null, () -> "If relay is moved for whatever reason, its location data should be updated");
            TestingUtil.assertEquals(data.mapping.get(helper.m_177449_(initialRelay2.m_122029_())), null, () -> "If relay is moved for whatever reason, its location data should be updated");
        }).m_177543_();
    }
}

