/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.network.clientbound;

import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.client.gui.ItemsRemainingRenderHandler;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.network.BotaniaPacket;

public record UpdateItemsRemainingPacket(ItemStack stack, int count, @Nullable Component tooltip) implements BotaniaPacket
{
    public static final ResourceLocation ID = ResourceLocationHelper.prefix("rem");

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130055_(this.stack);
        buf.m_130130_(this.count);
        buf.writeBoolean(this.tooltip != null);
        if (this.tooltip != null) {
            buf.m_130083_(this.tooltip);
        }
    }

    @Override
    public ResourceLocation getFabricId() {
        return ID;
    }

    public static UpdateItemsRemainingPacket decode(FriendlyByteBuf buf) {
        return new UpdateItemsRemainingPacket(buf.m_130267_(), buf.m_130242_(), buf.readBoolean() ? buf.m_130238_() : null);
    }

    public static class Handler {
        public static void handle(UpdateItemsRemainingPacket packet) {
            ItemStack stack = packet.stack();
            int count = packet.count();
            Component tooltip = packet.tooltip();
            Minecraft.m_91087_().execute(() -> ItemsRemainingRenderHandler.set(stack, count, tooltip));
        }
    }
}

