/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.forge;

import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.internal_caps.SerializableComponent;

public final class CapabilityUtil {
    private static final Map<Capability<?>, Map<Block, Provider<?>>> BLOCK_LOOKASIDE = new IdentityHashMap();

    public static <T, U extends T> ICapabilityProvider makeProvider(Capability<T> cap, U instance) {
        LazyOptional lazyInstanceButNotReally = LazyOptional.of(() -> instance);
        return new CapProvider<T>(cap, lazyInstanceButNotReally);
    }

    public static <T extends SerializableComponent> ICapabilityProvider makeSavedProvider(Capability<T> cap, T instance) {
        return new CapProviderSerializable<T>(cap, instance);
    }

    public static <T> void registerBlockLookaside(Capability<T> cap, Provider<T> provider, Block ... blocks) {
        Map inner = BLOCK_LOOKASIDE.computeIfAbsent(cap, k -> new HashMap());
        for (Block block : blocks) {
            inner.put(block, provider);
        }
    }

    @Nullable
    public static <T> T findCapability(Capability<T> capability, Level level, BlockPos pos, BlockState state, @Nullable BlockEntity be) {
        return CapabilityUtil.findCapability(capability, level, pos, state, be, null);
    }

    @Nullable
    public static <T> T findCapability(Capability<T> capability, Level level, BlockPos pos, BlockState state, @Nullable BlockEntity be, @Nullable Direction direction) {
        LazyOptional instance;
        if (be != null && (instance = be.getCapability(capability, direction)).isPresent()) {
            return (T)instance.orElseThrow(NullPointerException::new);
        }
        Provider provider = (Provider)BLOCK_LOOKASIDE.getOrDefault(capability, Collections.emptyMap()).get(state.m_60734_());
        if (provider != null) {
            Object instance2 = provider.find(level, pos, state);
            return instance2;
        }
        return null;
    }

    private CapabilityUtil() {
    }

    private static class CapProvider<T>
    implements ICapabilityProvider {
        protected final Capability<T> cap;
        protected final LazyOptional<T> lazyInstanceButNotReally;

        public CapProvider(Capability<T> cap, LazyOptional<T> instance) {
            this.cap = cap;
            this.lazyInstanceButNotReally = instance;
        }

        @NotNull
        public <C> LazyOptional<C> getCapability(@NotNull Capability<C> queryCap, @Nullable Direction side) {
            return this.cap.orEmpty(queryCap, this.lazyInstanceButNotReally);
        }
    }

    private static class CapProviderSerializable<T extends SerializableComponent>
    extends CapProvider<T>
    implements INBTSerializable<CompoundTag> {
        public CapProviderSerializable(Capability<T> cap, T instance) {
            super(cap, LazyOptional.of(() -> instance));
        }

        public CompoundTag serializeNBT() {
            return this.lazyInstanceButNotReally.map(SerializableComponent::serializeNBT).orElse(null);
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.lazyInstanceButNotReally.ifPresent(i -> i.deserializeNBT(nbt));
        }
    }

    public static interface Provider<T> {
        @Nullable
        public T find(Level var1, BlockPos var2, BlockState var3);
    }

    public static class WaterBowlFluidHandler
    extends FluidHandlerItemStackSimple.SwapEmpty {
        public WaterBowlFluidHandler(ItemStack stack) {
            super(stack, new ItemStack((ItemLike)Items.f_42399_), 1000);
            this.setFluid(new FluidStack((Fluid)Fluids.f_76193_, 1000));
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return false;
        }

        public boolean canDrainFluidType(FluidStack fluid) {
            return fluid.getFluid() == Fluids.f_76193_;
        }
    }
}

