/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.entity.ThrownItemEntity;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;

public class ShadedMesaRodItem
extends Item {
    private static final TagKey<EntityType<?>> BLACKLIST = BotaniaTags.Entities.SHADED_MESA_BLACKLIST;
    private static final float RANGE = 3.0f;
    private static final int COST = 2;
    private static final Predicate<Entity> CAN_TARGET = e -> !e.m_5833_() && e.m_6084_() && !e.m_6095_().m_204039_(BLACKLIST);
    private static final String TAG_TICKS_TILL_EXPIRE = "ticksTillExpire";
    private static final String TAG_TICKS_COOLDOWN = "ticksCooldown";
    private static final String TAG_TARGET = "target";
    private static final String TAG_DIST = "dist";

    public ShadedMesaRodItem(Item.Properties props) {
        super(props);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return this.reequipAnimation(oldStack, newStack);
    }

    public boolean allowNbtUpdateAnimation(Player player, InteractionHand hand, ItemStack oldStack, ItemStack newStack) {
        return this.reequipAnimation(oldStack, newStack);
    }

    private boolean reequipAnimation(ItemStack before, ItemStack after) {
        return !after.m_150930_((Item)this);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean held) {
        if (!(entity instanceof Player)) {
            return;
        }
        int ticksTillExpire = ItemNBTHelper.getInt(stack, TAG_TICKS_TILL_EXPIRE, 0);
        int ticksCooldown = ItemNBTHelper.getInt(stack, TAG_TICKS_COOLDOWN, 0);
        if (ticksTillExpire == 0) {
            ItemNBTHelper.setInt(stack, TAG_TARGET, -1);
            ItemNBTHelper.setDouble(stack, TAG_DIST, -1.0);
        }
        if (ticksCooldown > 0) {
            --ticksCooldown;
        }
        if (ticksTillExpire >= 0) {
            --ticksTillExpire;
        }
        ItemNBTHelper.setInt(stack, TAG_TICKS_TILL_EXPIRE, ticksTillExpire);
        ItemNBTHelper.setInt(stack, TAG_TICKS_COOLDOWN, ticksCooldown);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ShadedMesaRodItem.leftClick(player);
        }
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        return ItemNBTHelper.getInt(stack, TAG_TICKS_TILL_EXPIRE, 0) != 0;
    }

    public static InteractionResult onAttack(Player player, Level level, InteractionHand hand, Entity target, @Nullable EntityHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(BotaniaItems.gravityRod) && ((ShadedMesaRodItem)stack.m_41720_()).onLeftClickEntity(stack, player, target)) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        int targetID = ItemNBTHelper.getInt(stack, TAG_TARGET, -1);
        int ticksCooldown = ItemNBTHelper.getInt(stack, TAG_TICKS_COOLDOWN, 0);
        double length = ItemNBTHelper.getDouble(stack, TAG_DIST, -1.0);
        if (ticksCooldown == 0) {
            Entity target = null;
            if (targetID != -1 && player.m_9236_().m_6815_(targetID) != null) {
                Entity taritem = player.m_9236_().m_6815_(targetID);
                boolean found = false;
                Vec3 targetVec = VecHelper.fromEntityCenter((Entity)player);
                List entities = new ArrayList();
                for (int distance = 1; entities.size() == 0 && distance < 25; ++distance) {
                    targetVec = targetVec.m_82549_(player.m_20154_().m_82490_((double)distance)).m_82520_(0.0, 0.5, 0.0);
                    entities = player.m_9236_().m_6249_((Entity)player, VecHelper.boxForRange(targetVec, 3.0), CAN_TARGET);
                    if (!entities.contains(taritem)) continue;
                    found = true;
                }
                if (found) {
                    target = player.m_9236_().m_6815_(targetID);
                }
            }
            if (target == null) {
                Vec3 targetVec = VecHelper.fromEntityCenter((Entity)player);
                List entities = new ArrayList();
                for (int distance = 1; entities.size() == 0 && distance < 25; ++distance) {
                    targetVec = targetVec.m_82549_(player.m_20154_().m_82490_((double)distance)).m_82520_(0.0, 0.5, 0.0);
                    entities = player.m_9236_().m_6249_((Entity)player, VecHelper.boxForRange(targetVec, 3.0), CAN_TARGET);
                }
                if (entities.size() > 0) {
                    target = (Entity)entities.get(0);
                    length = 5.5;
                    if (target instanceof ItemEntity) {
                        length = 2.0;
                    }
                }
            }
            if (target != null) {
                if (target.m_6095_().m_204039_(BLACKLIST)) {
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
                if (ManaItemHandler.instance().requestManaExactForTool(stack, player, 2, true)) {
                    boolean targetIsPlayer = target instanceof Player;
                    if (target instanceof ItemEntity) {
                        ItemEntity item = (ItemEntity)target;
                        item.m_32010_(5);
                    }
                    if (target instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)target;
                        living.f_19789_ = 0.0f;
                        if (living.m_21124_(MobEffects.f_19597_) == null) {
                            living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, targetIsPlayer ? 20 : 2, targetIsPlayer ? 1 : 3, true, true));
                        }
                    }
                    Vec3 target3 = VecHelper.fromEntityCenter((Entity)player).m_82549_(player.m_20154_().m_82490_(length)).m_82520_(0.0, 0.5, 0.0);
                    if (target instanceof ItemEntity) {
                        target3 = target3.m_82520_(0.0, 0.25, 0.0);
                    }
                    for (int i = 0; i < 4; ++i) {
                        float r = 0.5f + (float)Math.random() * 0.5f;
                        float b = 0.5f + (float)Math.random() * 0.5f;
                        float s = 0.2f + (float)Math.random() * 0.1f;
                        float m = 0.1f;
                        float xm = ((float)Math.random() - 0.5f) * m;
                        float ym = ((float)Math.random() - 0.5f) * m;
                        float zm = ((float)Math.random() - 0.5f) * m;
                        WispParticleData data = WispParticleData.wisp(s, r, 0.0f, b);
                        world.m_7106_((ParticleOptions)data, target.m_20185_() + (double)(target.m_20205_() / 2.0f), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_() + (double)(target.m_20205_() / 2.0f), (double)xm, (double)ym, (double)zm);
                    }
                    MathHelper.setEntityMotionFromVector(target, target3, 0.3333333f);
                    if (targetIsPlayer && target instanceof ServerPlayer) {
                        ServerPlayer p = (ServerPlayer)target;
                        p.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)p));
                    }
                    ItemNBTHelper.setInt(stack, TAG_TARGET, target.m_19879_());
                    ItemNBTHelper.setDouble(stack, TAG_DIST, length);
                }
                ItemNBTHelper.setInt(stack, TAG_TICKS_TILL_EXPIRE, 5);
                return InteractionResultHolder.m_19096_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private static void leftClick(Player player) {
        ItemStack stack = player.m_21205_();
        if (!stack.m_41619_() && stack.m_150930_(BotaniaItems.gravityRod)) {
            int targetID = ItemNBTHelper.getInt(stack, TAG_TARGET, -1);
            ItemNBTHelper.getDouble(stack, TAG_DIST, -1.0);
            if (targetID != -1 && player.m_9236_().m_6815_(targetID) != null) {
                Entity target = player.m_9236_().m_6815_(targetID);
                boolean found = false;
                Vec3 vec = VecHelper.fromEntityCenter((Entity)player);
                List entities = new ArrayList();
                for (int distance = 1; entities.size() == 0 && distance < 25; ++distance) {
                    vec = vec.m_82549_(player.m_20154_().m_82490_((double)distance)).m_82520_(0.0, 0.5, 0.0);
                    entities = player.m_9236_().m_6249_((Entity)player, new AABB(vec.m_82492_(3.0, 3.0, 3.0), vec.m_82520_(3.0, 3.0, 3.0)), CAN_TARGET);
                    if (!entities.contains(target)) continue;
                    found = true;
                }
                if (found) {
                    ItemNBTHelper.setInt(stack, TAG_TARGET, -1);
                    ItemNBTHelper.setDouble(stack, TAG_DIST, -1.0);
                    Vec3 moveVector = player.m_20154_().m_82541_();
                    if (target instanceof ItemEntity) {
                        ItemEntity item = (ItemEntity)target;
                        item.m_32010_(20);
                        float mot = ManaItemHandler.instance().hasProficiency(player, stack) ? 2.25f : 1.5f;
                        item.m_20334_(moveVector.f_82479_ * (double)mot, moveVector.f_82480_, moveVector.f_82481_ * (double)mot);
                        if (!player.m_9236_().f_46443_) {
                            ThrownItemEntity thrown = new ThrownItemEntity(item.m_9236_(), item.m_20185_(), item.m_20186_(), item.m_20189_(), item);
                            item.m_9236_().m_7967_((Entity)thrown);
                        }
                        item.m_146870_();
                    } else {
                        if (target instanceof LivingEntity) {
                            LivingEntity living = (LivingEntity)target;
                            living.m_6703_((LivingEntity)player);
                            living.m_6598_(player);
                        }
                        target.m_20256_(moveVector.m_82542_(3.0, 1.5, 3.0));
                    }
                    ItemNBTHelper.setInt(stack, TAG_TICKS_COOLDOWN, 10);
                }
            }
        }
    }
}

