/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.lens;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.item.SparkEntity;
import vazkii.botania.common.item.lens.Lens;
import vazkii.botania.common.item.lens.LensItem;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

public class PaintslingerLens
extends Lens {
    @Override
    public boolean collideBurst(ManaBurst burst, HitResult pos, boolean isManaBlock, boolean shouldKill, ItemStack stack) {
        block6: {
            int storedColor;
            ThrowableProjectile entity;
            block7: {
                Entity collidedWith;
                block8: {
                    entity = burst.entity();
                    storedColor = LensItem.getStoredColor(stack);
                    if (entity.m_9236_().f_46443_ || burst.isFake() || storedColor <= -1 || storedColor >= 17) break block6;
                    if (pos.m_6662_() != HitResult.Type.ENTITY) break block7;
                    collidedWith = ((EntityHitResult)pos).m_82443_();
                    if (!(collidedWith instanceof Sheep)) break block8;
                    Sheep sheep = (Sheep)collidedWith;
                    int r = 20;
                    DyeColor sheepColor = sheep.m_29874_();
                    List sheepList = entity.m_9236_().m_45976_(Sheep.class, new AABB(sheep.m_20185_() - (double)r, sheep.m_20186_() - (double)r, sheep.m_20189_() - (double)r, sheep.m_20185_() + (double)r, sheep.m_20186_() + (double)r, sheep.m_20189_() + (double)r));
                    for (Sheep other : sheepList) {
                        if (other.m_29874_() != sheepColor) continue;
                        other.m_29855_(DyeColor.m_41053_((int)(storedColor == 16 ? other.m_9236_().f_46441_.m_188503_(16) : storedColor)));
                    }
                    shouldKill = true;
                    break block6;
                }
                if (!(collidedWith instanceof SparkEntity)) break block6;
                SparkEntity spark = (SparkEntity)collidedWith;
                spark.setNetwork(DyeColor.m_41053_((int)(storedColor == 16 ? collidedWith.m_9236_().f_46441_.m_188503_(16) : storedColor)));
                break block6;
            }
            if (pos.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos hitPos = ((BlockHitResult)pos).m_82425_();
                Block hitBlock = entity.m_9236_().m_8055_(hitPos).m_60734_();
                ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)hitBlock);
                if (BotaniaAPI.instance().getPaintableBlocks().containsKey(blockId)) {
                    ArrayList<BlockPos> coordsToPaint = new ArrayList<BlockPos>();
                    ArrayDeque<BlockPos> coordsToCheck = new ArrayDeque<BlockPos>();
                    HashSet<BlockPos> checkedCoords = new HashSet<BlockPos>();
                    coordsToCheck.add(hitPos);
                    checkedCoords.add(hitPos);
                    while (!coordsToCheck.isEmpty() && coordsToPaint.size() < 1000) {
                        BlockPos coords = (BlockPos)coordsToCheck.remove();
                        coordsToPaint.add(coords);
                        for (Direction dir : Direction.values()) {
                            BlockPos candidatePos = coords.m_121945_(dir);
                            if (!checkedCoords.add(candidatePos) || !entity.m_9236_().m_8055_(candidatePos).m_60713_(hitBlock)) continue;
                            coordsToCheck.add(candidatePos);
                        }
                    }
                    for (BlockPos coords : coordsToPaint) {
                        DyeColor placeColor = DyeColor.m_41053_((int)(storedColor == 16 ? entity.m_9236_().f_46441_.m_188503_(16) : storedColor));
                        BlockState stateThere = entity.m_9236_().m_8055_(coords);
                        Function<DyeColor, Block> f = BotaniaAPI.instance().getPaintableBlocks().get(blockId);
                        Block newBlock = f.apply(placeColor);
                        if (newBlock == stateThere.m_60734_()) continue;
                        entity.m_9236_().m_46597_(coords, newBlock.m_152465_(stateThere));
                        XplatAbstractions.INSTANCE.sendToNear(entity.m_9236_(), coords, new BotaniaEffectPacket(EffectType.PAINT_LENS, coords.m_123341_(), coords.m_123342_(), coords.m_123343_(), placeColor.m_41060_()));
                    }
                }
            }
        }
        return shouldKill;
    }
}

