/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity.mana;

import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.block.WandBindable;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.BasicLensItem;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ControlLensItem;
import vazkii.botania.api.mana.KeyLocked;
import vazkii.botania.api.mana.LensEffectItem;
import vazkii.botania.api.mana.ManaBlockType;
import vazkii.botania.api.mana.ManaNetworkAction;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.ManaSpreader;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.ExposedSimpleInventoryBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ThrottledPacket;
import vazkii.botania.common.block.mana.ManaSpreaderBlock;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.ManaNetworkHandler;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.item.LexicaBotaniaItem;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaSpreaderBlockEntity
extends ExposedSimpleInventoryBlockEntity
implements WandBindable,
KeyLocked,
ThrottledPacket,
ManaSpreader,
Wandable {
    private static final int TICKS_ALLOWED_WITHOUT_PINGBACK = 20;
    private static final double PINGBACK_EXPIRED_SEARCH_DISTANCE = 0.5;
    private static final String TAG_UUID = "uuid";
    private static final String TAG_MANA = "mana";
    private static final String TAG_REQUEST_UPDATE = "requestUpdate";
    private static final String TAG_ROTATION_X = "rotationX";
    private static final String TAG_ROTATION_Y = "rotationY";
    private static final String TAG_PADDING_COLOR = "paddingColor";
    private static final String TAG_CAN_SHOOT_BURST = "canShootBurst";
    private static final String TAG_PINGBACK_TICKS = "pingbackTicks";
    private static final String TAG_LAST_PINGBACK_X = "lastPingbackX";
    private static final String TAG_LAST_PINGBACK_Y = "lastPingbackY";
    private static final String TAG_LAST_PINGBACK_Z = "lastPingbackZ";
    private static final String TAG_FORCE_CLIENT_BINDING_X = "forceClientBindingX";
    private static final String TAG_FORCE_CLIENT_BINDING_Y = "forceClientBindingY";
    private static final String TAG_FORCE_CLIENT_BINDING_Z = "forceClientBindingZ";
    private static final String TAG_INPUT_KEY = "inputKey";
    private static final String TAG_OUTPUT_KEY = "outputKey";
    private static final String TAG_MAPMAKER_OVERRIDE = "mapmakerOverrideEnabled";
    private static final String TAG_FORCED_COLOR = "mmForcedColor";
    private static final String TAG_FORCED_MANA_PAYLOAD = "mmForcedManaPayload";
    private static final String TAG_FORCED_TICKS_BEFORE_MANA_LOSS = "mmForcedTicksBeforeManaLoss";
    private static final String TAG_FORCED_MANA_LOSS_PER_TICK = "mmForcedManaLossPerTick";
    private static final String TAG_FORCED_GRAVITY = "mmForcedGravity";
    private static final String TAG_FORCED_VELOCITY_MULTIPLIER = "mmForcedVelocityMultiplier";
    private boolean mapmakerOverride = false;
    private int mmForcedColor = 0x20FF20;
    private int mmForcedManaPayload = 160;
    private int mmForcedTicksBeforeManaLoss = 60;
    private float mmForcedManaLossPerTick = 4.0f;
    private float mmForcedGravity = 0.0f;
    private float mmForcedVelocityMultiplier = 1.0f;
    private String inputKey = "";
    private final String outputKey = "";
    private UUID identity = UUID.randomUUID();
    private int mana;
    public float rotationX;
    public float rotationY;
    @Nullable
    public DyeColor paddingColor = null;
    private boolean requestsClientUpdate = false;
    private boolean hasReceivedInitialPacket = false;
    private ManaReceiver receiver = null;
    private ManaReceiver receiverLastTick = null;
    private boolean poweredLastTick = true;
    public boolean canShootBurst = true;
    public int lastBurstDeathTick = -1;
    public int burstParticleTick = 0;
    public int pingbackTicks = 0;
    public double lastPingbackX = 0.0;
    public double lastPingbackY = -2.147483648E9;
    public double lastPingbackZ = 0.0;
    private List<ManaBurstEntity.PositionProperties> lastTentativeBurst;
    private boolean invalidTentativeBurst = false;

    public ManaSpreaderBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.SPREADER, pos, state);
    }

    @Override
    public boolean isFull() {
        return this.mana >= this.getMaxMana();
    }

    @Override
    public void receiveMana(int mana) {
        this.mana = Math.min(this.mana + mana, this.getMaxMana());
        this.m_6596_();
    }

    public void m_7651_() {
        super.m_7651_();
        BotaniaAPI.instance().getManaNetworkInstance().fireManaNetworkEvent(this, ManaBlockType.COLLECTOR, ManaNetworkAction.REMOVE);
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState state, ManaSpreaderBlockEntity self) {
        ItemStack lens;
        ControlLensItem control;
        boolean redstoneSpreader;
        Object dir2;
        boolean inNetwork;
        boolean wasInNetwork = inNetwork = ManaNetworkHandler.instance.isCollectorIn(level, self);
        if (!inNetwork && !self.m_58901_()) {
            BotaniaAPI.instance().getManaNetworkInstance().fireManaNetworkEvent(self, ManaBlockType.COLLECTOR, ManaNetworkAction.ADD);
        }
        boolean powered = false;
        for (Object dir2 : Direction.values()) {
            BlockPos relPos = worldPosition.m_121945_(dir2);
            if (!level.m_46805_(relPos)) continue;
            ManaReceiver receiverAt = XplatAbstractions.INSTANCE.findManaReceiver(level, relPos, dir2.m_122424_());
            if (receiverAt instanceof ManaPool) {
                ManaPool pool = (ManaPool)receiverAt;
                if (wasInNetwork && (pool != self.receiver || self.getVariant() == ManaSpreaderBlock.Variant.REDSTONE)) {
                    KeyLocked locked;
                    if (pool instanceof KeyLocked && !(locked = (KeyLocked)((Object)pool)).getOutputKey().equals(self.getInputKey())) continue;
                    int manaInPool = pool.getCurrentMana();
                    if (manaInPool > 0 && !self.isFull()) {
                        int manaMissing = self.getMaxMana() - self.mana;
                        int manaToRemove = Math.min(manaInPool, manaMissing);
                        pool.receiveMana(-manaToRemove);
                        self.receiveMana(manaToRemove);
                    }
                }
            }
            powered = powered || level.m_276987_(relPos, dir2);
        }
        if (self.needsNewBurstSimulation()) {
            self.checkForReceiver();
        }
        if (!self.canShootBurst) {
            if (self.pingbackTicks <= 0) {
                double x = self.lastPingbackX;
                double y = self.lastPingbackY;
                double z = self.lastPingbackZ;
                AABB aabb = new AABB(x, y, z, x, y, z).m_82377_(0.5, 0.5, 0.5);
                List bursts = level.m_6443_(ThrowableProjectile.class, aabb, (Predicate)Predicates.instanceOf(ManaBurst.class));
                ManaBurst found = null;
                UUID identity = self.getIdentifier();
                for (ManaBurst burst : bursts) {
                    if (burst == null || !identity.equals(burst.getShooterUUID())) continue;
                    found = burst;
                    break;
                }
                if (found != null) {
                    found.ping();
                } else {
                    self.setCanShoot(true);
                }
            } else {
                --self.pingbackTicks;
            }
        }
        boolean shouldShoot = !powered;
        boolean bl = redstoneSpreader = self.getVariant() == ManaSpreaderBlock.Variant.REDSTONE;
        if (redstoneSpreader) {
            boolean bl2 = shouldShoot = powered && !self.poweredLastTick;
        }
        if (shouldShoot && (dir2 = self.receiver) instanceof KeyLocked) {
            KeyLocked locked = (KeyLocked)dir2;
            shouldShoot = locked.getInputKey().equals(self.getOutputKey());
        }
        if ((control = self.getLensController(lens = self.getItemHandler().m_8020_(0))) != null) {
            if (redstoneSpreader) {
                if (shouldShoot) {
                    control.onControlledSpreaderPulse(lens, self);
                }
            } else {
                control.onControlledSpreaderTick(lens, self, powered);
            }
            boolean bl3 = shouldShoot = shouldShoot && control.allowBurstShooting(lens, self, powered);
        }
        if (shouldShoot) {
            self.tryShootBurst();
        }
        if (self.receiverLastTick != self.receiver && !level.f_46443_) {
            self.requestsClientUpdate = true;
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
        }
        self.poweredLastTick = powered;
        self.receiverLastTick = self.receiver;
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        super.writePacketNBT(cmp);
        cmp.m_128362_(TAG_UUID, this.getIdentifier());
        cmp.m_128405_(TAG_MANA, this.mana);
        cmp.m_128350_(TAG_ROTATION_X, this.rotationX);
        cmp.m_128350_(TAG_ROTATION_Y, this.rotationY);
        cmp.m_128379_(TAG_REQUEST_UPDATE, this.requestsClientUpdate);
        cmp.m_128405_(TAG_PADDING_COLOR, this.paddingColor == null ? -1 : this.paddingColor.m_41060_());
        cmp.m_128379_(TAG_CAN_SHOOT_BURST, this.canShootBurst);
        cmp.m_128405_(TAG_PINGBACK_TICKS, this.pingbackTicks);
        cmp.m_128347_(TAG_LAST_PINGBACK_X, this.lastPingbackX);
        cmp.m_128347_(TAG_LAST_PINGBACK_Y, this.lastPingbackY);
        cmp.m_128347_(TAG_LAST_PINGBACK_Z, this.lastPingbackZ);
        cmp.m_128359_(TAG_INPUT_KEY, this.inputKey);
        cmp.m_128359_(TAG_OUTPUT_KEY, "");
        cmp.m_128405_(TAG_FORCE_CLIENT_BINDING_X, this.receiver == null ? 0 : this.receiver.getManaReceiverPos().m_123341_());
        cmp.m_128405_(TAG_FORCE_CLIENT_BINDING_Y, this.receiver == null ? Integer.MIN_VALUE : this.receiver.getManaReceiverPos().m_123342_());
        cmp.m_128405_(TAG_FORCE_CLIENT_BINDING_Z, this.receiver == null ? 0 : this.receiver.getManaReceiverPos().m_123343_());
        cmp.m_128379_(TAG_MAPMAKER_OVERRIDE, this.mapmakerOverride);
        cmp.m_128405_(TAG_FORCED_COLOR, this.mmForcedColor);
        cmp.m_128405_(TAG_FORCED_MANA_PAYLOAD, this.mmForcedManaPayload);
        cmp.m_128405_(TAG_FORCED_TICKS_BEFORE_MANA_LOSS, this.mmForcedTicksBeforeManaLoss);
        cmp.m_128350_(TAG_FORCED_MANA_LOSS_PER_TICK, this.mmForcedManaLossPerTick);
        cmp.m_128350_(TAG_FORCED_GRAVITY, this.mmForcedGravity);
        cmp.m_128350_(TAG_FORCED_VELOCITY_MULTIPLIER, this.mmForcedVelocityMultiplier);
        this.requestsClientUpdate = false;
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        super.readPacketNBT(cmp);
        String tagUuidMostDeprecated = "uuidMost";
        String tagUuidLeastDeprecated = "uuidLeast";
        if (cmp.m_128403_(TAG_UUID)) {
            this.identity = cmp.m_128342_(TAG_UUID);
        } else if (cmp.m_128441_(tagUuidLeastDeprecated) && cmp.m_128441_(tagUuidMostDeprecated)) {
            long most = cmp.m_128454_(tagUuidMostDeprecated);
            long least = cmp.m_128454_(tagUuidLeastDeprecated);
            if (this.identity == null || most != this.identity.getMostSignificantBits() || least != this.identity.getLeastSignificantBits()) {
                this.identity = new UUID(most, least);
            }
        }
        this.mana = cmp.m_128451_(TAG_MANA);
        this.rotationX = cmp.m_128457_(TAG_ROTATION_X);
        this.rotationY = cmp.m_128457_(TAG_ROTATION_Y);
        this.requestsClientUpdate = cmp.m_128471_(TAG_REQUEST_UPDATE);
        if (cmp.m_128441_(TAG_INPUT_KEY)) {
            this.inputKey = cmp.m_128461_(TAG_INPUT_KEY);
        }
        if (cmp.m_128441_(TAG_OUTPUT_KEY)) {
            this.inputKey = cmp.m_128461_(TAG_OUTPUT_KEY);
        }
        this.mapmakerOverride = cmp.m_128471_(TAG_MAPMAKER_OVERRIDE);
        this.mmForcedColor = cmp.m_128451_(TAG_FORCED_COLOR);
        this.mmForcedManaPayload = cmp.m_128451_(TAG_FORCED_MANA_PAYLOAD);
        this.mmForcedTicksBeforeManaLoss = cmp.m_128451_(TAG_FORCED_TICKS_BEFORE_MANA_LOSS);
        this.mmForcedManaLossPerTick = cmp.m_128457_(TAG_FORCED_MANA_LOSS_PER_TICK);
        this.mmForcedGravity = cmp.m_128457_(TAG_FORCED_GRAVITY);
        this.mmForcedVelocityMultiplier = cmp.m_128457_(TAG_FORCED_VELOCITY_MULTIPLIER);
        if (cmp.m_128441_(TAG_PADDING_COLOR)) {
            DyeColor dyeColor = this.paddingColor = cmp.m_128451_(TAG_PADDING_COLOR) == -1 ? null : DyeColor.m_41053_((int)cmp.m_128451_(TAG_PADDING_COLOR));
        }
        if (cmp.m_128441_(TAG_CAN_SHOOT_BURST)) {
            this.canShootBurst = cmp.m_128471_(TAG_CAN_SHOOT_BURST);
        }
        this.pingbackTicks = cmp.m_128451_(TAG_PINGBACK_TICKS);
        this.lastPingbackX = cmp.m_128459_(TAG_LAST_PINGBACK_X);
        this.lastPingbackY = cmp.m_128459_(TAG_LAST_PINGBACK_Y);
        this.lastPingbackZ = cmp.m_128459_(TAG_LAST_PINGBACK_Z);
        if (this.requestsClientUpdate && this.f_58857_ != null) {
            int x = cmp.m_128451_(TAG_FORCE_CLIENT_BINDING_X);
            int y = cmp.m_128451_(TAG_FORCE_CLIENT_BINDING_Y);
            int z = cmp.m_128451_(TAG_FORCE_CLIENT_BINDING_Z);
            if (y != Integer.MIN_VALUE) {
                BlockPos pos = new BlockPos(x, y, z);
                this.receiver = XplatAbstractions.INSTANCE.findManaReceiver(this.f_58857_, pos, null);
            } else {
                this.receiver = null;
            }
        }
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.hasReceivedInitialPacket = true;
        }
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return true;
    }

    @Override
    public Level getManaReceiverLevel() {
        return this.m_58904_();
    }

    @Override
    public BlockPos getManaReceiverPos() {
        return this.m_58899_();
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack wand, Direction side) {
        if (player == null) {
            return false;
        }
        if (!player.m_6144_()) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        } else {
            BlockHitResult bpos = LexicaBotaniaItem.doRayTrace(this.f_58857_, player, ClipContext.Fluid.NONE);
            if (!this.f_58857_.f_46443_) {
                double x = bpos.m_82450_().f_82479_ - (double)this.m_58899_().m_123341_() - 0.5;
                double y = bpos.m_82450_().f_82480_ - (double)this.m_58899_().m_123342_() - 0.5;
                double z = bpos.m_82450_().f_82481_ - (double)this.m_58899_().m_123343_() - 0.5;
                if (bpos.m_82434_() != Direction.DOWN && bpos.m_82434_() != Direction.UP) {
                    Vec3 clickVector = new Vec3(x, 0.0, z);
                    Vec3 relative = new Vec3(-0.5, 0.0, 0.0);
                    double angle = Math.acos(clickVector.m_82526_(relative) / (relative.m_82553_() * clickVector.m_82553_())) * 180.0 / Math.PI;
                    this.rotationX = (float)angle + 180.0f;
                    if (clickVector.f_82481_ < 0.0) {
                        this.rotationX = 360.0f - this.rotationX;
                    }
                }
                double angle = y * 180.0;
                this.rotationY = -((float)angle);
                this.m_6596_();
                this.requestsClientUpdate = true;
            }
        }
        return true;
    }

    private boolean needsNewBurstSimulation() {
        if (this.f_58857_.f_46443_ && !this.hasReceivedInitialPacket) {
            return false;
        }
        if (this.lastTentativeBurst == null) {
            return true;
        }
        for (ManaBurstEntity.PositionProperties props : this.lastTentativeBurst) {
            if (props.contentsEqual(this.f_58857_)) continue;
            this.invalidTentativeBurst = props.isInvalidIn(this.f_58857_);
            return !this.invalidTentativeBurst;
        }
        return false;
    }

    private void tryShootBurst() {
        ManaBurstEntity burst;
        boolean redstone;
        boolean bl = redstone = this.getVariant() == ManaSpreaderBlock.Variant.REDSTONE;
        if ((this.receiver != null || redstone) && !this.invalidTentativeBurst && this.canShootBurst && (redstone || this.receiver.canReceiveManaFromBursts() && !this.receiver.isFull()) && (burst = this.getBurst(false)) != null && !this.f_58857_.f_46443_) {
            this.receiveMana(-burst.getStartingMana());
            burst.setShooterUUID(this.getIdentifier());
            this.f_58857_.m_7967_((Entity)burst);
            burst.ping();
            if (!BotaniaConfig.common().silentSpreaders()) {
                this.f_58857_.m_5594_(null, this.f_58858_, BotaniaSounds.spreaderFire, SoundSource.BLOCKS, 0.05f * (this.paddingColor != null ? 0.2f : 1.0f), 0.7f + 0.3f * (float)Math.random());
            }
        }
    }

    public ManaSpreaderBlock.Variant getVariant() {
        Block b = this.m_58900_().m_60734_();
        if (b instanceof ManaSpreaderBlock) {
            ManaSpreaderBlock spreader = (ManaSpreaderBlock)b;
            return spreader.variant;
        }
        return ManaSpreaderBlock.Variant.MANA;
    }

    public void checkForReceiver() {
        ItemStack stack = this.getItemHandler().m_8020_(0);
        ControlLensItem control = this.getLensController(stack);
        if (control != null && !control.allowBurstShooting(stack, this, false)) {
            return;
        }
        ManaBurstEntity fakeBurst = this.getBurst(true);
        fakeBurst.setScanBeam();
        ManaReceiver receiver = fakeBurst.getCollidedTile(true);
        this.receiver = receiver != null && receiver.getManaReceiverLevel().m_46805_(receiver.getManaReceiverPos()) ? receiver : null;
        this.lastTentativeBurst = fakeBurst.propsList;
    }

    @Override
    public ManaBurst runBurstSimulation() {
        ManaBurstEntity fakeBurst = this.getBurst(true);
        fakeBurst.setScanBeam();
        fakeBurst.getCollidedTile(true);
        return fakeBurst;
    }

    private ManaBurstEntity getBurst(boolean fake) {
        Item item;
        ManaSpreaderBlock.Variant variant = this.getVariant();
        float gravity = 0.0f;
        BurstProperties props = new BurstProperties(variant.burstMana, variant.preLossTicks, variant.lossPerTick, gravity, variant.motionModifier, variant.color);
        ItemStack lens = this.getItemHandler().m_8020_(0);
        if (!lens.m_41619_() && (item = lens.m_41720_()) instanceof LensEffectItem) {
            LensEffectItem lensEffectItem = (LensEffectItem)item;
            lensEffectItem.apply(lens, props, this.f_58857_);
        }
        if (this.getCurrentMana() >= props.maxMana || fake) {
            ManaBurstEntity burst = new ManaBurstEntity(this.m_58904_(), this.m_58899_(), this.getRotationX(), this.getRotationY(), fake);
            burst.setSourceLens(lens);
            if (this.mapmakerOverride) {
                burst.setColor(this.mmForcedColor);
                burst.setMana(this.mmForcedManaPayload);
                burst.setStartingMana(this.mmForcedManaPayload);
                burst.setMinManaLoss(this.mmForcedTicksBeforeManaLoss);
                burst.setManaLossPerTick(this.mmForcedManaLossPerTick);
                burst.setGravity(this.mmForcedGravity);
                burst.m_20256_(burst.m_20184_().m_82490_((double)this.mmForcedVelocityMultiplier));
            } else {
                burst.setColor(props.color);
                burst.setMana(props.maxMana);
                burst.setStartingMana(props.maxMana);
                burst.setMinManaLoss(props.ticksBeforeManaLoss);
                burst.setManaLossPerTick(props.manaLossPerTick);
                burst.setGravity(props.gravity);
                burst.m_20256_(burst.m_20184_().m_82490_((double)props.motionModifier));
            }
            return burst;
        }
        return null;
    }

    public ControlLensItem getLensController(ItemStack stack) {
        ControlLensItem control;
        Item item;
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof ControlLensItem && (control = (ControlLensItem)item).isControlLens(stack)) {
            return control;
        }
        return null;
    }

    @Override
    public void onClientDisplayTick() {
        if (this.f_58857_ != null) {
            ManaBurstEntity burst = this.getBurst(true);
            burst.getCollidedTile(false);
        }
    }

    @Override
    public float getManaYieldMultiplier(ManaBurst burst) {
        return 1.0f;
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(1){

            public int m_6893_() {
                return 1;
            }

            public boolean m_7013_(int index, ItemStack stack) {
                return !stack.m_41619_() && stack.m_41720_() instanceof BasicLensItem;
            }
        };
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.checkForReceiver();
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    @Override
    public BlockPos getBinding() {
        if (this.receiver == null) {
            return null;
        }
        return this.receiver.getManaReceiverPos();
    }

    @Override
    public int getMaxMana() {
        return this.getVariant().manaCapacity;
    }

    @Override
    public String getInputKey() {
        return this.inputKey;
    }

    @Override
    public String getOutputKey() {
        return "";
    }

    @Override
    public boolean canSelect(Player player, ItemStack wand, BlockPos pos, Direction side) {
        return true;
    }

    @Override
    public boolean bindTo(Player player, ItemStack wand, BlockPos pos, Direction side) {
        VoxelShape shape = player.m_9236_().m_8055_(pos).m_60808_((BlockGetter)player.m_9236_(), pos);
        AABB axis = shape.m_83281_() ? new AABB(pos) : shape.m_83215_().m_82338_(pos);
        Vec3 thisVec = Vec3.m_82512_((Vec3i)this.m_58899_());
        Vec3 blockVec = new Vec3(axis.f_82288_ + (axis.f_82291_ - axis.f_82288_) / 2.0, axis.f_82289_ + (axis.f_82292_ - axis.f_82289_) / 2.0, axis.f_82290_ + (axis.f_82293_ - axis.f_82290_) / 2.0);
        Vec3 diffVec = blockVec.m_82546_(thisVec);
        Vec3 diffVec2D = new Vec3(diffVec.f_82479_, diffVec.f_82481_, 0.0);
        Vec3 rotVec = new Vec3(0.0, 1.0, 0.0);
        double angle = MathHelper.angleBetween(rotVec, diffVec2D) / Math.PI * 180.0;
        if (blockVec.f_82479_ < thisVec.f_82479_) {
            angle = -angle;
        }
        this.rotationX = (float)angle + 90.0f;
        rotVec = new Vec3(diffVec.f_82479_, 0.0, diffVec.f_82481_);
        angle = MathHelper.angleBetween(diffVec, rotVec) * 180.0 / Math.PI;
        if (blockVec.f_82480_ < thisVec.f_82480_) {
            angle = -angle;
        }
        this.rotationY = (float)angle;
        this.m_6596_();
        return true;
    }

    @Override
    public void markDispatchable() {
    }

    @Override
    public float getRotationX() {
        return this.rotationX;
    }

    @Override
    public float getRotationY() {
        return this.rotationY;
    }

    @Override
    public void setRotationX(float rot) {
        this.rotationX = rot;
    }

    @Override
    public void setRotationY(float rot) {
        this.rotationY = rot;
    }

    public void rotate(Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_90: {
                this.rotationX += 270.0f;
                break;
            }
            case CLOCKWISE_180: {
                this.rotationX += 180.0f;
                break;
            }
            case COUNTERCLOCKWISE_90: {
                this.rotationX += 90.0f;
                break;
            }
        }
        if (this.rotationX >= 360.0f) {
            this.rotationX -= 360.0f;
        }
    }

    public void mirror(Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                this.rotationX = 360.0f - this.rotationX;
                break;
            }
            case FRONT_BACK: {
                this.rotationX = 180.0f - this.rotationX;
                break;
            }
        }
        if (this.rotationX < 0.0f) {
            this.rotationX += 360.0f;
        }
    }

    @Override
    public void commitRedirection() {
        this.m_6596_();
    }

    @Override
    public void setCanShoot(boolean canShoot) {
        this.canShootBurst = canShoot;
    }

    @Override
    public int getBurstParticleTick() {
        return this.burstParticleTick;
    }

    @Override
    public void setBurstParticleTick(int i) {
        this.burstParticleTick = i;
    }

    @Override
    public int getLastBurstDeathTick() {
        return this.lastBurstDeathTick;
    }

    @Override
    public void setLastBurstDeathTick(int i) {
        this.lastBurstDeathTick = i;
    }

    @Override
    public void pingback(ManaBurst burst, UUID expectedIdentity) {
        if (this.getIdentifier().equals(expectedIdentity)) {
            this.pingbackTicks = 20;
            ThrowableProjectile e = burst.entity();
            this.lastPingbackX = e.m_20185_();
            this.lastPingbackY = e.m_20186_();
            this.lastPingbackZ = e.m_20189_();
            this.setCanShoot(false);
        }
    }

    @Override
    public UUID getIdentifier() {
        return this.identity;
    }

    public static class WandHud
    implements WandHUD {
        private final ManaSpreaderBlockEntity spreader;

        public WandHud(ManaSpreaderBlockEntity spreader) {
            this.spreader = spreader;
        }

        @Override
        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            String spreaderName = new ItemStack((ItemLike)this.spreader.m_58900_().m_60734_()).m_41786_().getString();
            ItemStack lensStack = this.spreader.getItemHandler().m_8020_(0);
            ItemStack recieverStack = this.spreader.receiver == null ? ItemStack.f_41583_ : new ItemStack((ItemLike)this.spreader.f_58857_.m_8055_(this.spreader.receiver.getManaReceiverPos()).m_60734_());
            int width = 4 + Collections.max(Arrays.asList(102, mc.f_91062_.m_92895_(spreaderName), RenderHelper.itemWithNameWidth(mc, lensStack), RenderHelper.itemWithNameWidth(mc, recieverStack)));
            int height = 22 + (lensStack.m_41619_() ? 0 : 18) + (recieverStack.m_41619_() ? 0 : 18);
            int centerX = mc.m_91268_().m_85445_() / 2;
            int centerY = mc.m_91268_().m_85446_() / 2;
            RenderHelper.renderHUDBox(gui, centerX - width / 2, centerY + 8, centerX + width / 2, centerY + 8 + height);
            int color = this.spreader.getVariant().hudColor;
            BotaniaAPIClient.instance().drawSimpleManaHUD(gui, color, this.spreader.getCurrentMana(), this.spreader.getMaxMana(), spreaderName);
            RenderHelper.renderItemWithNameCentered(gui, mc, recieverStack, centerY + 30, color);
            RenderHelper.renderItemWithNameCentered(gui, mc, lensStack, centerY + (recieverStack.m_41619_() ? 30 : 48), color);
        }
    }
}

