/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.common.block.block_entity.TinyPotatoBlockEntity;
import vazkii.botania.common.handler.ContributorList;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.block.TinyPotatoBlockItem;
import vazkii.botania.common.item.equipment.bauble.FlugelTiaraItem;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.mixin.client.ModelManagerAccessor;
import vazkii.botania.xplat.ClientXplatAbstractions;

public class TinyPotatoBlockEntityRenderer
implements BlockEntityRenderer<TinyPotatoBlockEntity> {
    public static final String DEFAULT = "default";
    public static final String HALLOWEEN = "halloween";
    private static final Pattern ESCAPED = Pattern.compile("[^a-z0-9/._-]");
    private final BlockRenderDispatcher blockRenderDispatcher;

    public TinyPotatoBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.blockRenderDispatcher = ctx.m_173584_();
    }

    public static BakedModel getModelFromDisplayName(Component displayName) {
        StringBuilder nameBuilder = new StringBuilder();
        TinyPotatoBlockItem.isEnchantedName(displayName, nameBuilder);
        return TinyPotatoBlockEntityRenderer.getModel(nameBuilder.toString().toLowerCase(Locale.ROOT));
    }

    private static BakedModel getModel(String name) {
        ModelManager bmm = Minecraft.m_91087_().m_91304_();
        Map<ResourceLocation, BakedModel> mm = ((ModelManagerAccessor)bmm).getBakedRegistry();
        BakedModel missing = bmm.m_119409_();
        ResourceLocation location = TinyPotatoBlockEntityRenderer.taterLocation(name);
        BakedModel model = mm.get(location);
        if (model == null) {
            if (ClientProxy.dootDoot) {
                return mm.getOrDefault(TinyPotatoBlockEntityRenderer.taterLocation(HALLOWEEN), missing);
            }
            return mm.getOrDefault(TinyPotatoBlockEntityRenderer.taterLocation(DEFAULT), missing);
        }
        return model;
    }

    private static ResourceLocation taterLocation(String name) {
        return ResourceLocationHelper.prefix("tiny_potato/" + TinyPotatoBlockEntityRenderer.normalizeName(name));
    }

    private static String normalizeName(String name) {
        return ESCAPED.matcher(name).replaceAll("_").toLowerCase(Locale.ROOT);
    }

    public void render(@NotNull TinyPotatoBlockEntity potato, float partialTicks, PoseStack ms, @NotNull MultiBufferSource buffers, int light, int overlay) {
        boolean render;
        ms.m_85836_();
        StringBuilder nameBuilder = new StringBuilder();
        boolean enchanted = TinyPotatoBlockItem.isEnchantedName(potato.name, nameBuilder);
        String name = nameBuilder.toString().toLowerCase(Locale.ROOT);
        RenderType layer = Sheets.m_110792_();
        BakedModel model = TinyPotatoBlockEntityRenderer.getModel(name);
        ms.m_252880_(0.5f, 0.0f, 0.5f);
        Direction potatoFacing = (Direction)potato.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        float rotY = 0.0f;
        switch (potatoFacing) {
            default: {
                rotY = 180.0f;
                break;
            }
            case NORTH: {
                break;
            }
            case EAST: {
                rotY = 90.0f;
                break;
            }
            case WEST: {
                rotY = 270.0f;
            }
        }
        ms.m_252781_(VecHelper.rotateY(-rotY));
        float jump = potato.jumpTicks;
        if (jump > 0.0f) {
            jump -= partialTicks;
        }
        float up = (float)Math.abs(Math.sin((double)(jump / 10.0f) * Math.PI)) * 0.2f;
        float rotZ = (float)Math.sin((double)(jump / 10.0f) * Math.PI) * 2.0f;
        float wiggle = (float)Math.sin((double)(jump / 10.0f) * Math.PI) * 0.05f;
        ms.m_252880_(wiggle, up, 0.0f);
        ms.m_252781_(VecHelper.rotateZ(rotZ));
        boolean bl = render = !name.equals("mami") && !name.equals("soaryn") && (!name.equals("eloraam") || jump == 0.0f);
        if (render) {
            ms.m_85836_();
            ms.m_252880_(-0.5f, 0.0f, -0.5f);
            VertexConsumer buffer = ItemRenderer.m_115211_((MultiBufferSource)buffers, (RenderType)layer, (boolean)true, (boolean)enchanted);
            this.renderModel(ms, buffer, light, overlay, model);
            ms.m_85849_();
        }
        ms.m_252880_(0.0f, 1.5f, 0.0f);
        ms.m_85836_();
        ms.m_252781_(VecHelper.rotateZ(180.0f));
        this.renderItems(potato, potatoFacing, name, partialTicks, ms, buffers, light, overlay);
        ms.m_85836_();
        ClientXplatAbstractions.INSTANCE.fireRenderTinyPotato(potato, potato.name, partialTicks, ms, buffers, light, overlay);
        ms.m_85849_();
        ms.m_85849_();
        ms.m_252781_(VecHelper.rotateZ(-rotZ));
        ms.m_252781_(VecHelper.rotateY(rotY));
        this.renderName(potato, name, ms, buffers, light);
        ms.m_85849_();
    }

    private void renderName(TinyPotatoBlockEntity potato, String name, PoseStack ms, MultiBufferSource buffers, int light) {
        Minecraft mc = Minecraft.m_91087_();
        HitResult pos = mc.f_91077_;
        if (Minecraft.m_91404_() && !name.isEmpty() && pos != null && pos.m_6662_() == HitResult.Type.BLOCK && potato.m_58899_().equals((Object)((BlockHitResult)pos).m_82425_())) {
            ms.m_85836_();
            ms.m_252880_(0.0f, -0.6f, 0.0f);
            ms.m_252781_(mc.m_91290_().m_253208_());
            float f1 = 0.02666667f;
            ms.m_85841_(-f1, -f1, f1);
            int halfWidth = mc.f_91062_.m_92895_(potato.name.getString()) / 2;
            float opacity = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
            int opacityRGB = (int)(opacity * 255.0f) << 24;
            mc.f_91062_.m_272077_(potato.name, (float)(-halfWidth), 0.0f, 0x20FFFFFF, false, ms.m_85850_().m_252922_(), buffers, Font.DisplayMode.SEE_THROUGH, opacityRGB, light);
            mc.f_91062_.m_272077_(potato.name, (float)(-halfWidth), 0.0f, -1, false, ms.m_85850_().m_252922_(), buffers, Font.DisplayMode.NORMAL, 0, light);
            if (name.equals("pahimar") || name.equals("soaryn")) {
                ms.m_252880_(0.0f, 14.0f, 0.0f);
                String str = name.equals("pahimar") ? "[WIP]" : "(soon)";
                halfWidth = mc.f_91062_.m_92895_(str) / 2;
                mc.f_91062_.m_271703_(str, (float)(-halfWidth), 0.0f, 0x20FFFFFF, false, ms.m_85850_().m_252922_(), buffers, Font.DisplayMode.SEE_THROUGH, opacityRGB, light);
                mc.f_91062_.m_271703_(str, (float)(-halfWidth), 0.0f, -1, false, ms.m_85850_().m_252922_(), buffers, Font.DisplayMode.SEE_THROUGH, 0, light);
            }
            ms.m_85849_();
        }
    }

    private void renderItems(TinyPotatoBlockEntity potato, Direction facing, String name, float partialTicks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        ms.m_85836_();
        ms.m_252781_(VecHelper.rotateZ(180.0f));
        ms.m_252880_(0.0f, -1.0f, 0.0f);
        float s = 0.2857143f;
        ms.m_85841_(s, s, s);
        for (int i = 0; i < potato.inventorySize(); ++i) {
            ItemStack stack = potato.getItemHandler().m_8020_(i);
            if (stack.m_41619_()) continue;
            ms.m_85836_();
            Direction side = Direction.values()[i];
            if (side.m_122434_() != Direction.Axis.Y) {
                float sideAngle = side.m_122435_() - facing.m_122435_();
                side = Direction.m_122364_((double)sideAngle);
            }
            boolean block = stack.m_41720_() instanceof BlockItem;
            boolean mySon = stack.m_41720_() instanceof TinyPotatoBlockItem;
            switch (side) {
                case UP: {
                    if (mySon) {
                        ms.m_252880_(0.0f, -0.375f, 0.5f);
                    } else if (block) {
                        ms.m_252880_(0.0f, 0.3f, 0.5f);
                    }
                    ms.m_252880_(0.0f, -0.5f, -0.4f);
                    break;
                }
                case DOWN: {
                    ms.m_252880_(0.0f, -2.3f, -0.88f);
                    if (mySon) {
                        ms.m_252880_(0.0f, 1.25f, 0.5f);
                        break;
                    }
                    if (!block) break;
                    ms.m_252880_(0.0f, 1.0f, 0.6f);
                    break;
                }
                case NORTH: {
                    ms.m_252880_(0.0f, -1.9f, 0.02f);
                    if (mySon) {
                        ms.m_252880_(0.0f, 0.2f, 0.57f);
                        break;
                    }
                    if (!block) break;
                    ms.m_252880_(0.0f, 1.0f, 0.6f);
                    break;
                }
                case SOUTH: {
                    ms.m_252880_(0.0f, -1.6f, -0.89f);
                    if (mySon) {
                        ms.m_252880_(0.0f, -0.59f, 0.26f);
                        break;
                    }
                    if (!block) break;
                    ms.m_252880_(0.0f, 1.0f, 0.5f);
                    break;
                }
                case EAST: {
                    if (mySon) {
                        ms.m_252880_(-0.35f, -0.29f, -0.06f);
                    } else if (block) {
                        ms.m_252880_(-0.4f, 0.8f, 0.0f);
                    } else {
                        ms.m_252781_(VecHelper.rotateY(-90.0f));
                    }
                    ms.m_252880_(-0.3f, -1.9f, 0.04f);
                    break;
                }
                case WEST: {
                    if (mySon) {
                        ms.m_252880_(0.95f, -0.29f, 0.9f);
                        if (stack.m_41788_()) {
                            StringBuilder childNameBuilder = new StringBuilder();
                            TinyPotatoBlockItem.isEnchantedName(stack.m_41786_(), childNameBuilder);
                            if (childNameBuilder.toString().equals("kingdaddydmac")) {
                                ms.m_252880_(0.55f, 0.0f, 0.0f);
                            }
                        }
                    } else if (block) {
                        ms.m_252880_(1.0f, 0.8f, 1.0f);
                    } else {
                        ms.m_252781_(VecHelper.rotateY(-90.0f));
                    }
                    ms.m_252880_(-0.3f, -1.9f, -0.92f);
                }
            }
            if (mySon) {
                ms.m_85841_(1.1f, 1.1f, 1.1f);
            } else if (block) {
                ms.m_85841_(0.5f, 0.5f, 0.5f);
            }
            if (block && side == Direction.NORTH) {
                ms.m_252781_(VecHelper.rotateY(180.0f));
            }
            this.renderItem(ms, buffers, potato.m_58904_(), light, overlay, stack);
            ms.m_85849_();
        }
        ms.m_85849_();
        ms.m_85836_();
        if (!name.isEmpty()) {
            ContributorList.firstStart();
            float scale = 0.25f;
            ms.m_252880_(0.0f, 1.0f, 0.0f);
            ms.m_85841_(scale, scale, scale);
            switch (name) {
                case "phi": 
                case "vazkii": {
                    ms.m_85836_();
                    ms.m_85837_(-0.08, 0.1, 0.4);
                    ms.m_252781_(VecHelper.rotateY(90.0f));
                    ms.m_252781_(new Quaternionf().rotateAxis(VecHelper.toRadians(20.0f), 1.0f, 0.0f, 1.0f));
                    this.renderModel(ms, buffers, light, overlay, MiscellaneousModels.INSTANCE.phiFlowerModel);
                    ms.m_85849_();
                    if (!name.equals("vazkii")) break;
                    ms.m_85841_(1.25f, 1.25f, 1.25f);
                    ms.m_252781_(VecHelper.rotateX(180.0f));
                    ms.m_252781_(VecHelper.rotateY(-90.0f));
                    ms.m_85837_(0.2, -1.25, -0.075);
                    this.renderModel(ms, buffers, light, overlay, MiscellaneousModels.INSTANCE.nerfBatModel);
                    break;
                }
                case "haighyorkie": {
                    ms.m_85841_(1.25f, 1.25f, 1.25f);
                    ms.m_252781_(VecHelper.rotateZ(180.0f));
                    ms.m_252781_(VecHelper.rotateY(-90.0f));
                    ms.m_252880_(-0.5f, -1.2f, -0.075f);
                    this.renderModel(ms, buffers, light, overlay, MiscellaneousModels.INSTANCE.goldfishModel);
                    break;
                }
                case "martysgames": 
                case "marty": {
                    ms.m_85841_(0.7f, 0.7f, 0.7f);
                    ms.m_252781_(VecHelper.rotateZ(180.0f));
                    ms.m_252880_(-0.3f, -2.7f, -1.2f);
                    ms.m_252781_(VecHelper.rotateZ(15.0f));
                    this.renderItem(ms, buffers, potato.m_58904_(), light, overlay, new ItemStack((ItemLike)BotaniaItems.infiniteFruit).m_41714_((Component)Component.m_237113_((String)"das boot")));
                    break;
                }
                case "jibril": {
                    ms.m_85841_(1.5f, 1.5f, 1.5f);
                    ms.m_252880_(0.0f, 0.8f, 0.0f);
                    FlugelTiaraItem.ClientLogic.renderHalo(null, null, ms, buffers, partialTicks);
                    break;
                }
                case "kingdaddydmac": {
                    ms.m_85841_(0.5f, 0.5f, 0.5f);
                    ms.m_252781_(VecHelper.rotateZ(180.0f));
                    ms.m_252781_(VecHelper.rotateY(90.0f));
                    ms.m_85836_();
                    ms.m_252880_(0.0f, -2.5f, 0.65f);
                    ItemStack ring = new ItemStack((ItemLike)BotaniaItems.manaRing);
                    this.renderItem(ms, buffers, potato.m_58904_(), light, overlay, ring);
                    ms.m_252880_(0.0f, 0.0f, -4.0f);
                    this.renderItem(ms, buffers, potato.m_58904_(), light, overlay, ring);
                    ms.m_85849_();
                    ms.m_85837_(1.5, -4.0, -2.5);
                    this.renderBlock(ms, buffers, light, overlay, Blocks.f_50145_);
                    break;
                }
                default: {
                    ItemStack icon = ContributorList.getFlower(name);
                    if (icon.m_41619_()) break;
                    ms.m_252781_(VecHelper.rotateX(180.0f));
                    ms.m_252781_(VecHelper.rotateY(180.0f));
                    ms.m_85837_(0.0, -0.78, -0.5);
                    Minecraft.m_91087_().m_91291_().m_269128_(icon, ItemDisplayContext.HEAD, light, overlay, ms, buffers, potato.m_58904_(), 0);
                }
            }
        }
        ms.m_85849_();
    }

    private void renderModel(PoseStack ms, MultiBufferSource buffers, int light, int overlay, BakedModel model) {
        this.renderModel(ms, buffers.m_6299_(Sheets.m_110792_()), light, overlay, model);
    }

    private void renderModel(PoseStack ms, VertexConsumer buffer, int light, int overlay, BakedModel model) {
        this.blockRenderDispatcher.m_110937_().m_111067_(ms.m_85850_(), buffer, null, model, 1.0f, 1.0f, 1.0f, light, overlay);
    }

    private void renderItem(PoseStack ms, MultiBufferSource buffers, @Nullable Level level, int light, int overlay, ItemStack stack) {
        Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.HEAD, light, overlay, ms, buffers, level, 0);
    }

    private void renderBlock(PoseStack ms, MultiBufferSource buffers, int light, int overlay, Block block) {
        this.blockRenderDispatcher.m_110912_(block.m_49966_(), ms, buffers, light, overlay);
    }
}

