/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.mana.PoolOverlayProvider;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.block.mana.ManaPoolBlock;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ManaPoolBlockEntityRenderer
implements BlockEntityRenderer<ManaPoolBlockEntity> {
    public static int cartMana = -1;
    private final TextureAtlasSprite waterSprite;
    private final BlockRenderDispatcher blockRenderDispatcher;

    public ManaPoolBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.blockRenderDispatcher = ctx.m_173584_();
        this.waterSprite = Objects.requireNonNull((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(ResourceLocationHelper.prefix("block/mana_water")));
    }

    public void render(@Nullable ManaPoolBlockEntity pool, float f, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        float manaLevel;
        int maxMana;
        Block below;
        ms.m_85836_();
        boolean fab = pool != null && ((ManaPoolBlock)pool.m_58900_().m_60734_()).variant == ManaPoolBlock.Variant.FABULOUS;
        boolean diluted = pool != null && ((ManaPoolBlock)pool.m_58900_().m_60734_()).variant == ManaPoolBlock.Variant.DILUTED;
        boolean creative = pool != null && ((ManaPoolBlock)pool.m_58900_().m_60734_()).variant == ManaPoolBlock.Variant.CREATIVE;
        int insideUVStart = diluted ? 1 : 2;
        int insideUVEnd = 16 - insideUVStart;
        float poolBottom = (float)insideUVStart / 16.0f + 0.001f;
        float poolTop = (float)(diluted ? 5 : (creative ? 9 : 7)) / 16.0f;
        if (fab) {
            float time = (float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks;
            time += (float)new Random(pool.m_58899_().m_123341_() ^ pool.m_58899_().m_123342_() ^ pool.m_58899_().m_123343_()).nextInt(100000);
            int poolColor = pool.getColor().map(ColorHelper::getColorValue).orElse(-1);
            int color = MathHelper.multiplyColor(Mth.m_14169_((float)Mth.m_14187_((float)(time *= 0.005f)), (float)0.6f, (float)1.0f), poolColor);
            int red = (color & 0xFF0000) >> 16;
            int green = (color & 0xFF00) >> 8;
            int blue = color & 0xFF;
            BlockState state = pool.m_58900_();
            BakedModel model = this.blockRenderDispatcher.m_110910_(state);
            VertexConsumer buffer = buffers.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)state, (boolean)false));
            this.blockRenderDispatcher.m_110937_().m_111067_(ms.m_85850_(), buffer, state, model, (float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, light, overlay);
        }
        if (pool != null && (below = pool.m_58904_().m_8055_(pool.m_58899_().m_7495_()).m_60734_()) instanceof PoolOverlayProvider) {
            PoolOverlayProvider overlayProvider = (PoolOverlayProvider)below;
            ResourceLocation overlaySpriteId = overlayProvider.getIcon(pool.m_58904_(), pool.m_58899_());
            TextureAtlasSprite overlayIcon = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(overlaySpriteId);
            ms.m_85836_();
            float alpha = (float)((Math.sin((double)((float)ClientTickHandler.ticksInGame + f) / 20.0) + 1.0) * 0.3 + 0.2);
            ms.m_252880_(0.0f, poolBottom, 0.0f);
            ms.m_252781_(VecHelper.rotateX(90.0f));
            VertexConsumer buffer = buffers.m_6299_(RenderHelper.ICON_OVERLAY);
            RenderHelper.renderIconCropped(ms, buffer, insideUVStart, insideUVStart, insideUVEnd, insideUVEnd, overlayIcon, 0xFFFFFF, alpha, light);
            ms.m_85849_();
        }
        int mana = pool == null ? cartMana : pool.getCurrentMana();
        int n = maxMana = pool == null ? -1 : pool.getMaxMana();
        if (maxMana == -1) {
            maxMana = 1000000;
        }
        if ((manaLevel = (float)mana / (float)maxMana) > 0.0f) {
            ms.m_85836_();
            ms.m_252880_(0.0f, Mth.m_184631_((float)manaLevel, (float)0.0f, (float)1.0f, (float)poolBottom, (float)poolTop), 0.0f);
            ms.m_252781_(VecHelper.rotateX(90.0f));
            VertexConsumer buffer = buffers.m_6299_(RenderHelper.MANA_POOL_WATER);
            RenderHelper.renderIconCropped(ms, buffer, insideUVStart, insideUVStart, insideUVEnd, insideUVEnd, this.waterSprite, 0xFFFFFF, 1.0f, light);
            ms.m_85849_();
        }
        ms.m_85849_();
        cartMana = -1;
    }
}

