/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.blocks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.client.DelayedRenderer;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.OrientationTools;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbuilder.compat.RFToolsBuilderTOPDriver;
import mcjty.rftoolsbuilder.modules.mover.MoverModule;
import mcjty.rftoolsbuilder.modules.mover.blocks.InvisibleMoverBE;
import mcjty.rftoolsbuilder.modules.mover.blocks.InvisibleMoverBlock;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverControllerTileEntity;
import mcjty.rftoolsbuilder.modules.mover.blocks.VehicleBuilderTileEntity;
import mcjty.rftoolsbuilder.modules.mover.client.MoverRenderer;
import mcjty.rftoolsbuilder.modules.mover.items.VehicleCard;
import mcjty.rftoolsbuilder.modules.mover.logic.EntityMovementLogic;
import mcjty.rftoolsbuilder.modules.mover.network.PacketClickMover;
import mcjty.rftoolsbuilder.modules.mover.network.PacketSyncVehicleInformationToClient;
import mcjty.rftoolsbuilder.modules.mover.sound.MoverSoundController;
import mcjty.rftoolsbuilder.setup.RFToolsBuilderMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.Lazy;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class MoverTileEntity
extends TickingTileEntity {
    public static final int SLOT_VEHICLE_CARD = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(1).slot(SlotDefinition.specific((Item[])new Item[]{MoverModule.VEHICLE_CARD.get()}).in().out(), 0, 154, 11).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).onUpdate((slot, stack) -> this.updateVehicle()).build();
    @Cap(type=CapType.CONTAINER)
    private final Lazy<MenuProvider> screenHandler = Lazy.of(() -> new DefaultContainerProvider("Mover").containerSupplier(DefaultContainerProvider.container(MoverModule.CONTAINER_MOVER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).setupSync((GenericTileEntity)this));
    @GuiValue
    private String name;
    @GuiValue
    private boolean down = true;
    @GuiValue
    private boolean up = true;
    @GuiValue
    private boolean north = true;
    @GuiValue
    private boolean south = true;
    @GuiValue
    private boolean west = true;
    @GuiValue
    private boolean east = true;
    @GuiValue
    public static final Value<?, String> VALUE_CONNECTIONS = Value.create((String)"connections", (Type)Type.STRING, MoverTileEntity::getConnectionCount, MoverTileEntity::setConnectionCount);
    private String connections = "";
    public static final Set<Integer> wantUnmount = new HashSet<Integer>();
    private BlockPos offset = new BlockPos(1, 1, 1);
    private BlockPos controller;
    private int cnt;
    private int clientUpdateCnt;
    private boolean enoughPower = false;
    private List<String> platformsFromServer = Collections.emptyList();
    private String currentPlatform = "";
    private BlockPos cursorBlock;
    private double cursorX;
    private double cursorY;
    private String highlightedMover;
    private boolean moverValid = false;
    private int currentPage = 0;
    private int renderCopyTimer = 0;
    private BlockPos lastDestination;
    private Map<BlockPos, BlockState> invisibleMoverBlocks = null;
    private final EntityMovementLogic logic = new EntityMovementLogic(this);
    private final Map<Direction, BlockPos> network = new EnumMap<Direction, BlockPos>(Direction.class);

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(MoverTileEntity::new).topDriver((TOPDriver)RFToolsBuilderTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsbuilder:todo")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbuilder.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()})){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }
        };
    }

    public MoverTileEntity(BlockPos pos, BlockState state) {
        super(MoverModule.TYPE_MOVER.get(), pos, state);
    }

    public BlockPos getLastDestination() {
        return this.lastDestination;
    }

    public void setLastDestination(BlockPos lastDestination) {
        this.lastDestination = lastDestination;
    }

    public Map<Direction, BlockPos> getNetwork() {
        return this.network;
    }

    public EntityMovementLogic getLogic() {
        return this.logic;
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.invisibleMoverBlocks != null) {
            this.removeInvisibleBlocks();
        }
    }

    protected void tickServer() {
        if (!this.isMoving()) {
            this.logic.clearGrabbedEntities();
        }
        this.updateVehicleStatus();
        this.logic.tryMoveVehicleServer();
        this.syncVehicleStatus();
        MoverControllerTileEntity controller = this.getController();
        this.enoughPower = false;
        if (controller != null) {
            this.enoughPower = controller.hasEnoughPower();
        }
    }

    protected void tickClient() {
        this.handleRender();
        this.handleSound();
        this.setCursor();
    }

    public void setHighlightedMover(String highlightedMover) {
        this.highlightedMover = highlightedMover;
    }

    public BlockPos getCursorBlock() {
        return this.cursorBlock;
    }

    public double getCursorX() {
        return this.cursorX;
    }

    public double getCursorY() {
        return this.cursorY;
    }

    public boolean isMoverValid() {
        return this.moverValid;
    }

    public boolean hasEnoughPower() {
        return this.enoughPower;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    private void setCursor() {
        HitResult mouseOver = SafeClientTools.getClientMouseOver();
        if (mouseOver instanceof BlockHitResult) {
            BlockHitResult blockResult = (BlockHitResult)mouseOver;
            BlockPos pos = blockResult.m_82425_();
            List<InvisibleMoverBlock.MoverData> list = ((InvisibleMoverBlock)MoverModule.INVISIBLE_MOVER_BLOCK.get()).getData(this.f_58858_);
            if (list != null) {
                for (InvisibleMoverBlock.MoverData data : list) {
                    if (!pos.equals((Object)data.controlPos())) continue;
                    Pair<Double, Double> cursor = this.getCursor(mouseOver.m_82450_().f_82479_ - (double)pos.m_123341_(), mouseOver.m_82450_().f_82480_ - (double)pos.m_123342_(), mouseOver.m_82450_().f_82481_ - (double)pos.m_123343_(), data.horizDirection(), data.direction());
                    this.cursorBlock = pos;
                    this.cursorX = (Double)cursor.getLeft();
                    this.cursorY = (Double)cursor.getRight();
                    return;
                }
            }
        }
    }

    public boolean hasDirectContectionTo(BlockPos destination) {
        return this.network.containsValue(destination);
    }

    public void setClientRenderInfo(List<String> platforms, String currentPlatform, boolean valid, boolean enoughPower) {
        this.platformsFromServer = platforms;
        this.currentPlatform = currentPlatform;
        this.moverValid = valid;
        this.enoughPower = enoughPower;
    }

    public List<String> getPlatformsFromServer() {
        return this.platformsFromServer;
    }

    public String getCurrentPlatform() {
        return this.currentPlatform;
    }

    private void syncVehicleStatus() {
        --this.clientUpdateCnt;
        if (this.clientUpdateCnt <= 0) {
            this.clientUpdateCnt = 20;
            if (!this.getCard().m_41619_()) {
                boolean valid = this.isValid();
                List<String> platforms = valid ? this.traverseAndCollect().values().stream().map(MoverTileEntity::getName).sorted().collect(Collectors.toList()) : Collections.emptyList();
                RFToolsBuilderMessages.sendToChunk(PacketSyncVehicleInformationToClient.create(this.f_58858_, platforms, this.getName(), valid, this.hasEnoughPower()), this.f_58857_, this.f_58858_);
            }
        }
    }

    private void handleSound() {
        if (this.controller == null) {
            return;
        }
        long starttick = this.getLogic().getStarttick();
        long totalTicks = this.getLogic().getTotalTicks();
        long current = this.f_58857_.m_46467_();
        long endtick = starttick + totalTicks;
        if (current >= starttick && current <= endtick) {
            Vec3 currentPos = this.getLogic().getMovingPosition(0.0f, this.f_58857_.m_46467_());
            if (MoverSoundController.isPlaying(this.f_58857_, this.controller, this.f_58858_)) {
                MoverSoundController.move(this.f_58857_, this.controller, this.f_58858_, currentPos);
            } else {
                MoverSoundController.play(this.f_58857_, this.controller, this.f_58858_, currentPos);
            }
        } else {
            MoverSoundController.stop(this.f_58857_, this.controller, this.f_58858_);
        }
    }

    private void handleRender() {
        ItemStack vehicle = this.getCard();
        if (VehicleBuilderTileEntity.isVehicleCard(vehicle)) {
            this.renderCopyTimer = 1;
            MoverRenderer.addPreRender(this.f_58858_, () -> {
                float partialTicks = MoverRenderer.getPartialTicks();
                this.logic.tryMoveVehicleClientEntities(partialTicks);
            }, this::isMoverThere);
            DelayedRenderer.addRender((BlockPos)this.f_58858_, (poseStack, cameraVec, renderType) -> MoverRenderer.delayedRenderer(this, vehicle, poseStack, cameraVec, renderType), this::isMoverThere);
        } else if (this.renderCopyTimer > 0) {
            --this.renderCopyTimer;
        }
    }

    @NotNull
    private Boolean isMoverThere(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MoverTileEntity) {
            MoverTileEntity mover = (MoverTileEntity)blockEntity;
            if (this.renderCopyTimer > 0) {
                return true;
            }
            return !mover.getCard().m_41619_();
        }
        return false;
    }

    @Nonnull
    public Map<BlockPos, MoverTileEntity> traverseAndCollect() {
        HashMap<BlockPos, MoverTileEntity> alreadyHandled = new HashMap<BlockPos, MoverTileEntity>();
        alreadyHandled.put(this.f_58858_, this);
        this.traverseAndCollectInt(alreadyHandled);
        return alreadyHandled;
    }

    private void traverseAndCollectInt(Map<BlockPos, MoverTileEntity> alreadyHandled) {
        for (Map.Entry<Direction, BlockPos> entry : this.getNetwork().entrySet()) {
            BlockEntity blockEntity;
            BlockPos p = entry.getValue();
            if (alreadyHandled.containsKey(p) || !((blockEntity = this.f_58857_.m_7702_(p)) instanceof MoverTileEntity)) continue;
            MoverTileEntity child = (MoverTileEntity)blockEntity;
            alreadyHandled.put(p, child);
            child.traverseAndCollectInt(alreadyHandled);
        }
    }

    @Nullable
    public <T> T traverseDepthFirst(BiFunction<BlockPos, MoverTileEntity, T> function) {
        HashSet<BlockPos> alreadyHandled = new HashSet<BlockPos>();
        alreadyHandled.add(this.f_58858_);
        return this.traverseDepthFirstInt(alreadyHandled, function);
    }

    @Nullable
    private <T> T traverseDepthFirstInt(Set<BlockPos> alreadyHandled, BiFunction<BlockPos, MoverTileEntity, T> function) {
        T result = function.apply(this.f_58858_, this);
        if (result != null) {
            return result;
        }
        for (Map.Entry<Direction, BlockPos> entry : this.getNetwork().entrySet()) {
            MoverTileEntity child;
            BlockPos p = entry.getValue();
            if (alreadyHandled.contains(p)) continue;
            alreadyHandled.add(p);
            BlockEntity blockEntity = this.f_58857_.m_7702_(p);
            if (!(blockEntity instanceof MoverTileEntity) || (result = (child = (MoverTileEntity)blockEntity).traverseDepthFirstInt(alreadyHandled, function)) == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public <T> T traverseBreadthFirst(BiFunction<BlockPos, MoverTileEntity, T> function) {
        HashSet<BlockPos> alreadyHandled = new HashSet<BlockPos>();
        ArrayList<Pair> todo = new ArrayList<Pair>();
        todo.add(Pair.of((Object)this.f_58858_, (Object)((Object)this)));
        alreadyHandled.add(this.f_58858_);
        int toProcess = 0;
        for (int toExpand = 0; toExpand < todo.size(); ++toExpand) {
            while (toProcess < todo.size()) {
                Pair pair = (Pair)todo.get(toProcess);
                T result = function.apply((BlockPos)pair.getLeft(), (MoverTileEntity)((Object)pair.getRight()));
                if (result != null) {
                    return result;
                }
                ++toProcess;
            }
            for (Map.Entry<Direction, BlockPos> entry : ((MoverTileEntity)((Object)((Pair)todo.get(toExpand)).getRight())).getNetwork().entrySet()) {
                BlockEntity blockEntity;
                BlockPos childPos = entry.getValue();
                if (alreadyHandled.contains(childPos) || !((blockEntity = this.f_58857_.m_7702_(childPos)) instanceof MoverTileEntity)) continue;
                MoverTileEntity childMover = (MoverTileEntity)blockEntity;
                alreadyHandled.add(childPos);
                todo.add(Pair.of((Object)childPos, (Object)((Object)childMover)));
            }
        }
        return null;
    }

    @Nullable
    public <T> T traverseBreadthFirstWithPath(BiFunction<List<BlockPos>, MoverTileEntity, T> function) {
        HashSet<BlockPos> alreadyHandled = new HashSet<BlockPos>();
        ArrayList<Pair> todo = new ArrayList<Pair>();
        todo.add(Pair.of(new ArrayList(), (Object)((Object)this)));
        alreadyHandled.add(this.f_58858_);
        int toProcess = 0;
        for (int toExpand = 0; toExpand < todo.size(); ++toExpand) {
            while (toProcess < todo.size()) {
                Pair pair = (Pair)todo.get(toProcess);
                T result = function.apply((List)pair.getLeft(), (MoverTileEntity)((Object)pair.getRight()));
                if (result != null) {
                    return result;
                }
                ++toProcess;
            }
            for (Map.Entry<Direction, BlockPos> entry : ((MoverTileEntity)((Object)((Pair)todo.get(toExpand)).getRight())).getNetwork().entrySet()) {
                BlockEntity blockEntity;
                BlockPos childPos = entry.getValue();
                if (alreadyHandled.contains(childPos) || !((blockEntity = this.f_58857_.m_7702_(childPos)) instanceof MoverTileEntity)) continue;
                MoverTileEntity childMover = (MoverTileEntity)blockEntity;
                alreadyHandled.add(childPos);
                if (!childMover.isAvailable()) continue;
                ArrayList<BlockPos> path = new ArrayList<BlockPos>((Collection)((Pair)todo.get(toExpand)).getLeft());
                path.add(childPos);
                todo.add(Pair.of(path, (Object)((Object)childMover)));
            }
        }
        return null;
    }

    public boolean isValid() {
        if (this.controller == null) {
            return false;
        }
        return this.f_58857_.m_7702_(this.controller) instanceof MoverControllerTileEntity;
    }

    public boolean isMoving() {
        if (this.getCard().m_41619_()) {
            return false;
        }
        return this.logic.getDestination() != null;
    }

    private void updateVehicleStatus() {
        if (this.logic.getDestination() != null) {
            if (this.invisibleMoverBlocks != null) {
                BlockState invisibleState = ((InvisibleMoverBlock)MoverModule.INVISIBLE_MOVER_BLOCK.get()).m_49966_();
                this.invisibleMoverBlocks.forEach((p, st) -> {
                    BlockState state = this.f_58857_.m_8055_(p);
                    if (state == invisibleState) {
                        this.f_58857_.m_7731_(p, Blocks.f_50016_.m_49966_(), 3);
                    }
                });
                this.invisibleMoverBlocks = null;
            }
        } else {
            if (this.invisibleMoverBlocks == null) {
                this.updateVehicle();
                this.cnt = 0;
            }
            --this.cnt;
            if (this.cnt <= 0) {
                this.cnt = 4;
                BlockState invisibleState = ((InvisibleMoverBlock)MoverModule.INVISIBLE_MOVER_BLOCK.get()).m_49966_();
                this.invisibleMoverBlocks.forEach((p, originalState) -> {
                    BlockState state = this.f_58857_.m_8055_(p);
                    if (state != invisibleState && state.m_247087_()) {
                        this.f_58857_.m_7731_(p, invisibleState, 3);
                        BlockEntity patt19144$temp = this.f_58857_.m_7702_(p);
                        if (patt19144$temp instanceof InvisibleMoverBE) {
                            InvisibleMoverBE invisibleMover = (InvisibleMoverBE)patt19144$temp;
                            invisibleMover.setOriginalState((BlockState)originalState);
                            this.f_58857_.m_7260_(p, invisibleState, invisibleState, 3);
                        }
                    }
                });
            }
        }
    }

    private void updateVehicle() {
        ItemStack vehicle = this.items.getStackInSlot(0);
        if (this.invisibleMoverBlocks == null) {
            this.invisibleMoverBlocks = new HashMap<BlockPos, BlockState>();
        }
        this.cnt = 0;
        this.removeInvisibleBlocks();
        if (!vehicle.m_41619_()) {
            Map<BlockState, List<BlockPos>> blocks = VehicleCard.getBlocks(vehicle, this.f_58858_.m_121955_((Vec3i)this.offset));
            for (Map.Entry<BlockState, List<BlockPos>> entry : blocks.entrySet()) {
                for (BlockPos pos : entry.getValue()) {
                    this.invisibleMoverBlocks.put(pos, entry.getKey());
                }
            }
        } else {
            this.logic.setDestination(null);
        }
        this.markDirtyClient();
    }

    private void removeInvisibleBlocks() {
        BlockState invisibleState = ((InvisibleMoverBlock)MoverModule.INVISIBLE_MOVER_BLOCK.get()).m_49966_();
        this.invisibleMoverBlocks.forEach((p, st) -> {
            BlockState state = this.f_58857_.m_8055_(p);
            if (state == invisibleState) {
                this.f_58857_.m_7731_(p, Blocks.f_50016_.m_49966_(), 3);
            }
        });
        this.invisibleMoverBlocks.clear();
    }

    public void arriveAtDestination() {
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.logic.getDestination());
        if (blockEntity instanceof MoverTileEntity) {
            MoverTileEntity destMover = (MoverTileEntity)blockEntity;
            this.getLogic().endMoveServer();
            destMover.items.setStackInSlot(0, this.getCard());
            this.items.setStackInSlot(0, ItemStack.f_41583_);
            destMover.setSource(null);
            destMover.getLogic().setWaitABit(5);
            destMover.updateVehicle();
            destMover.updateVehicleStatus();
        }
        this.logic.setDestination(null);
        this.cnt = 0;
        this.updateVehicle();
        this.updateVehicleStatus();
        this.markDirtyClient();
    }

    public void setSource(BlockPos pos) {
        this.logic.setSource(pos);
        this.m_6596_();
    }

    public boolean isAvailable() {
        ItemStack vehicle = this.items.getStackInSlot(0);
        if (!vehicle.m_41619_()) {
            return false;
        }
        if (this.logic.getDestination() != null) {
            return false;
        }
        return this.logic.getSource() == null;
    }

    public String getConnectionCount() {
        return this.connections;
    }

    public void setConnectionCount(String v) {
        this.connections = v;
    }

    public ItemStack getCard() {
        return this.items.getStackInSlot(0);
    }

    public void clearNetwork() {
        this.network.clear();
        this.connections = "";
        this.m_6596_();
    }

    public boolean canConnect(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> this.down;
            case Direction.UP -> this.up;
            case Direction.NORTH -> this.north;
            case Direction.SOUTH -> this.south;
            case Direction.WEST -> this.west;
            case Direction.EAST -> this.east;
        };
    }

    public void hitScreenClient(BlockPos pos, double x, double y, double z, Direction hitDirection, Direction horizDirection, Direction direction) {
        if (hitDirection == direction) {
            Pair<Double, Double> pair = this.getCursor(x, y, z, horizDirection, direction);
            this.cursorBlock = pos;
            this.cursorX = (Double)pair.getLeft();
            this.cursorY = (Double)pair.getRight();
            if (this.highlightedMover != null && !this.highlightedMover.isEmpty()) {
                if ("___<___".equals(this.highlightedMover)) {
                    if (this.currentPage > 0) {
                        --this.currentPage;
                    }
                } else if ("___>___".equals(this.highlightedMover)) {
                    ++this.currentPage;
                    int pages = (this.platformsFromServer.size() + 7 - 1) / 7;
                    if (this.currentPage >= pages) {
                        this.currentPage = pages - 1;
                    }
                } else {
                    RFToolsBuilderMessages.sendToServer(PacketClickMover.create(this.f_58858_, this.highlightedMover));
                }
            }
        }
    }

    public void startMove(String mover) {
        BlockEntity blockEntity;
        if (this.controller != null && !this.getCard().m_41619_() && (blockEntity = this.f_58857_.m_7702_(this.controller)) instanceof MoverControllerTileEntity) {
            MoverControllerTileEntity controllerTile = (MoverControllerTileEntity)blockEntity;
            controllerTile.setupMovement(mover, VehicleCard.getVehicleName(this.getCard()));
        }
    }

    public void setController(MoverControllerTileEntity controller) {
        this.controller = controller.m_58899_();
        this.m_6596_();
    }

    public MoverControllerTileEntity getController() {
        if (this.controller == null) {
            return null;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        if (blockEntity instanceof MoverControllerTileEntity) {
            MoverControllerTileEntity controller = (MoverControllerTileEntity)blockEntity;
            return controller;
        }
        return null;
    }

    @NotNull
    private Pair<Double, Double> getCursor(double x, double y, double z, Direction horizDirection, Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> {
                switch (horizDirection) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case DOWN: {
                        yield Pair.of((Object)(1.0 - x), (Object)(1.0 - z));
                    }
                    case UP: {
                        yield Pair.of((Object)(1.0 - x), (Object)(1.0 - z));
                    }
                    case NORTH: {
                        yield Pair.of((Object)(1.0 - x), (Object)(1.0 - z));
                    }
                    case SOUTH: {
                        yield Pair.of((Object)x, (Object)z);
                    }
                    case WEST: {
                        yield Pair.of((Object)(1.0 - z), (Object)(1.0 - x));
                    }
                    case EAST: 
                }
                yield Pair.of((Object)z, (Object)x);
            }
            case Direction.DOWN -> {
                switch (horizDirection) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case DOWN: {
                        yield Pair.of((Object)(1.0 - x), (Object)z);
                    }
                    case UP: {
                        yield Pair.of((Object)(1.0 - x), (Object)z);
                    }
                    case NORTH: {
                        yield Pair.of((Object)(1.0 - x), (Object)z);
                    }
                    case SOUTH: {
                        yield Pair.of((Object)x, (Object)(1.0 - z));
                    }
                    case WEST: {
                        yield Pair.of((Object)z, (Object)(1.0 - x));
                    }
                    case EAST: 
                }
                yield Pair.of((Object)(1.0 - z), (Object)x);
            }
            case Direction.NORTH -> Pair.of((Object)(1.0 - x), (Object)(1.0 - y));
            case Direction.SOUTH -> Pair.of((Object)x, (Object)(1.0 - y));
            case Direction.WEST -> Pair.of((Object)z, (Object)(1.0 - y));
            case Direction.EAST -> Pair.of((Object)(1.0 - z), (Object)(1.0 - y));
        };
    }

    public void addConnection(Direction direction, BlockPos pos) {
        this.network.put(direction, pos);
        this.connections = this.connections + direction.name().toUpperCase().charAt(0);
        this.m_6596_();
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            if (!tagCompound.m_128441_(direction.name())) continue;
            this.addConnection(direction, NbtUtils.m_129239_((CompoundTag)tagCompound.m_128469_(direction.name())));
        }
        this.logic.load(tagCompound);
        int[] controller = tagCompound.m_128465_("controller");
        this.controller = controller.length >= 3 ? new BlockPos(controller[0], controller[1], controller[2]) : null;
        this.offset = new BlockPos(tagCompound.m_128451_("offsetX"), tagCompound.m_128451_("offsetY"), tagCompound.m_128451_("offsetZ"));
    }

    public void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.name = info.m_128461_("name");
        this.down = info.m_128471_("down");
        this.up = info.m_128471_("up");
        this.north = info.m_128471_("north");
        this.south = info.m_128471_("south");
        this.west = info.m_128471_("west");
        this.east = info.m_128471_("east");
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            if (!this.network.containsKey(direction)) continue;
            tagCompound.m_128365_(direction.name(), (Tag)NbtUtils.m_129224_((BlockPos)this.network.get(direction)));
        }
        this.logic.save(tagCompound);
        if (this.controller != null) {
            tagCompound.m_128385_("controller", new int[]{this.controller.m_123341_(), this.controller.m_123342_(), this.controller.m_123343_()});
        }
        tagCompound.m_128405_("offsetX", this.offset.m_123341_());
        tagCompound.m_128405_("offsetY", this.offset.m_123342_());
        tagCompound.m_128405_("offsetZ", this.offset.m_123343_());
    }

    public void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        if (this.name != null) {
            info.m_128359_("name", this.name);
        }
        info.m_128379_("down", this.down);
        info.m_128379_("up", this.up);
        info.m_128379_("north", this.north);
        info.m_128379_("south", this.south);
        info.m_128379_("west", this.west);
        info.m_128379_("east", this.east);
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.loadClientDataFromNBT(tag);
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        ItemStack card = this.items.getStackInSlot(0);
        CompoundTag tag = new CompoundTag();
        card.m_41739_(tag);
        tagCompound.m_128365_("card", (Tag)tag);
        this.logic.saveClientDataToNBT(tagCompound);
        if (this.controller != null) {
            tagCompound.m_128385_("controller", new int[]{this.controller.m_123341_(), this.controller.m_123342_(), this.controller.m_123343_()});
        }
        tagCompound.m_128405_("offsetX", this.offset.m_123341_());
        tagCompound.m_128405_("offsetY", this.offset.m_123342_());
        tagCompound.m_128405_("offsetZ", this.offset.m_123343_());
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        CompoundTag tag = tagCompound.m_128469_("card");
        this.items.setStackInSlot(0, ItemStack.m_41712_((CompoundTag)tag));
        this.logic.loadClientDataFromNBT(tagCompound);
        int[] controller = tagCompound.m_128465_("controller");
        this.controller = controller.length >= 3 ? new BlockPos(controller[0], controller[1], controller[2]) : null;
        this.offset = new BlockPos(tagCompound.m_128451_("offsetX"), tagCompound.m_128451_("offsetY"), tagCompound.m_128451_("offsetZ"));
    }

    public void setOffset(int x, int y, int z) {
        this.offset = new BlockPos(x, y, z);
        this.updateVehicle();
        this.markDirtyClient();
    }

    public BlockPos getOffset() {
        return this.offset;
    }
}

