/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.turbine.client;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.registries.ForgeRegistries;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.client.Biselector;
import net.roguelogix.biggerreactors.client.CommonRender;
import net.roguelogix.biggerreactors.client.SelectorColors;
import net.roguelogix.biggerreactors.client.Triselector;
import net.roguelogix.biggerreactors.multiblocks.turbine.containers.TurbineTerminalContainer;
import net.roguelogix.biggerreactors.multiblocks.turbine.state.TurbineActivity;
import net.roguelogix.biggerreactors.multiblocks.turbine.state.TurbineState;
import net.roguelogix.biggerreactors.multiblocks.turbine.state.VentState;
import net.roguelogix.phosphophyllite.client.gui.RenderHelper;
import net.roguelogix.phosphophyllite.client.gui.elements.AbstractElement;
import net.roguelogix.phosphophyllite.client.gui.elements.InteractiveElement;
import net.roguelogix.phosphophyllite.client.gui.elements.RenderedElement;
import net.roguelogix.phosphophyllite.client.gui.elements.TooltipElement;
import net.roguelogix.phosphophyllite.client.gui.screens.PhosphophylliteScreen;

public class TurbineTerminalScreen
extends PhosphophylliteScreen<TurbineTerminalContainer> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("biggerreactors", "textures/screen/turbine_terminal.png");
    private TurbineState turbineState;
    private Fluid intakeFluid = Fluids.f_76191_;
    private Fluid exhaustFluid = Fluids.f_76191_;

    public TurbineTerminalScreen(TurbineTerminalContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, (Component)Component.m_237115_((String)"screen.biggerreactors.turbine_terminal"), DEFAULT_TEXTURE, 176, 152);
        this.turbineState = (TurbineState)((TurbineTerminalContainer)this.m_6262_()).getGuiPacket();
        this.intakeFluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(this.turbineState.intakeResourceLocation));
        this.exhaustFluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(this.turbineState.exhaustResourceLocation));
    }

    public void m_7856_() {
        super.m_7856_();
        this.initTooltips();
        this.initControls();
        this.initGauges();
        this.initSymbols();
    }

    private void initTooltips() {
        this.addScreenElement((AbstractElement)new TooltipElement((PhosphophylliteScreen)this, 8, 19, 16, 16, (Component)Component.m_237115_((String)"screen.biggerreactors.turbine_terminal.tachometer.tooltip")));
        TooltipElement tachometerReadoutTooltip = new TooltipElement((PhosphophylliteScreen)this, 26, 19, 53, 16, (Component)Component.m_237119_());
        tachometerReadoutTooltip.onTick = () -> {
            tachometerReadoutTooltip.tooltip = Component.m_237113_((String)String.format("%.3f RPM", this.turbineState.currentRPM));
        };
        this.addScreenElement((AbstractElement)tachometerReadoutTooltip);
        this.addScreenElement((AbstractElement)new TooltipElement((PhosphophylliteScreen)this, 8, 38, 16, 16, (Component)Component.m_237115_((String)"screen.biggerreactors.turbine_terminal.energy_generation_rate.tooltip")));
        TooltipElement generationRateReadoutTooltip = new TooltipElement((PhosphophylliteScreen)this, 26, 38, 53, 16, (Component)Component.m_237119_());
        generationRateReadoutTooltip.onTick = () -> {
            generationRateReadoutTooltip.tooltip = Component.m_237113_((String)String.format("%.3f RF/t", this.turbineState.turbineOutputRate));
        };
        this.addScreenElement((AbstractElement)generationRateReadoutTooltip);
        this.addScreenElement((AbstractElement)new TooltipElement((PhosphophylliteScreen)this, 8, 57, 16, 16, (Component)Component.m_237115_((String)"screen.biggerreactors.turbine_terminal.flow_rate_governor.tooltip")));
        TooltipElement flowRateReadoutTooltip = new TooltipElement((PhosphophylliteScreen)this, 26, 57, 53, 16, (Component)Component.m_237119_());
        flowRateReadoutTooltip.onTick = () -> {
            flowRateReadoutTooltip.tooltip = Component.m_237113_((String)String.format("%d mB/t", this.turbineState.flowRate));
        };
        this.addScreenElement((AbstractElement)flowRateReadoutTooltip);
        this.addScreenElement((AbstractElement)new TooltipElement((PhosphophylliteScreen)this, 8, 76, 16, 16, (Component)Component.m_237115_((String)"screen.biggerreactors.turbine_terminal.rotor_efficiency.tooltip")));
        TooltipElement rotorEfficiencyReadoutTooltip = new TooltipElement((PhosphophylliteScreen)this, 26, 76, 53, 16, (Component)Component.m_237119_());
        rotorEfficiencyReadoutTooltip.onTick = () -> {
            rotorEfficiencyReadoutTooltip.tooltip = Component.m_237113_((String)String.format("%.1f%%", this.turbineState.efficiencyRate * 100.0));
        };
        this.addScreenElement((AbstractElement)rotorEfficiencyReadoutTooltip);
        this.addScreenElement((AbstractElement)new TooltipElement((PhosphophylliteScreen)this, 86, 6, 16, 16, (Component)Component.m_237115_((String)"screen.biggerreactors.turbine_terminal.tachometer.tooltip")));
        this.addScreenElement((AbstractElement)new TooltipElement((PhosphophylliteScreen)this, 152, 6, 16, 16, (Component)Component.m_237115_((String)"screen.biggerreactors.turbine_terminal.internal_battery.tooltip")));
    }

    private void initControls() {
        Biselector<TurbineTerminalContainer> activityToggle = new Biselector<TurbineTerminalContainer>(this, 8, 98, (Component)Component.m_237115_((String)"screen.biggerreactors.turbine_terminal.activity_toggle.tooltip"), () -> this.turbineState.turbineActivity.toInt(), SelectorColors.RED, SelectorColors.GREEN);
        activityToggle.onMouseReleased = (mX, mY, btn) -> {
            ((TurbineTerminalContainer)this.m_6262_()).executeRequest("setActive", activityToggle.getState() == 0 ? 1 : 0);
            return true;
        };
        this.addScreenElement((AbstractElement)activityToggle);
        Biselector<TurbineTerminalContainer> coilEngageToggle = new Biselector<TurbineTerminalContainer>(this, 8, 114, (Component)Component.m_237115_((String)"screen.biggerreactors.turbine_terminal.coil_engage_toggle.tooltip"), () -> this.turbineState.coilStatus ? 1 : 0, SelectorColors.RED, SelectorColors.GREEN);
        coilEngageToggle.onMouseReleased = (mX, mY, btn) -> {
            ((TurbineTerminalContainer)this.m_6262_()).executeRequest("setCoilEngaged", coilEngageToggle.getState() == 0 ? 1 : 0);
            return true;
        };
        this.addScreenElement((AbstractElement)coilEngageToggle);
        Triselector<TurbineTerminalContainer> ventStateToggle = new Triselector<TurbineTerminalContainer>(this, 8, 130, (Component)Component.m_237115_((String)"screen.biggerreactors.turbine_terminal.vent_state_toggle.tooltip"), () -> this.turbineState.ventState.toInt(), SelectorColors.YELLOW, SelectorColors.RED, SelectorColors.GREEN);
        ventStateToggle.onMouseReleased = (mX, mY, btn) -> {
            ((TurbineTerminalContainer)this.m_6262_()).executeRequest("setVentState", ventStateToggle.getState());
            return true;
        };
        this.addScreenElement((AbstractElement)ventStateToggle);
        InteractiveElement flowRateIncreaseButton = new InteractiveElement((PhosphophylliteScreen)this, 153, 92, 14, 15, 226, 0, (Component)Component.m_237115_((String)"screen.biggerreactors.turbine_terminal.flow_rate_increase.tooltip"));
        flowRateIncreaseButton.onMouseReleased = (mX, mY, btn) -> {
            if (flowRateIncreaseButton.m_5953_(mX, mY)) {
                long delta = Screen.m_96638_() && Screen.m_96637_() ? Config.CONFIG.Turbine.GUI.DeltaMBHCtrlShift : (Screen.m_96637_() ? Config.CONFIG.Turbine.GUI.DeltaMBCtrl : (Screen.m_96638_() ? Config.CONFIG.Turbine.GUI.DeltaMBShift : Config.CONFIG.Turbine.GUI.DeltaMB));
                ((TurbineTerminalContainer)this.m_6262_()).executeRequest("changeFlowRate", delta);
                flowRateIncreaseButton.playSound(SoundEvents.f_12490_);
                return true;
            }
            return false;
        };
        flowRateIncreaseButton.onRender = (graphics, mX, mY) -> {
            if (flowRateIncreaseButton.m_5953_((double)mX, (double)mY)) {
                flowRateIncreaseButton.blit(graphics, 242, 0);
            } else {
                flowRateIncreaseButton.blit(graphics, 228, 0);
            }
        };
        this.addScreenElement((AbstractElement)flowRateIncreaseButton);
        InteractiveElement flowRateDecreaseButton = new InteractiveElement((PhosphophylliteScreen)this, 153, 108, 14, 15, 226, 0, (Component)Component.m_237115_((String)"screen.biggerreactors.turbine_terminal.flow_rate_decrease.tooltip"));
        flowRateDecreaseButton.onMouseReleased = (mX, mY, btn) -> {
            if (flowRateDecreaseButton.m_5953_(mX, mY)) {
                long delta = Screen.m_96638_() && Screen.m_96637_() ? -Config.CONFIG.Turbine.GUI.DeltaMBHCtrlShift : (Screen.m_96637_() ? -Config.CONFIG.Turbine.GUI.DeltaMBCtrl : (Screen.m_96638_() ? -Config.CONFIG.Turbine.GUI.DeltaMBShift : -Config.CONFIG.Turbine.GUI.DeltaMB));
                ((TurbineTerminalContainer)this.m_6262_()).executeRequest("changeFlowRate", delta);
                flowRateDecreaseButton.playSound(SoundEvents.f_12490_);
                return true;
            }
            return false;
        };
        flowRateDecreaseButton.onRender = (graphics, mX, mY) -> {
            if (flowRateDecreaseButton.m_5953_((double)mX, (double)mY)) {
                flowRateDecreaseButton.blit(graphics, 242, 15);
            } else {
                flowRateDecreaseButton.blit(graphics, 228, 15);
            }
        };
        this.addScreenElement((AbstractElement)flowRateDecreaseButton);
    }

    private void initGauges() {
        RenderedElement tachometerGauge = new RenderedElement((PhosphophylliteScreen)this, 85, 25, 18, 64, 0, 152, (Component)Component.m_237119_());
        tachometerGauge.onRender = (graphics, mX, mY) -> TurbineTerminalScreen.renderTachometerGauge(graphics, (RenderedElement<TurbineTerminalContainer>)tachometerGauge, this.turbineState.currentRPM, this.turbineState.maxRPM);
        this.addScreenElement((AbstractElement)tachometerGauge);
        RenderedElement intakeTank = new RenderedElement((PhosphophylliteScreen)this, 107, 25, 18, 64, 0, 152, (Component)Component.m_237119_());
        intakeTank.onRender = (graphics, mX, mY) -> CommonRender.renderFluidGauge(graphics, intakeTank, this.turbineState.intakeStored, this.turbineState.intakeCapacity, this.intakeFluid);
        this.addScreenElement((AbstractElement)intakeTank);
        RenderedElement exhaustTank = new RenderedElement((PhosphophylliteScreen)this, 129, 25, 18, 64, 0, 152, (Component)Component.m_237119_());
        exhaustTank.onRender = (graphics, mX, mY) -> CommonRender.renderFluidGauge(graphics, exhaustTank, this.turbineState.exhaustStored, this.turbineState.exhaustCapacity, this.exhaustFluid);
        this.addScreenElement((AbstractElement)exhaustTank);
        RenderedElement internalBattery = new RenderedElement((PhosphophylliteScreen)this, 151, 25, 18, 64, 0, 152, (Component)Component.m_237119_());
        internalBattery.onRender = (graphics, mX, mY) -> CommonRender.renderEnergyGauge(graphics, internalBattery, this.turbineState.energyStored, this.turbineState.energyCapacity);
        this.addScreenElement((AbstractElement)internalBattery);
    }

    private void initSymbols() {
        RenderedElement intakeTankSymbol = new RenderedElement((PhosphophylliteScreen)this, 108, 6, 16, 16, 54, 152, (Component)Component.m_237115_((String)"screen.biggerreactors.turbine_terminal.intake_tank.tooltip"));
        intakeTankSymbol.onRender = (graphics, mX, mY) -> RenderHelper.drawMaskedFluid((GuiGraphics)graphics, (int)intakeTankSymbol.x, (int)intakeTankSymbol.y, (int)0, (int)intakeTankSymbol.width, (int)intakeTankSymbol.height, (int)intakeTankSymbol.u, (int)intakeTankSymbol.v, (Fluid)this.intakeFluid);
        this.addScreenElement((AbstractElement)intakeTankSymbol);
        RenderedElement exhaustTankSymbol = new RenderedElement((PhosphophylliteScreen)this, 130, 6, 16, 16, 70, 152, (Component)Component.m_237115_((String)"screen.biggerreactors.turbine_terminal.exhaust_tank.tooltip"));
        exhaustTankSymbol.onRender = (graphics, mX, mY) -> RenderHelper.drawMaskedFluid((GuiGraphics)graphics, (int)exhaustTankSymbol.x, (int)exhaustTankSymbol.y, (int)0, (int)exhaustTankSymbol.width, (int)exhaustTankSymbol.height, (int)exhaustTankSymbol.u, (int)exhaustTankSymbol.v, (Fluid)this.exhaustFluid);
        this.addScreenElement((AbstractElement)exhaustTankSymbol);
    }

    public void m_181908_() {
        this.turbineState = (TurbineState)((TurbineTerminalContainer)this.m_6262_()).getGuiPacket();
        super.m_181908_();
        if (!this.turbineState.intakeResourceLocation.equals(Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)this.intakeFluid)).toString())) {
            this.intakeFluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(this.turbineState.intakeResourceLocation));
        }
        if (!this.turbineState.exhaustResourceLocation.equals(Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)this.exhaustFluid)).toString())) {
            this.exhaustFluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(this.turbineState.exhaustResourceLocation));
        }
    }

    public static void renderTachometerGauge(@Nonnull GuiGraphics graphics, @Nonnull RenderedElement<TurbineTerminalContainer> symbol, double currentRPM, double maxRPM) {
        if (currentRPM > 0.0 && maxRPM > 0.0) {
            int renderSize = (int)((double)symbol.height * currentRPM / maxRPM);
            symbol.blit(graphics, symbol.u + 36, symbol.v);
            symbol.blit(graphics, symbol.width, symbol.height - renderSize, symbol.u + 18, symbol.v);
        }
        symbol.blit(graphics);
        symbol.tooltip = Component.m_237113_((String)String.format("%.1f/%.1f RPM", currentRPM, maxRPM));
    }

    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280056_(this.getFont(), RenderHelper.formatValue((double)this.turbineState.currentRPM, (int)1, (String)"RPM", (boolean)false), this.getGuiLeft() + 27, this.getGuiTop() + 23, 0x404040, false);
        graphics.m_280056_(this.getFont(), RenderHelper.formatValue((double)this.turbineState.turbineOutputRate, (String)"RF/t"), this.getGuiLeft() + 27, this.getGuiTop() + 42, 0x404040, false);
        graphics.m_280056_(this.getFont(), RenderHelper.formatValue((double)((double)this.turbineState.flowRate / 1000.0), (int)1, (String)"B/t", (boolean)true), this.getGuiLeft() + 27, this.getGuiTop() + 61, 0x404040, false);
        graphics.m_280056_(this.getFont(), String.format("%.1f%%", this.turbineState.efficiencyRate * 100.0), this.getGuiLeft() + 27, this.getGuiTop() + 80, 0x404040, false);
        if (this.turbineState.turbineActivity == TurbineActivity.ACTIVE) {
            graphics.m_280056_(this.getFont(), Component.m_237115_((String)"screen.biggerreactors.turbine_terminal.activity_toggle.online").getString(), this.getGuiLeft() + 42, this.getGuiTop() + 102, 0x404040, false);
        } else {
            graphics.m_280056_(this.getFont(), Component.m_237115_((String)"screen.biggerreactors.turbine_terminal.activity_toggle.offline").getString(), this.getGuiLeft() + 42, this.getGuiTop() + 102, 0x404040, false);
        }
        if (this.turbineState.coilStatus) {
            graphics.m_280056_(this.getFont(), Component.m_237115_((String)"screen.biggerreactors.turbine_terminal.coil_engage_toggle.engaged").getString(), this.getGuiLeft() + 42, this.getGuiTop() + 118, 0x404040, false);
        } else {
            graphics.m_280056_(this.getFont(), Component.m_237115_((String)"screen.biggerreactors.turbine_terminal.coil_engage_toggle.disengaged").getString(), this.getGuiLeft() + 42, this.getGuiTop() + 118, 0x404040, false);
        }
        if (this.turbineState.ventState == VentState.OVERFLOW) {
            graphics.m_280056_(this.getFont(), Component.m_237115_((String)"screen.biggerreactors.turbine_terminal.vent_state_toggle.overflow").getString(), this.getGuiLeft() + 58, this.getGuiTop() + 134, 0x404040, false);
        } else if (this.turbineState.ventState == VentState.ALL) {
            graphics.m_280056_(this.getFont(), Component.m_237115_((String)"screen.biggerreactors.turbine_terminal.vent_state_toggle.all").getString(), this.getGuiLeft() + 58, this.getGuiTop() + 134, 0x404040, false);
        } else {
            graphics.m_280056_(this.getFont(), Component.m_237115_((String)"screen.biggerreactors.turbine_terminal.vent_state_toggle.closed").getString(), this.getGuiLeft() + 58, this.getGuiTop() + 134, 0x404040, false);
        }
    }
}

