/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.deps;

import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.util.LazyOptional;
import net.roguelogix.biggerreactors.BiggerReactors;
import net.roguelogix.biggerreactors.multiblocks.reactor.ReactorMultiblockController;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorSimulation;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorActivity;
import net.roguelogix.biggerreactors.multiblocks.reactor.util.ReactorTransitionTank;
import net.roguelogix.phosphophyllite.multiblock.validated.IValidatedMultiblock;

public class ReactorPeripheral
implements IPeripheral {
    @Nonnull
    private final Supplier<ReactorMultiblockController> rawControllerSupplier;
    @Nonnull
    private final LamdbaExceptionUtils.Supplier_WithExceptions<ReactorMultiblockController, LuaException> controllerSupplier;
    @Nonnull
    private final LamdbaExceptionUtils.Supplier_WithExceptions<IReactorSimulation, LuaException> simulationSupplier;
    private final Battery battery;
    private final CoolantTank coolantTank;
    private final FuelTank fuelTank;
    ArrayList<ControlRod> controlRods = new ArrayList();

    public static LazyOptional<ReactorPeripheral> create(@Nonnull Supplier<ReactorMultiblockController> controllerSupplier) {
        return LazyOptional.of(() -> new ReactorPeripheral(controllerSupplier));
    }

    private ReactorPeripheral(@Nonnull Supplier<ReactorMultiblockController> rawControllerSupplier) {
        this.rawControllerSupplier = rawControllerSupplier;
        this.controllerSupplier = this::getController;
        this.simulationSupplier = this::getSimulation;
        this.battery = new Battery(this.simulationSupplier);
        this.coolantTank = new CoolantTank(this.controllerSupplier, this.simulationSupplier);
        this.fuelTank = new FuelTank(this.controllerSupplier, this.simulationSupplier);
    }

    @LuaFunction
    public String apiVersion() {
        return BiggerReactors.modVersion();
    }

    @LuaFunction
    public boolean connected() {
        ReactorMultiblockController controller = this.rawControllerSupplier.get();
        if (controller == null) {
            return false;
        }
        if (controller.simulation() == null) {
            return false;
        }
        return controller.assemblyState() == IValidatedMultiblock.AssemblyState.ASSEMBLED;
    }

    @Nonnull
    private ReactorMultiblockController getController() throws LuaException {
        ReactorMultiblockController controller = this.rawControllerSupplier.get();
        if (controller == null || controller.assemblyState() != IValidatedMultiblock.AssemblyState.ASSEMBLED) {
            throw new LuaException("Invalid multiblock controller");
        }
        return controller;
    }

    @Nonnull
    private IReactorSimulation getSimulation() throws LuaException {
        IReactorSimulation sim = this.getController().simulation();
        if (sim == null) {
            throw new LuaException("Invalid multiblock controller");
        }
        return sim;
    }

    @LuaFunction
    public boolean active() throws LuaException {
        return ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).isActive();
    }

    @LuaFunction
    public void setActive(boolean active) throws LuaException {
        ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).setActive(active ? ReactorActivity.ACTIVE : ReactorActivity.INACTIVE);
    }

    @LuaFunction
    public Battery battery() throws LuaException {
        if (((IReactorSimulation)this.simulationSupplier.get()).battery() == null) {
            return null;
        }
        return this.battery;
    }

    @LuaFunction
    public CoolantTank coolantTank() throws LuaException {
        if (((IReactorSimulation)this.simulationSupplier.get()).battery() != null) {
            return null;
        }
        return this.coolantTank;
    }

    @LuaFunction
    public FuelTank fuelTank() throws LuaException {
        return this.fuelTank;
    }

    @LuaFunction
    public int controlRodCount() {
        return this.controlRods.size();
    }

    @LuaFunction
    public ControlRod getControlRod(int index) {
        return this.controlRods.get(index);
    }

    @LuaFunction
    public void setAllControlRodLevels(double newLevel) throws LuaException {
        ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).setAllControlRodLevels(newLevel);
    }

    public void rebuildControlRodList() {
        ReactorMultiblockController controller = this.rawControllerSupplier.get();
        if (controller == null) {
            return;
        }
        this.controlRods.forEach(ControlRod::invalidate);
        this.controlRods.clear();
        for (int i = 0; i < controller.controlRodCount(); ++i) {
            this.controlRods.add(new ControlRod(this.controllerSupplier, i));
        }
    }

    @LuaFunction
    public double fuelTemperature() throws LuaException {
        return ((IReactorSimulation)this.simulationSupplier.get()).fuelHeat();
    }

    @LuaFunction
    @Deprecated(forRemoval=true, since="0.6.0")
    public double casingTemperature() throws LuaException {
        return this.stackTemperature();
    }

    @LuaFunction
    public double stackTemperature() throws LuaException {
        return ((IReactorSimulation)this.simulationSupplier.get()).stackHeat();
    }

    @LuaFunction
    public double ambientTemperature() throws LuaException {
        return ((IReactorSimulation)this.simulationSupplier.get()).ambientTemperature();
    }

    @Nonnull
    public String getType() {
        return "BiggerReactors_Reactor";
    }

    public boolean equals(@Nullable IPeripheral other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ReactorPeripheral) {
            if (this.rawControllerSupplier.get() == null) {
                return false;
            }
            return ((ReactorPeripheral)other).rawControllerSupplier.get() == this.rawControllerSupplier.get();
        }
        return false;
    }

    public static class Battery {
        @Nonnull
        private final LamdbaExceptionUtils.Supplier_WithExceptions<IReactorSimulation.IBattery, LuaException> batterySupplier = () -> {
            IReactorSimulation sim = (IReactorSimulation)simulationSupplier.get();
            IReactorSimulation.IBattery battery = sim.battery();
            if (battery == null) {
                throw new LuaException("Invalid reactor state");
            }
            return battery;
        };

        public Battery(@Nonnull LamdbaExceptionUtils.Supplier_WithExceptions<IReactorSimulation, LuaException> simulationSupplier) {
        }

        @LuaFunction
        public long stored() throws LuaException {
            return ((IReactorSimulation.IBattery)this.batterySupplier.get()).stored();
        }

        @LuaFunction
        public long capacity() throws LuaException {
            return ((IReactorSimulation.IBattery)this.batterySupplier.get()).capacity();
        }

        @LuaFunction
        public long producedLastTick() throws LuaException {
            return ((IReactorSimulation.IBattery)this.batterySupplier.get()).generatedLastTick();
        }
    }

    public static class CoolantTank {
        @Nonnull
        private final LamdbaExceptionUtils.Supplier_WithExceptions<IReactorSimulation.ICoolantTank, LuaException> coolantTankSupplier = () -> {
            IReactorSimulation sim = (IReactorSimulation)simulationSupplier.get();
            IReactorSimulation.ICoolantTank coolantTank = sim.coolantTank();
            if (coolantTank == null) {
                throw new LuaException("Invalid reactor state");
            }
            return coolantTank;
        };
        @Nonnull
        private final LamdbaExceptionUtils.Supplier_WithExceptions<ReactorTransitionTank, LuaException> transitionTankSupplier = () -> {
            ReactorMultiblockController controller = (ReactorMultiblockController)((Object)((Object)controllerSupplier.get()));
            ReactorTransitionTank transitionTank = controller.coolantTank();
            if (transitionTank == null) {
                throw new LuaException("Invalid reactor state");
            }
            return transitionTank;
        };

        public CoolantTank(@Nonnull LamdbaExceptionUtils.Supplier_WithExceptions<ReactorMultiblockController, LuaException> controllerSupplier, @Nonnull LamdbaExceptionUtils.Supplier_WithExceptions<IReactorSimulation, LuaException> simulationSupplier) {
        }

        @LuaFunction
        public long coldFluidAmount() throws LuaException {
            return ((IReactorSimulation.ICoolantTank)this.coolantTankSupplier.get()).liquidAmount();
        }

        @LuaFunction
        public long hotFluidAmount() throws LuaException {
            return ((IReactorSimulation.ICoolantTank)this.coolantTankSupplier.get()).vaporAmount();
        }

        @LuaFunction
        public long capacity() throws LuaException {
            return ((IReactorSimulation.ICoolantTank)this.coolantTankSupplier.get()).perSideCapacity();
        }

        @LuaFunction
        public long transitionedLastTick() throws LuaException {
            return ((IReactorSimulation.ICoolantTank)this.coolantTankSupplier.get()).transitionedLastTick();
        }

        @LuaFunction
        public long maxTransitionedLastTick() throws LuaException {
            return ((IReactorSimulation.ICoolantTank)this.coolantTankSupplier.get()).maxTransitionedLastTick();
        }

        @LuaFunction
        public void dump() throws LuaException {
            ((ReactorTransitionTank)((Object)this.transitionTankSupplier.get())).dumpLiquid();
            ((ReactorTransitionTank)((Object)this.transitionTankSupplier.get())).dumpVapor();
        }
    }

    public static class FuelTank {
        @Nonnull
        private final LamdbaExceptionUtils.Supplier_WithExceptions<ReactorMultiblockController, LuaException> controllerSupplier;
        @Nonnull
        private final LamdbaExceptionUtils.Supplier_WithExceptions<IReactorSimulation, LuaException> simulationSupplier;

        public FuelTank(@Nonnull LamdbaExceptionUtils.Supplier_WithExceptions<ReactorMultiblockController, LuaException> controllerSupplier, @Nonnull LamdbaExceptionUtils.Supplier_WithExceptions<IReactorSimulation, LuaException> simulationSupplier) {
            this.controllerSupplier = controllerSupplier;
            this.simulationSupplier = simulationSupplier;
        }

        @LuaFunction
        public long capacity() throws LuaException {
            return ((IReactorSimulation)this.simulationSupplier.get()).fuelTank().capacity();
        }

        @LuaFunction
        public long totalReactant() throws LuaException {
            return ((IReactorSimulation)this.simulationSupplier.get()).fuelTank().totalStored();
        }

        @LuaFunction
        public long fuel() throws LuaException {
            return ((IReactorSimulation)this.simulationSupplier.get()).fuelTank().fuel();
        }

        @LuaFunction
        public long waste() throws LuaException {
            return ((IReactorSimulation)this.simulationSupplier.get()).fuelTank().waste();
        }

        @LuaFunction
        public void ejectWaste() throws LuaException {
            ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).ejectWaste();
        }

        @LuaFunction
        public double fuelReactivity() throws LuaException {
            return ((IReactorSimulation)this.simulationSupplier.get()).fertility();
        }

        @LuaFunction
        public double burnedLastTick() throws LuaException {
            return ((IReactorSimulation)this.simulationSupplier.get()).fuelTank().burnedLastTick();
        }
    }

    public static class ControlRod {
        private final LamdbaExceptionUtils.Supplier_WithExceptions<ReactorMultiblockController, LuaException> controllerSupplier;
        private final int index;
        private boolean isValid = true;

        public ControlRod(LamdbaExceptionUtils.Supplier_WithExceptions<ReactorMultiblockController, LuaException> controllerSupplier, int index) {
            this.controllerSupplier = controllerSupplier;
            this.index = index;
        }

        @LuaFunction
        public boolean valid() {
            return this.isValid;
        }

        @LuaFunction
        public int index() {
            return this.index;
        }

        @LuaFunction
        public double level() throws LuaException {
            if (!this.isValid) {
                throw new LuaException("Invalid control rod object");
            }
            return ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).controlRodLevel(this.index);
        }

        @LuaFunction
        public void setLevel(double newLevel) throws LuaException {
            if (!this.isValid) {
                throw new LuaException("Invalid control rod object");
            }
            ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).setControlRodLevel(this.index, newLevel);
        }

        @LuaFunction
        public String name() throws LuaException {
            if (!this.isValid) {
                throw new LuaException("Invalid control rod object");
            }
            return ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).controlRodName(this.index);
        }

        @LuaFunction
        public void setName(String newName) throws LuaException {
            if (!this.isValid) {
                throw new LuaException("Invalid control rod object");
            }
            ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).setControlRodName(this.index, newName);
        }

        void invalidate() {
            this.isValid = false;
        }
    }
}

