/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.heatexchanger;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.blocks.HeatExchangerBaseBlock;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.tiles.HeatExchangerBaseTile;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.tiles.HeatExchangerChannelTile;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.tiles.HeatExchangerFluidPortTile;
import net.roguelogix.biggerreactors.util.FluidTransitionTank;
import net.roguelogix.phosphophyllite.Phosphophyllite;
import net.roguelogix.phosphophyllite.modular.block.IConnectedTexture;
import net.roguelogix.phosphophyllite.multiblock.MultiblockController;
import net.roguelogix.phosphophyllite.multiblock.MultiblockTileModule;
import net.roguelogix.phosphophyllite.multiblock.ValidationException;
import net.roguelogix.phosphophyllite.multiblock.common.IEventMultiblock;
import net.roguelogix.phosphophyllite.multiblock.common.IPersistentMultiblock;
import net.roguelogix.phosphophyllite.multiblock.rectangular.IRectangularMultiblock;
import net.roguelogix.phosphophyllite.multiblock.touching.ITouchingMultiblock;
import net.roguelogix.phosphophyllite.util.HeatBody;
import net.roguelogix.phosphophyllite.util.Util;
import org.joml.Vector3i;
import org.joml.Vector3ic;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class HeatExchangerMultiblockController
extends MultiblockController<HeatExchangerBaseTile, HeatExchangerBaseBlock, HeatExchangerMultiblockController>
implements IRectangularMultiblock<HeatExchangerBaseTile, HeatExchangerBaseBlock, HeatExchangerMultiblockController>,
IPersistentMultiblock<HeatExchangerBaseTile, HeatExchangerBaseBlock, HeatExchangerMultiblockController>,
ITouchingMultiblock<HeatExchangerBaseTile, HeatExchangerBaseBlock, HeatExchangerMultiblockController>,
IEventMultiblock<HeatExchangerBaseTile, HeatExchangerBaseBlock, HeatExchangerMultiblockController> {
    public final Set<HeatExchangerChannelTile> condenserChannels = new LinkedHashSet<HeatExchangerChannelTile>();
    public final Set<HeatExchangerChannelTile> evaporatorChannels = new LinkedHashSet<HeatExchangerChannelTile>();
    private final Set<HeatExchangerFluidPortTile> fluidPorts = new LinkedHashSet<HeatExchangerFluidPortTile>();
    public final ReadWriteLock locks = new ReentrantReadWriteLock();
    public final FluidTransitionTank evaporatorTank = new FluidTransitionTank(false);
    public final FluidTransitionTank condenserTank = new FluidTransitionTank(true);
    public final HeatBody ambientHeatBody = new HeatBody();
    public final HeatBody airHeatBody = new HeatBody();
    public final HeatBody condenserHeatBody = new HeatBody();
    public final HeatBody evaporatorHeatBody = new HeatBody();
    public double channelRFKT;
    public double evaporatorAirRFKT;
    public double condenserAirRFKT;
    public double airAmbientRFKT;

    public HeatExchangerMultiblockController(Level level) {
        super(level, HeatExchangerBaseTile.class, HeatExchangerBaseBlock.class);
    }

    @Nullable
    public Vector3ic minSize() {
        return new Vector3i(4, 3, 3);
    }

    @Nullable
    public Vector3ic maxSize() {
        return new Vector3i(Config.CONFIG.HeatExchanger.MaxLength, Config.CONFIG.HeatExchanger.MaxHeight, Config.CONFIG.HeatExchanger.MaxWidth);
    }

    public boolean allowedInteriorBlock(Block block) {
        return block instanceof AirBlock;
    }

    public void validateStage1() throws ValidationException {
        if (this.condenserChannels.isEmpty() || this.evaporatorChannels.isEmpty()) {
            throw new ValidationException((Component)Component.m_237115_((String)"multiblock.error.biggerreactors.heat_exchanger.missing_channel_type"));
        }
        if (this.fluidPorts.size() != 4) {
            throw new ValidationException((Component)Component.m_237115_((String)"multiblock.error.biggerreactors.heat_exchanger.invalid_port_count"));
        }
    }

    public void validateStage2() throws ValidationException {
        BlockPos channelPos;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int condenserPorts = 0;
        int evaporatorPorts = 0;
        for (HeatExchangerFluidPortTile fluidPort : this.fluidPorts) {
            BlockPos portPos = fluidPort.m_58899_();
            boolean channelFound = false;
            for (Direction value : Direction.values()) {
                mutableBlockPos.m_122190_((Vec3i)portPos);
                mutableBlockPos.m_122173_(value);
                BlockEntity tile = this.blocks.getTile((BlockPos)mutableBlockPos);
                if (!(tile instanceof HeatExchangerChannelTile)) continue;
                HeatExchangerChannelTile channelTile = (HeatExchangerChannelTile)tile;
                if (channelTile.CONDENSER) {
                    ++condenserPorts;
                } else {
                    ++evaporatorPorts;
                }
                channelFound = true;
                break;
            }
            if (channelFound) continue;
            throw new ValidationException((Component)Component.m_237110_((String)"multiblock.error.biggerreactors.heat_exchanger.fluid_port_unconnected", (Object[])new Object[]{portPos.m_123341_(), portPos.m_123342_(), portPos.m_123343_()}));
        }
        if (condenserPorts != 2 || evaporatorPorts != 2) {
            throw new ValidationException((Component)Component.m_237115_((String)"multiblock.error.biggerreactors.heat_exchanger.duplicate_port_types"));
        }
        this.verifyFluidChannels(this.condenserChannels);
        this.verifyFluidChannels(this.evaporatorChannels);
        long tick = Phosphophyllite.tickNumber();
        block2: for (HeatExchangerFluidPortTile fluidPort : this.fluidPorts) {
            if (fluidPort.lastCheckedTick == tick) continue;
            Direction nextDirection = null;
            for (Direction value : Direction.values()) {
                mutableBlockPos.m_122190_((Vec3i)fluidPort.m_58899_());
                mutableBlockPos.m_122173_(value);
                HeatExchangerBaseTile tile = (HeatExchangerBaseTile)this.blocks.getTile((BlockPos)mutableBlockPos);
                if (!(tile instanceof HeatExchangerChannelTile)) continue;
                nextDirection = value;
                break;
            }
            mutableBlockPos.m_122190_((Vec3i)fluidPort.m_58899_());
            if (nextDirection == null) {
                throw new ValidationException("Unknown channel verification error, this shouldn't be possible " + mutableBlockPos);
            }
            MultiblockTileModule currentModule = fluidPort.multiblockModule();
            while (true) {
                mutableBlockPos.m_122173_(nextDirection);
                currentModule = currentModule.getNeighbor(nextDirection);
                if (currentModule == null) {
                    throw new ValidationException("Unknown channel verification error, this shouldn't be possible " + mutableBlockPos);
                }
                HeatExchangerBaseTile channelTile = (HeatExchangerBaseTile)currentModule.iface;
                if (channelTile instanceof HeatExchangerFluidPortTile) continue block2;
                if (!(channelTile instanceof HeatExchangerChannelTile)) {
                    throw new ValidationException("Unknown channel verification error, this shouldn't be possible " + mutableBlockPos);
                }
                if (channelTile instanceof HeatExchangerChannelTile) {
                    ((HeatExchangerChannelTile)channelTile).lastCheckedTick = tick;
                }
                BlockState channelState = channelTile.m_58900_();
                if (nextDirection != Direction.DOWN && ((Boolean)channelState.m_61143_((Property)IConnectedTexture.Module.TOP_CONNECTED_PROPERTY)).booleanValue()) {
                    nextDirection = Direction.UP;
                    continue;
                }
                if (nextDirection != Direction.UP && ((Boolean)channelState.m_61143_((Property)IConnectedTexture.Module.BOTTOM_CONNECTED_PROPERTY)).booleanValue()) {
                    nextDirection = Direction.DOWN;
                    continue;
                }
                if (nextDirection != Direction.SOUTH && ((Boolean)channelState.m_61143_((Property)IConnectedTexture.Module.NORTH_CONNECTED_PROPERTY)).booleanValue()) {
                    nextDirection = Direction.NORTH;
                    continue;
                }
                if (nextDirection != Direction.NORTH && ((Boolean)channelState.m_61143_((Property)IConnectedTexture.Module.SOUTH_CONNECTED_PROPERTY)).booleanValue()) {
                    nextDirection = Direction.SOUTH;
                    continue;
                }
                if (nextDirection != Direction.WEST && ((Boolean)channelState.m_61143_((Property)IConnectedTexture.Module.EAST_CONNECTED_PROPERTY)).booleanValue()) {
                    nextDirection = Direction.EAST;
                    continue;
                }
                if (nextDirection == Direction.EAST || !((Boolean)channelState.m_61143_((Property)IConnectedTexture.Module.WEST_CONNECTED_PROPERTY)).booleanValue()) break;
                nextDirection = Direction.WEST;
            }
            throw new ValidationException("Unknown channel verification error, this shouldn't be possible " + mutableBlockPos);
        }
        for (HeatExchangerChannelTile condenserChannel : this.condenserChannels) {
            if (condenserChannel.lastCheckedTick == tick) continue;
            channelPos = condenserChannel.m_58899_();
            throw new ValidationException((Component)Component.m_237110_((String)"multiblock.error.biggerreactors.heat_exchanger.dangling_channel", (Object[])new Object[]{channelPos.m_123341_(), channelPos.m_123342_(), channelPos.m_123343_()}));
        }
        for (HeatExchangerChannelTile evaporatorChannel : this.evaporatorChannels) {
            if (evaporatorChannel.lastCheckedTick == tick) continue;
            channelPos = evaporatorChannel.m_58899_();
            throw new ValidationException((Component)Component.m_237110_((String)"multiblock.error.biggerreactors.heat_exchanger.dangling_channel", (Object[])new Object[]{channelPos.m_123341_(), channelPos.m_123342_(), channelPos.m_123343_()}));
        }
    }

    public void validateStage3() throws ValidationException {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        Util.chunkCachedBlockStateIteration((Vector3ic)this.min(), (Vector3ic)this.max(), (Level)this.level, (block, pos) -> {
            if (block.m_60734_() instanceof HeatExchangerBaseBlock) {
                mutableBlockPos.m_122178_(pos.x, pos.y, pos.z);
                if (!this.blocks.containsPos((BlockPos)mutableBlockPos)) {
                    throw new ValidationException((Component)Component.m_237110_((String)"multiblock.error.biggerreactors.heat_exchanger.dangling_internal_part", (Object[])new Object[]{pos.x, pos.y, pos.z}));
                }
            }
        });
    }

    private void verifyFluidChannels(Set<? extends HeatExchangerBaseTile> channels) throws ValidationException {
        for (HeatExchangerBaseTile heatExchangerBaseTile : channels) {
            BlockState state = heatExchangerBaseTile.m_58900_();
            int connectedSides = 0;
            connectedSides += (Boolean)state.m_61143_((Property)IConnectedTexture.Module.TOP_CONNECTED_PROPERTY) != false ? 1 : 0;
            connectedSides += (Boolean)state.m_61143_((Property)IConnectedTexture.Module.BOTTOM_CONNECTED_PROPERTY) != false ? 1 : 0;
            connectedSides += (Boolean)state.m_61143_((Property)IConnectedTexture.Module.NORTH_CONNECTED_PROPERTY) != false ? 1 : 0;
            connectedSides += (Boolean)state.m_61143_((Property)IConnectedTexture.Module.SOUTH_CONNECTED_PROPERTY) != false ? 1 : 0;
            connectedSides += (Boolean)state.m_61143_((Property)IConnectedTexture.Module.EAST_CONNECTED_PROPERTY) != false ? 1 : 0;
            if ((connectedSides += (Boolean)state.m_61143_((Property)IConnectedTexture.Module.WEST_CONNECTED_PROPERTY) != false ? 1 : 0) == 2) continue;
            throw new ValidationException("all fluid channels must have exactly two connections " + heatExchangerBaseTile.m_58899_());
        }
    }

    protected void onPartAdded(HeatExchangerBaseTile toAttach) {
        if (toAttach instanceof HeatExchangerChannelTile) {
            HeatExchangerChannelTile channelTile = (HeatExchangerChannelTile)toAttach;
            if (channelTile.CONDENSER) {
                this.condenserChannels.add(channelTile);
            } else {
                this.evaporatorChannels.add(channelTile);
            }
        }
        if (toAttach instanceof HeatExchangerFluidPortTile) {
            this.fluidPorts.add((HeatExchangerFluidPortTile)toAttach);
        }
    }

    protected void onPartRemoved(HeatExchangerBaseTile toDetach) {
        if (toDetach instanceof HeatExchangerChannelTile) {
            this.condenserChannels.remove((Object)toDetach);
        }
        if (toDetach instanceof HeatExchangerChannelTile) {
            HeatExchangerChannelTile channelTile = (HeatExchangerChannelTile)toDetach;
            if (channelTile.CONDENSER) {
                this.condenserChannels.remove((Object)channelTile);
            } else {
                this.evaporatorChannels.remove((Object)channelTile);
            }
        }
        if (toDetach instanceof HeatExchangerFluidPortTile) {
            this.fluidPorts.remove((Object)((HeatExchangerFluidPortTile)toDetach));
        }
    }

    public void onAssembled() {
        this.validationPassed();
    }

    public void onReassembled() {
        this.validationPassed();
    }

    private void validationPassed() {
        HeatExchangerBaseTile tile;
        double ambientTemperature = this.level.m_6042_().f_63857_() ? 423.15 : 293.15;
        this.ambientHeatBody.setTemperature(ambientTemperature);
        this.airHeatBody.setTemperature(ambientTemperature);
        this.condenserHeatBody.setTemperature(ambientTemperature);
        this.evaporatorHeatBody.setTemperature(ambientTemperature);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        this.condenserHeatBody.setRfPerKelvin((double)this.condenserChannels.size() * Config.CONFIG.HeatExchanger.ChannelFEPerKelvinUnitVolume);
        this.evaporatorHeatBody.setRfPerKelvin((double)this.evaporatorChannels.size() * Config.CONFIG.HeatExchanger.ChannelFEPerKelvinUnitVolume);
        this.condenserTank.perSideCapacity = (long)this.condenserChannels.size() * Config.CONFIG.HeatExchanger.ChannelTankVolumePerBlock;
        this.evaporatorTank.perSideCapacity = (long)this.evaporatorChannels.size() * Config.CONFIG.HeatExchanger.ChannelTankVolumePerBlock;
        Vector3i vec = new Vector3i(this.max()).sub(this.min()).add(1, 1, 1);
        int airVolume = vec.x * vec.y * vec.z;
        airVolume -= this.condenserChannels.size();
        this.airHeatBody.setRfPerKelvin((double)(airVolume -= this.evaporatorChannels.size()) * Config.CONFIG.HeatExchanger.AirFEPerKelvinUnitVolume);
        int channelContactArea = 0;
        int evaporatorAirContactArea = 0;
        int condenserAirContactArea = 0;
        int airAmbientContactArea = 0;
        for (HeatExchangerChannelTile condenserChannel : this.condenserChannels) {
            for (Direction value : Direction.values()) {
                mutableBlockPos.m_122190_((Vec3i)condenserChannel.m_58899_());
                mutableBlockPos.m_122173_(value);
                tile = (HeatExchangerBaseTile)this.blocks.getTile((BlockPos)mutableBlockPos);
                if (tile instanceof HeatExchangerChannelTile) {
                    HeatExchangerChannelTile channelTile = (HeatExchangerChannelTile)tile;
                    if (!channelTile.CONDENSER) {
                        ++channelContactArea;
                        continue;
                    }
                }
                if (tile instanceof HeatExchangerChannelTile) continue;
                ++condenserAirContactArea;
            }
        }
        for (HeatExchangerChannelTile condenserChannel : this.evaporatorChannels) {
            for (Direction value : Direction.values()) {
                mutableBlockPos.m_122190_((Vec3i)condenserChannel.m_58899_());
                mutableBlockPos.m_122173_(value);
                tile = (HeatExchangerBaseTile)this.blocks.getTile((BlockPos)mutableBlockPos);
                if (tile instanceof HeatExchangerChannelTile) continue;
                ++evaporatorAirContactArea;
            }
        }
        airAmbientContactArea = vec.x * vec.y + vec.x * vec.z + vec.y * vec.z;
        this.channelRFKT = (double)channelContactArea * Config.CONFIG.HeatExchanger.ChannelFEPerKelvinMetreSquared;
        this.condenserAirRFKT = (double)condenserAirContactArea * Config.CONFIG.HeatExchanger.AirFEPerKelvinMetreSquared;
        this.evaporatorAirRFKT = (double)evaporatorAirContactArea * Config.CONFIG.HeatExchanger.AirFEPerKelvinMetreSquared;
        this.airAmbientRFKT = (double)(airAmbientContactArea *= 2) * Config.CONFIG.HeatExchanger.AmbientFEPerKelvinMetreSquared;
        block4: for (HeatExchangerFluidPortTile coolantPort : this.fluidPorts) {
            BlockPos portPos = coolantPort.m_58899_();
            for (Direction value : Direction.values()) {
                mutableBlockPos.m_122190_((Vec3i)portPos);
                mutableBlockPos.m_122173_(value);
                BlockEntity tile2 = this.blocks.getTile((BlockPos)mutableBlockPos);
                if (!(tile2 instanceof HeatExchangerChannelTile)) continue;
                HeatExchangerChannelTile channelTile = (HeatExchangerChannelTile)tile2;
                coolantPort.setHETank(channelTile.CONDENSER ? this.condenserTank : this.evaporatorTank);
                coolantPort.setCondenser(channelTile.CONDENSER);
                continue block4;
            }
        }
        for (HeatExchangerFluidPortTile coolantPort : this.fluidPorts) {
            for (HeatExchangerFluidPortTile port : this.fluidPorts) {
                if (port.isCondenser() != coolantPort.isCondenser() || port == coolantPort) continue;
                port.setInlet(!coolantPort.isInlet());
            }
        }
        this.ambientHeatBody.setInfinite(true);
    }

    public void tick() {
        this.condenserTank.transferWith(this.condenserHeatBody, (double)this.condenserChannels.size() * Config.CONFIG.HeatExchanger.ChannelInternalSurfaceArea);
        this.condenserHeatBody.transferWith(this.airHeatBody, this.condenserAirRFKT);
        this.condenserHeatBody.transferWith(this.evaporatorHeatBody, this.channelRFKT);
        this.evaporatorHeatBody.transferWith(this.airHeatBody, this.evaporatorAirRFKT);
        this.evaporatorTank.transferWith(this.evaporatorHeatBody, (double)this.evaporatorChannels.size() * Config.CONFIG.HeatExchanger.ChannelInternalSurfaceArea);
        this.airHeatBody.transferWith(this.ambientHeatBody, this.airAmbientRFKT);
        this.fluidPorts.forEach(HeatExchangerFluidPortTile::pushFluid);
        if (Phosphophyllite.tickNumber() % 2L == 0L) {
            this.dirty();
        }
    }

    public CompoundTag mergeNBTs(CompoundTag nbtA, CompoundTag nbtB) {
        return nbtA;
    }

    public void read(CompoundTag nbt) {
        this.condenserTank.deserializeNBT(nbt.m_128469_("condenserTank"));
        this.evaporatorTank.deserializeNBT(nbt.m_128469_("evaporatorTank"));
        this.ambientHeatBody.setTemperature(nbt.m_128459_("ambientHeatBody"));
        this.airHeatBody.setTemperature(nbt.m_128459_("airHeatBody"));
        this.condenserHeatBody.setTemperature(nbt.m_128459_("condenserHeatBody"));
        this.evaporatorHeatBody.setTemperature(nbt.m_128459_("evaporatorHeatBody"));
    }

    @Nonnull
    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("condenserTank", (Tag)this.condenserTank.serializeNBT());
        nbt.m_128365_("evaporatorTank", (Tag)this.evaporatorTank.serializeNBT());
        nbt.m_128347_("ambientHeatBody", this.ambientHeatBody.temperature());
        nbt.m_128347_("airHeatBody", this.airHeatBody.temperature());
        nbt.m_128347_("condenserHeatBody", this.condenserHeatBody.temperature());
        nbt.m_128347_("evaporatorHeatBody", this.evaporatorHeatBody.temperature());
        return nbt;
    }

    public void setInletPort(HeatExchangerFluidPortTile port, boolean inlet) {
        port.setInlet(inlet);
        for (HeatExchangerFluidPortTile coolantPort : this.fluidPorts) {
            if (coolantPort == port || coolantPort.isCondenser() != port.isCondenser()) continue;
            coolantPort.setInlet(!inlet);
        }
    }

    public void runRequest(String requestName, @Nullable Object requestData) {
        switch (requestName) {
            case "dumpTanks": {
                if (!(requestData instanceof Boolean)) {
                    return;
                }
                if (((Boolean)requestData).booleanValue()) {
                    this.condenserTank.dumpTank(0);
                    this.condenserTank.dumpTank(1);
                    break;
                }
                this.evaporatorTank.dumpTank(0);
                this.evaporatorTank.dumpTank(1);
            }
        }
    }
}

