/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.File;
import java.util.Objects;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.common.client.IconExport;
import net.blay09.mods.balm.common.config.ConfigJsonExport;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameRules;

public class BalmCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"balm").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"dev").requires(BalmCommand::mayEnableDevMode)).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            MinecraftServer server = source.m_81377_();
            GameRules gameRules = server.m_129900_();
            ((GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46140_)).m_46246_(false, server);
            source.m_288197_(() -> Component.m_237113_((String)"Daylight cycle disabled"), true);
            ((GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46150_)).m_46246_(false, server);
            source.m_288197_(() -> Component.m_237113_((String)"Weather cycle disabled"), true);
            ((GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46133_)).m_46246_(true, server);
            source.m_288197_(() -> Component.m_237113_((String)"Keep Inventory enabled"), true);
            ((GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46155_)).m_46246_(false, server);
            source.m_288197_(() -> Component.m_237113_((String)"Insomnia disabled"), true);
            ((GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46132_)).m_46246_(false, server);
            source.m_288197_(() -> Component.m_237113_((String)"Mob Griefing disabled"), true);
            ((GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46125_)).m_46246_(false, server);
            source.m_288197_(() -> Component.m_237113_((String)"Trader Spawning disabled"), true);
            server.m_129827_(Difficulty.PEACEFUL, true);
            source.m_288197_(() -> Component.m_237113_((String)"Difficulty set to Peaceful"), true);
            server.m_129783_().m_8606_(99999, 0, false, false);
            source.m_288197_(() -> Component.m_237113_((String)"Weather cleared"), true);
            for (ServerLevel level : server.m_129785_()) {
                level.m_8615_(1000L);
            }
            source.m_288197_(() -> Component.m_237113_((String)"Set the time to Daytime"), true);
            return 0;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"export").then(Commands.m_82127_((String)"config").then(Commands.m_82129_((String)"class", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String className = (String)context.getArgument("class", String.class);
            try {
                Class<?> configDataClass = Class.forName(className);
                ConfigJsonExport.exportToFile(configDataClass, new File("exports/config/" + configDataClass.getSimpleName() + ".json"));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new RuntimeException("Invalid config data class: " + className, e);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Error exporting config data class: " + className, e);
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Exported config for " + className)), false);
            return 0;
        })))).then(Commands.m_82127_((String)"icons").then(Commands.m_82129_((String)"filter", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String filter = (String)context.getArgument("filter", String.class);
            if (Balm.getProxy().isClient()) {
                try {
                    IconExport.export(filter);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("Error exporting icons for " + filter, e);
                }
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Exported icons for " + filter)), false);
                return 1;
            }
            return 0;
        })))));
    }

    private static boolean mayEnableDevMode(CommandSourceStack it) {
        ServerPlayer player;
        if (it.m_6761_(2)) {
            return true;
        }
        MinecraftServer server = it.m_81377_();
        if (server.m_129792_() && (player = it.m_230896_()) != null) {
            return Objects.equals(player.m_36316_(), server.m_236731_());
        }
        return false;
    }
}

