/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.network;

import com.almostreliable.merequester.client.abstraction.AbstractRequesterScreen;
import com.almostreliable.merequester.network.ServerToClientPacket;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class RequesterSyncPacket
extends ServerToClientPacket<RequesterSyncPacket> {
    private boolean clearData;
    private long requesterId;
    private CompoundTag data;

    private RequesterSyncPacket(boolean clearData, long requesterId, CompoundTag data) {
        this.clearData = clearData;
        this.requesterId = requesterId;
        this.data = data;
    }

    RequesterSyncPacket() {
    }

    public static RequesterSyncPacket clearData() {
        return new RequesterSyncPacket(true, -1L, new CompoundTag());
    }

    public static RequesterSyncPacket inventory(long requesterId, CompoundTag data) {
        return new RequesterSyncPacket(false, requesterId, data);
    }

    @Override
    public void encode(RequesterSyncPacket packet, FriendlyByteBuf buffer) {
        buffer.writeBoolean(packet.clearData);
        buffer.writeLong(packet.requesterId);
        buffer.m_130079_(packet.data);
    }

    @Override
    public RequesterSyncPacket decode(FriendlyByteBuf buffer) {
        return new RequesterSyncPacket(buffer.readBoolean(), buffer.readLong(), Objects.requireNonNull(buffer.m_130260_()));
    }

    @Override
    protected void handlePacket(RequesterSyncPacket packet, ClientLevel level) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof AbstractRequesterScreen) {
            AbstractRequesterScreen screen2 = (AbstractRequesterScreen)screen;
            screen2.updateFromMenu(packet.clearData, packet.requesterId, packet.data);
        }
    }
}

