/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.client.widgets;

import appeng.client.gui.style.ScreenStyle;
import com.almostreliable.merequester.Utils;
import com.almostreliable.merequester.client.abstraction.RequestDisplay;
import com.almostreliable.merequester.client.abstraction.RequesterReference;
import com.almostreliable.merequester.client.widgets.NumberField;
import com.almostreliable.merequester.client.widgets.StateBox;
import com.almostreliable.merequester.client.widgets.StatusDisplay;
import com.almostreliable.merequester.client.widgets.SubmitButton;
import com.almostreliable.merequester.platform.Platform;
import com.almostreliable.merequester.requester.Requests;
import com.almostreliable.merequester.requester.status.RequestStatus;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RequestWidget {
    private final RequestDisplay host;
    private final int index;
    private final int x;
    private final int y;
    private final ScreenStyle style;
    private final Map<String, AbstractWidget> subWidgets;
    private StateBox stateBox;
    private NumberField amountField;
    private NumberField batchField;
    private SubmitButton submitButton;
    private StatusDisplay statusDisplay;

    public RequestWidget(RequestDisplay host, int index, int x, int y, ScreenStyle style) {
        this.host = host;
        this.index = index;
        this.x = x;
        this.y = y;
        this.style = style;
        this.subWidgets = new HashMap<String, AbstractWidget>();
    }

    public void preInit(Map<String, AbstractWidget> widgetContainer) {
        this.subWidgets.forEach(widgetContainer::remove);
    }

    public void postInit() {
        this.stateBox = new StateBox(this.x, this.y, this.style, () -> this.stateBoxChanged(this.host.getTargetRequest(this.index)));
        this.host.addSubWidget(Utils.f("request_state_{}", this.index), (AbstractWidget)this.stateBox, this.subWidgets);
        this.amountField = new NumberField(this.x + 38, this.y, "amount", this.style, amount -> this.amountFieldSubmitted(this.host.getTargetRequest(this.index), (long)amount));
        this.host.addSubWidget(Utils.f("request_amount_{}", this.index), (AbstractWidget)this.amountField, this.subWidgets);
        this.batchField = new NumberField(this.x + 92, this.y, "batch", this.style, amount -> this.batchFieldSubmitted(this.host.getTargetRequest(this.index), (long)amount));
        this.host.addSubWidget(Utils.f("request_batch_{}", this.index), (AbstractWidget)this.batchField, this.subWidgets);
        this.submitButton = new SubmitButton(this.x + 146, this.y, this.style, () -> this.submitButtonClicked(this.host.getTargetRequest(this.index)));
        this.host.addSubWidget(Utils.f("request_submit_{}", this.index), (AbstractWidget)this.submitButton, this.subWidgets);
        this.statusDisplay = new StatusDisplay(this.x + 39, this.y + 15, () -> this.isInactive(this.host.getTargetRequest(this.index)));
        this.host.addSubWidget(Utils.f("request_status_{}", this.index), this.statusDisplay, this.subWidgets);
    }

    public void hide() {
        this.subWidgets.values().forEach(w -> {
            w.f_93624_ = false;
        });
    }

    public void applyRequest(Requests.Request request) {
        this.subWidgets.values().forEach(w -> {
            w.f_93624_ = true;
        });
        this.stateBox.setSelected(request.getState());
        RequestStatus status = request.getClientStatus();
        this.statusDisplay.setStatus(status);
        this.amountField.adjustToType(request.getKey());
        this.batchField.adjustToType(request.getKey());
        if (status.locksRequest()) {
            this.amountField.m_94186_(false);
            this.batchField.m_94186_(false);
        } else {
            this.amountField.m_94186_(true);
            this.batchField.m_94186_(true);
        }
        if (this.amountField.m_93696_() || this.batchField.m_93696_() || this.submitButton.m_93696_()) {
            return;
        }
        this.amountField.setLongValue(request.getAmount());
        this.batchField.setLongValue(request.getBatch());
    }

    private void stateBoxChanged(@Nullable Requests.Request request) {
        if (request == null) {
            return;
        }
        boolean newState = this.stateBox.isSelected();
        request.updateState(newState);
        long requesterId = ((RequesterReference)request.getRequesterReference()).getRequesterId();
        Platform.sendRequestUpdate(requesterId, request.getIndex(), newState);
    }

    private void amountFieldSubmitted(@Nullable Requests.Request request, long amount) {
        if (request == null) {
            return;
        }
        long oldValue = request.getAmount();
        request.updateAmount(amount);
        if (oldValue == request.getAmount()) {
            this.amountField.setLongValue(oldValue);
        } else {
            this.submitButtonClicked(request);
        }
    }

    private void batchFieldSubmitted(@Nullable Requests.Request request, long batch) {
        if (request == null) {
            return;
        }
        long oldValue = request.getBatch();
        request.updateBatch(batch);
        if (oldValue == request.getBatch()) {
            this.batchField.setLongValue(oldValue);
        } else {
            this.submitButtonClicked(request);
        }
    }

    private void submitButtonClicked(@Nullable Requests.Request request) {
        if (request == null) {
            return;
        }
        long amount = this.amountField.getLongValue().orElse(0L);
        long batch = this.batchField.getLongValue().orElse(1L);
        long requesterId = ((RequesterReference)request.getRequesterReference()).getRequesterId();
        Platform.sendRequestUpdate(requesterId, request.getIndex(), amount, batch);
    }

    private boolean isInactive(@Nullable Requests.Request request) {
        return request == null || !request.isRequesting() || request.getAmount() == 0L;
    }
}

