/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.cultivation.common.block.entity;

import cofh.thermal.cultivation.init.registries.TCulBlockEntities;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class PotionCakeBlockEntity
extends BlockEntity {
    protected CompoundTag potionTag = new CompoundTag();
    protected List<MobEffectInstance> effects = Collections.emptyList();

    public PotionCakeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TCulBlockEntities.POTION_CAKE_TILE.get(), pos, state);
    }

    public void cacheEffects(CompoundTag nbt) {
        if (nbt != null) {
            this.potionTag = nbt.m_6426_();
            this.effects = PotionUtils.m_43566_((CompoundTag)nbt);
        }
    }

    public void applyEffects(Player player) {
        for (MobEffectInstance effect : this.effects) {
            if (effect.m_19544_().m_8093_()) {
                effect.m_19544_().m_19461_(null, null, (LivingEntity)player, effect.m_19564_(), 0.5);
                continue;
            }
            MobEffectInstance potion = new MobEffectInstance(effect.m_19544_(), effect.m_19557_() / 4, effect.m_19564_(), effect.m_19571_(), effect.m_19572_());
            player.m_7292_(potion);
        }
    }

    public int getColor() {
        return this.effects.isEmpty() ? 0xF800F8 : PotionUtils.m_43564_(this.effects);
    }

    public ItemStack createItemStackTag(ItemStack stack) {
        stack.m_41751_(this.potionTag.m_6426_());
        return stack;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.cacheEffects(nbt.m_128469_("Potion"));
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.potionTag != null && !this.potionTag.m_128456_()) {
            nbt.m_128365_("Potion", (Tag)this.potionTag);
        }
    }
}

