/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.menu;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import tfar.dankstorage.inventory.DankInterface;
import tfar.dankstorage.inventory.LockedSlot;
import tfar.dankstorage.menu.CustomSync;
import tfar.dankstorage.network.client.S2CSendGhostSlotPacket;
import tfar.dankstorage.platform.Services;
import tfar.dankstorage.utils.CommonUtils;
import tfar.dankstorage.utils.PickupMode;

public abstract class AbstractDankMenu
extends AbstractContainerMenu {
    public final Inventory playerInventory;
    public final int rows;
    public final DankInterface dankInventory;
    protected final DataSlot pickup;

    public PickupMode getMode() {
        return PickupMode.VALUES[this.pickup.m_6501_()];
    }

    public AbstractDankMenu(MenuType<?> type, int windowId, Inventory playerInventory, DankInterface dankInventory) {
        super(type, windowId);
        this.playerInventory = playerInventory;
        this.dankInventory = dankInventory;
        this.rows = dankInventory.getContainerSizeDank() / 9;
        this.m_38884_(dankInventory);
        if (!playerInventory.f_35978_.m_9236_().f_46443_) {
            this.m_150416_(new CustomSync((ServerPlayer)playerInventory.f_35978_));
        }
        this.pickup = playerInventory.f_35978_.m_9236_().f_46443_ ? DataSlot.m_39401_() : this.getServerPickupData();
        this.m_38895_(this.pickup);
    }

    protected abstract DataSlot getServerPickupData();

    protected void addPlayerSlots(Inventory playerinventory, int locked) {
        int row;
        int yStart = 32 + 18 * this.rows;
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 8 + col * 18;
                int y = row * 18 + yStart;
                this.m_38897_(new Slot((Container)playerinventory, col + row * 9 + 9, x, y));
            }
        }
        for (row = 0; row < 9; ++row) {
            int x = 8 + row * 18;
            int y = yStart + 58;
            if (row != locked) {
                this.m_38897_(new Slot((Container)playerinventory, row, x, y));
                continue;
            }
            this.m_38897_(new LockedSlot((Container)playerinventory, row, x, y));
        }
    }

    public void m_150430_(int pSlotId, int pButton, ClickType pClickType, Player pPlayer) {
        if (pClickType == ClickType.SWAP && pSlotId > 0 && this.isDankSlot((Slot)this.f_38839_.get(pSlotId))) {
            return;
        }
        if (pClickType != ClickType.PICKUP) {
            super.m_150430_(pSlotId, pButton, pClickType, pPlayer);
        } else {
            Inventory inventory = pPlayer.m_150109_();
            if (this.f_38846_ != 0) {
                this.m_38951_();
            } else if (pButton == 0 || pButton == 1) {
                ClickAction clickaction;
                ClickAction clickAction = clickaction = pButton == 0 ? ClickAction.PRIMARY : ClickAction.SECONDARY;
                if (pSlotId == -999) {
                    if (!this.m_142621_().m_41619_()) {
                        if (clickaction == ClickAction.PRIMARY) {
                            pPlayer.m_36176_(this.m_142621_(), true);
                            this.m_142503_(ItemStack.f_41583_);
                        } else {
                            pPlayer.m_36176_(this.m_142621_().m_41620_(1), true);
                        }
                    }
                } else {
                    if (pSlotId < 0) {
                        return;
                    }
                    Slot slot7 = (Slot)this.f_38839_.get(pSlotId);
                    ItemStack itemstack9 = slot7.m_7993_();
                    ItemStack itemstack10 = this.m_142621_();
                    pPlayer.m_141945_(itemstack10, slot7.m_7993_(), clickaction);
                    if (!this.m_246200_(pPlayer, clickaction, slot7, itemstack9, itemstack10) && !Services.PLATFORM.onItemStackedOn(itemstack9, itemstack10, slot7, clickaction, pPlayer, this.m_150446_())) {
                        if (itemstack9.m_41619_()) {
                            if (!itemstack10.m_41619_()) {
                                int i3 = clickaction == ClickAction.PRIMARY ? itemstack10.m_41613_() : 1;
                                this.m_142503_(slot7.m_150656_(itemstack10, i3));
                            }
                        } else if (slot7.m_8010_(pPlayer)) {
                            if (itemstack10.m_41619_()) {
                                int j3 = clickaction == ClickAction.PRIMARY ? itemstack9.m_41613_() : (itemstack9.m_41613_() + 1) / 2;
                                Optional optional1 = slot7.m_150641_(j3, Integer.MAX_VALUE, pPlayer);
                                optional1.ifPresent(p_150421_ -> {
                                    this.m_142503_((ItemStack)p_150421_);
                                    slot7.m_142406_(pPlayer, p_150421_);
                                });
                            } else if (slot7.m_5857_(itemstack10)) {
                                if (ItemStack.m_150942_((ItemStack)itemstack9, (ItemStack)itemstack10)) {
                                    int k3 = clickaction == ClickAction.PRIMARY ? itemstack10.m_41613_() : 1;
                                    this.m_142503_(slot7.m_150656_(itemstack10, k3));
                                } else if (itemstack10.m_41613_() <= slot7.m_5866_(itemstack10) && itemstack9.m_41613_() <= itemstack9.m_41741_()) {
                                    this.m_142503_(itemstack9);
                                    slot7.m_269060_(itemstack10);
                                }
                            } else if (ItemStack.m_150942_((ItemStack)itemstack9, (ItemStack)itemstack10)) {
                                Optional optional = slot7.m_150641_(itemstack9.m_41613_(), itemstack10.m_41741_() - itemstack10.m_41613_(), pPlayer);
                                optional.ifPresent(p_150428_ -> {
                                    itemstack10.m_41769_(p_150428_.m_41613_());
                                    slot7.m_142406_(pPlayer, p_150428_);
                                });
                            }
                        }
                    }
                    slot7.m_6654_();
                }
            }
        }
    }

    public boolean m_6366_(Player player, int id) {
        if (id < 0 || id >= ButtonAction.VALUES.length) {
            return false;
        }
        ButtonAction buttonAction = ButtonAction.VALUES[id];
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            switch (buttonAction) {
                case LOCK_FREQUENCY: {
                    this.dankInventory.toggleFrequencyLock();
                    break;
                }
                case SORT: {
                    this.dankInventory.sort();
                    break;
                }
                case COMPRESS: {
                    this.dankInventory.compress(serverPlayer);
                    break;
                }
                case TOGGLE_TAG: {
                    CommonUtils.toggleTagMode(serverPlayer);
                    break;
                }
                case TOGGLE_PICKUP: {
                    CommonUtils.togglePickupMode(serverPlayer);
                }
            }
        }
        return true;
    }

    @Nonnull
    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (index < this.rows * 9 ? !this.m_38903_(slotStack, this.rows * 9, this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, this.rows * 9, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    protected void addDankSlots() {
        int slotIndex = 0;
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 8 + col * 18;
                int y = row * 18 + 18;
                this.m_38897_(Services.PLATFORM.createSlot(this.dankInventory, slotIndex, x, y));
                ++slotIndex;
            }
        }
    }

    public boolean m_6875_(@Nonnull Player playerIn) {
        return true;
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean reverse) {
        Slot slot;
        boolean didSomething = false;
        int i = startIndex;
        if (reverse) {
            i = endIndex - 1;
        }
        while (!stack.m_41619_() && !(!reverse ? i >= endIndex : i < startIndex)) {
            slot = (Slot)this.f_38839_.get(i);
            ItemStack slotStack = slot.m_7993_();
            if (!slotStack.m_41619_() && slotStack.m_41720_() == stack.m_41720_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)slotStack)) {
                int maxSize;
                int combinedCount = slotStack.m_41613_() + stack.m_41613_();
                if (combinedCount <= (maxSize = slot.m_5866_(slotStack))) {
                    stack.m_41764_(0);
                    slotStack.m_41764_(combinedCount);
                    slot.m_6654_();
                    didSomething = true;
                } else if (slotStack.m_41613_() < maxSize) {
                    stack.m_41774_(maxSize - slotStack.m_41613_());
                    slotStack.m_41764_(maxSize);
                    slot.m_6654_();
                    didSomething = true;
                }
            }
            i += reverse ? -1 : 1;
        }
        if (!stack.m_41619_()) {
            i = reverse ? endIndex - 1 : startIndex;
            while (!(!reverse ? i >= endIndex : i < startIndex)) {
                slot = (Slot)this.f_38839_.get(i);
                ItemStack itemstack1 = slot.m_7993_();
                if (itemstack1.m_41619_() && slot.m_5857_(stack)) {
                    if (stack.m_41613_() > slot.m_5866_(stack)) {
                        slot.m_5852_(stack.m_41620_(slot.m_5866_(stack)));
                    } else {
                        slot.m_5852_(stack.m_41620_(stack.m_41613_()));
                    }
                    slot.m_6654_();
                    didSomething = true;
                    break;
                }
                i += reverse ? -1 : 1;
            }
        }
        return didSomething;
    }

    public boolean isDankSlot(Slot slot) {
        return slot.getClass().getName().endsWith("DankSlot");
    }

    public void m_38946_() {
        super.m_38946_();
        for (int i = 0; i < this.dankInventory.getDankStats().slots; ++i) {
            Services.PLATFORM.sendToClient(new S2CSendGhostSlotPacket(this.f_38840_, i, this.dankInventory.getGhostItem(i)), (ServerPlayer)this.playerInventory.f_35978_);
        }
    }

    public abstract void setFrequency(int var1);

    public static enum ButtonAction {
        LOCK_FREQUENCY,
        SORT,
        TOGGLE_TAG,
        TOGGLE_PICKUP,
        COMPRESS;

        static final ButtonAction[] VALUES;

        static {
            VALUES = ButtonAction.values();
        }
    }
}

