/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.client;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import tfar.dankstorage.client.DankTooltip;

public class ClientDankTooltip
implements ClientTooltipComponent {
    public static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("textures/gui/container/bundle.png");
    private static final int MARGIN_Y = 4;
    private static final int BORDER_WIDTH = 1;
    private static final int TEX_SIZE = 128;
    private static final int SLOT_SIZE_X = 18;
    private static final int SLOT_SIZE_Y = 18;
    private final NonNullList<ItemStack> items;
    private final int selected;

    public ClientDankTooltip(DankTooltip bundleTooltip) {
        this.items = bundleTooltip.getItems();
        this.selected = bundleTooltip.getSelected();
    }

    public int m_142103_() {
        return this.gridSizeY() * 18 + 4;
    }

    public int m_142069_(Font font) {
        return this.gridSizeX() * 18;
    }

    public void m_183452_(Font font, int i, int j, GuiGraphics poseStack) {
        int gridSizeX = this.gridSizeX();
        int gridSizeY = this.gridSizeY();
        int slot = 0;
        for (int y1 = 0; y1 < gridSizeY; ++y1) {
            for (int x1 = 0; x1 < gridSizeX; ++x1) {
                int q = i + x1 * 18;
                int r = j + y1 * 18;
                this.renderSlot(q, r, slot++, font, poseStack);
            }
        }
    }

    private void renderSlot(int i, int j, int slot, Font font, GuiGraphics poseStack) {
        ItemStack itemStack = (ItemStack)this.items.get(slot);
        this.blit(poseStack, i, j, Texture.SLOT);
        poseStack.m_280256_(itemStack, i + 1, j + 1, slot);
        poseStack.m_280370_(font, itemStack, i + 1, j + 1);
        if (slot == this.selected) {
            AbstractContainerScreen.m_280359_((GuiGraphics)poseStack, (int)(i + 1), (int)(j + 1), (int)0);
        }
    }

    private void blit(GuiGraphics pGuiGraphics, int pX, int pY, Texture pTexture) {
        pGuiGraphics.m_280398_(TEXTURE_LOCATION, pX, pY, 0, (float)pTexture.x, (float)pTexture.y, pTexture.w, pTexture.h, 128, 128);
    }

    private int gridSizeX() {
        return 9;
    }

    private int gridSizeY() {
        return this.items.size() / this.gridSizeX();
    }

    static enum Texture {
        SLOT(0, 0, 18, 18),
        BLOCKED_SLOT(0, 40, 18, 18);

        public final int x;
        public final int y;
        public final int w;
        public final int h;

        private Texture(int j, int k, int l, int m) {
            this.x = j;
            this.y = k;
            this.w = l;
            this.h = m;
        }
    }
}

