/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.common.item;

import cofh.core.common.capability.CapabilityShieldItem;
import cofh.core.common.config.CoreClientConfig;
import cofh.core.util.ProxyUtils;
import cofh.lib.api.capability.IShieldItem;
import cofh.lib.api.item.IEnergyContainerItem;
import cofh.lib.common.energy.EnergyContainerItemWrapper;
import cofh.lib.common.item.ShieldItemCoFH;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.common.item.IMultiModeFluxItem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class FluxShieldItem
extends ShieldItemCoFH
implements IMultiModeFluxItem {
    protected float repelRange = 4.0f;
    protected float repelStrength = 1.5f;
    protected int maxEnergy;
    protected int extract;
    protected int receive;

    public FluxShieldItem(int enchantability, Item.Properties builder, int maxEnergy, int maxTransfer) {
        super(builder);
        this.maxEnergy = maxEnergy;
        this.extract = maxTransfer;
        this.receive = maxTransfer;
        this.setEnchantability(enchantability);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("blocking"), (stack, world, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_().equals(stack) ? 1.0f : 0.0f);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), this::getChargedModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), this::getEmpoweredModelProperty);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_() || ((Boolean)CoreClientConfig.alwaysShowDetails.get()).booleanValue()) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (((Boolean)CoreClientConfig.holdShiftForDetails.get()).booleanValue()) {
            tooltip.add((Component)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").m_130940_(ChatFormatting.GRAY));
        }
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluxShieldItemWrapper(stack, this);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.isEmpowered(stack)) {
            this.repel(world, (LivingEntity)player, stack);
        }
        if (this.hasEnergy(stack, true)) {
            return super.m_7203_(world, player, hand);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void repel(Level world, LivingEntity living, ItemStack stack) {
        if (this.useEnergy(stack, true, (Entity)living)) {
            float range = this.getRepelRange(stack);
            double r2 = range * range;
            float strength = this.getRepelStrength(stack);
            AABB searchArea = living.m_20191_().m_82400_((double)range);
            for (Entity entity : world.m_6249_((Entity)living, searchArea, EntitySelector.f_20406_)) {
                if (!(living.m_20280_(entity) < r2)) continue;
                Vec3 knockback = entity.m_20182_().m_82546_(living.m_20182_());
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).m_147240_((double)strength, -knockback.m_7096_(), -knockback.m_7094_());
                    continue;
                }
                entity.m_20256_(knockback.m_82541_().m_82490_((double)strength));
                entity.f_19812_ = true;
            }
        }
    }

    public float getRepelRange(ItemStack stack) {
        return this.repelRange;
    }

    public float getRepelStrength(ItemStack stack) {
        return this.repelStrength;
    }

    public void m_5929_(Level world, LivingEntity living, ItemStack stack, int useDuration) {
        if (!this.hasEnergy(stack, true)) {
            living.m_21253_();
        }
    }

    public boolean canPerformAction(ItemStack stack, ToolAction action) {
        return this.hasEnergy(stack, false) && super.canPerformAction(stack, action);
    }

    public boolean m_6832_(ItemStack stack, ItemStack repairMaterial) {
        return false;
    }

    @Override
    public boolean m_142522_(ItemStack stack) {
        return IMultiModeFluxItem.super.m_142522_(stack);
    }

    @Override
    public int m_142159_(ItemStack stack) {
        return IMultiModeFluxItem.super.m_142159_(stack);
    }

    @Override
    public int m_142158_(ItemStack stack) {
        return IMultiModeFluxItem.super.m_142158_(stack);
    }

    public int getExtract(ItemStack container) {
        return this.extract;
    }

    public int getReceive(ItemStack container) {
        return this.receive;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }

    protected class FluxShieldItemWrapper
    extends EnergyContainerItemWrapper
    implements IShieldItem {
        private final LazyOptional<IShieldItem> holder;
        final ItemStack shieldItem;

        FluxShieldItemWrapper(ItemStack shieldItem, IEnergyContainerItem container) {
            super(shieldItem, container, container.getEnergyCapability());
            this.holder = LazyOptional.of(() -> this);
            this.shieldItem = shieldItem;
        }

        public boolean canBlock(LivingEntity target, DamageSource source) {
            if (super.canBlock(target, source)) {
                return true;
            }
            if (!target.m_21254_() || target.m_6673_(source) || target.m_21023_(MobEffects.f_19607_) && source.m_269533_(DamageTypeTags.f_268745_)) {
                return false;
            }
            return source.m_19385_().equals("flux") && IShieldItem.canBlockDamagePosition((LivingEntity)target, (Vec3)source.m_7270_());
        }

        public float onBlock(LivingEntity target, DamageSource source, float amount) {
            Player player;
            if (FluxShieldItem.this.isEmpowered(this.shieldItem)) {
                FluxShieldItem.this.repel(target.f_19853_, target, this.shieldItem);
            }
            if (!(!(amount >= 3.0f) || target instanceof Player && (player = (Player)target).m_7500_())) {
                int extract = FluxShieldItem.this.getExtract(this.shieldItem);
                for (int energy = Math.min(this.getEnergyStored(), Mth.m_14167_((float)amount) * FluxShieldItem.this.getEnergyPerUse(false)); energy > 0; energy -= extract) {
                    FluxShieldItem.this.useEnergy(this.shieldItem, Math.min(extract, energy), false);
                }
            }
            return amount;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityShieldItem.SHIELD_ITEM_CAPABILITY) {
                return CapabilityShieldItem.SHIELD_ITEM_CAPABILITY.orEmpty(cap, this.holder);
            }
            return super.getCapability(cap, side);
        }
    }
}

