/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.filter.network;

import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public record PacketUpdateNBTItemFilter(TypedMap args) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("rftoolsbase", "update_nbt_item_filter");

    public static PacketUpdateNBTItemFilter create(FriendlyByteBuf buf) {
        return new PacketUpdateNBTItemFilter(TypedMapTools.readArguments((FriendlyByteBuf)buf));
    }

    public static PacketUpdateNBTItemFilter create(TypedMap arguments) {
        return new PacketUpdateNBTItemFilter(arguments);
    }

    protected boolean isValidItem(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof FilterModuleItem;
    }

    public void write(FriendlyByteBuf buf) {
        TypedMapTools.writeArguments((FriendlyByteBuf)buf, (TypedMap)this.args);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> ctx.player().ifPresent(playerEntity -> {
            ItemStack heldItem = playerEntity.m_21120_(InteractionHand.MAIN_HAND);
            if (heldItem.m_41619_()) {
                return;
            }
            if (!this.isValidItem(heldItem)) {
                return;
            }
            CompoundTag tagCompound = heldItem.m_41784_();
            for (Key akey : this.args.getKeys()) {
                String key = akey.name();
                if (Type.STRING.equals(akey.type())) {
                    tagCompound.m_128359_(key, (String)this.args.get(akey));
                    continue;
                }
                if (Type.INTEGER.equals(akey.type())) {
                    tagCompound.m_128405_(key, ((Integer)this.args.get(akey)).intValue());
                    continue;
                }
                if (Type.LONG.equals(akey.type())) {
                    tagCompound.m_128356_(key, ((Long)this.args.get(akey)).longValue());
                    continue;
                }
                if (Type.DOUBLE.equals(akey.type())) {
                    tagCompound.m_128347_(key, ((Double)this.args.get(akey)).doubleValue());
                    continue;
                }
                if (Type.BOOLEAN.equals(akey.type())) {
                    tagCompound.m_128379_(key, ((Boolean)this.args.get(akey)).booleanValue());
                    continue;
                }
                if (Type.BLOCKPOS.equals(akey.type())) {
                    throw new RuntimeException("BlockPos not supported for PacketUpdateNBTItem!");
                }
                if (Type.ITEMSTACK.equals(akey.type())) {
                    throw new RuntimeException("ItemStack not supported for PacketUpdateNBTItem!");
                }
                throw new RuntimeException(akey.type().getType().getSimpleName() + " not supported for PacketUpdateNBTItem!");
            }
        }));
    }
}

