/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.init;

import codechicken.lib.datagen.ItemModelProvider;
import codechicken.lib.datagen.recipe.RecipeProvider;
import codechicken.microblock.init.CBMicroblockModContent;
import codechicken.microblock.init.CBMicroblockTags;
import java.util.concurrent.CompletableFuture;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.Nullable;

public class DataGenerators {
    private static final CrashLock LOCK = new CrashLock("Already Initialized");

    public static void init() {
        LOCK.lock();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(DataGenerators::registerDataGens);
    }

    private static void registerDataGens(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        ExistingFileHelper files = event.getExistingFileHelper();
        gen.addProvider(event.includeClient(), (DataProvider)new ItemModels(output, files));
        gen.addProvider(event.includeServer(), (DataProvider)new ItemTagGen(output, event.getLookupProvider(), CompletableFuture.supplyAsync(TagsProvider.TagLookup::m_274566_), files));
        gen.addProvider(event.includeServer(), (DataProvider)new Recipes(output));
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
            super(output, "cb_microblock", existingFileHelper);
        }

        protected void registerModels() {
            this.generated((ItemLike)CBMicroblockModContent.MICRO_BLOCK_ITEM.get()).noTexture();
            this.generated((ItemLike)CBMicroblockModContent.STONE_ROD_ITEM.get());
            this.generated((ItemLike)CBMicroblockModContent.STONE_SAW.get());
            this.generated((ItemLike)CBMicroblockModContent.IRON_SAW.get());
            this.generated((ItemLike)CBMicroblockModContent.DIAMOND_SAW.get());
        }
    }

    private static class ItemTagGen
    extends ItemTagsProvider {
        public ItemTagGen(PackOutput output, CompletableFuture<HolderLookup.Provider> providerLookup, CompletableFuture<TagsProvider.TagLookup<Block>> tagLookup, @Nullable ExistingFileHelper files) {
            super(output, providerLookup, tagLookup, "cb_microblock", files);
        }

        protected void m_6577_(HolderLookup.Provider pProvider) {
            this.m_206424_(CBMicroblockTags.Items.TOOL_SAW).m_255245_((Object)((Item)CBMicroblockModContent.STONE_SAW.get())).m_255245_((Object)((Item)CBMicroblockModContent.IRON_SAW.get())).m_255245_((Object)((Item)CBMicroblockModContent.DIAMOND_SAW.get()));
            this.m_206424_(CBMicroblockTags.Items.STONE_ROD).m_255245_((Object)((Item)CBMicroblockModContent.STONE_ROD_ITEM.get()));
        }
    }

    private static class Recipes
    extends RecipeProvider {
        public Recipes(PackOutput output) {
            super(output, "cb_microblock");
        }

        protected void registerRecipes() {
            this.special((SimpleCraftingRecipeSerializer)CBMicroblockModContent.MICRO_RECIPE_SERIALIZER.get(), new ResourceLocation("cb_microblock", "microblock"));
            this.shapedRecipe((ItemLike)CBMicroblockModContent.STONE_ROD_ITEM.get()).key('S', Tags.Items.COBBLESTONE).patternLine("S").patternLine("S");
            this.shapedRecipe((ItemLike)CBMicroblockModContent.STONE_SAW.get()).key('S', Tags.Items.RODS_WOODEN).key('R', CBMicroblockTags.Items.STONE_ROD).key('M', (ItemLike)Items.f_42484_).patternLine("SRR").patternLine("SMR");
            this.shapedRecipe((ItemLike)CBMicroblockModContent.IRON_SAW.get()).key('S', Tags.Items.RODS_WOODEN).key('R', CBMicroblockTags.Items.STONE_ROD).key('M', Tags.Items.INGOTS_IRON).patternLine("SRR").patternLine("SMR");
            this.shapedRecipe((ItemLike)CBMicroblockModContent.DIAMOND_SAW.get()).key('S', Tags.Items.RODS_WOODEN).key('R', CBMicroblockTags.Items.STONE_ROD).key('M', Tags.Items.GEMS_DIAMOND).patternLine("SRR").patternLine("SMR");
        }
    }
}

