/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.locator;

import appeng.api.util.DimensionalBlockPos;
import appeng.menu.locator.BlockEntityLocator;
import appeng.menu.locator.MenuItemLocator;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.PartLocator;
import appeng.parts.AEBasePart;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class MenuLocators {
    private static final Map<String, Registration<?>> REGISTRY = new HashMap();

    public static synchronized <T extends MenuLocator> void register(Class<T> locatorClass, BiConsumer<T, FriendlyByteBuf> packetWriter, Function<FriendlyByteBuf, T> packetReader) {
        String classKey = locatorClass.getName();
        if (REGISTRY.containsKey(classKey)) {
            throw new IllegalStateException("MenuLocator type " + classKey + " is already registered.");
        }
        REGISTRY.put(classKey, new Registration<T>(locatorClass, packetWriter, packetReader));
    }

    private static synchronized Registration<?> getRegistration(String classKey) {
        Registration<?> registration = REGISTRY.get(classKey);
        if (registration == null) {
            throw new IllegalArgumentException("Unregistered menu locator class: " + classKey);
        }
        return registration;
    }

    public static <T extends MenuLocator> void writeToPacket(FriendlyByteBuf buf, T locator) {
        String classKey = locator.getClass().getName();
        Registration<?> registration = MenuLocators.getRegistration(classKey);
        buf.m_130070_(classKey);
        registration.writeToPacket.accept(locator, buf);
    }

    public static MenuLocator readFromPacket(FriendlyByteBuf buf) {
        String classKey = buf.m_130277_();
        Registration<?> registration = MenuLocators.getRegistration(classKey);
        return (MenuLocator)registration.readFromPacket.apply(buf);
    }

    public static MenuLocator forBlockEntity(BlockEntity te) {
        if (te.m_58904_() == null) {
            throw new IllegalArgumentException("Cannot open a block entity that is not in a level");
        }
        return new BlockEntityLocator(te.m_58899_());
    }

    public static MenuLocator forPart(AEBasePart part) {
        DimensionalBlockPos pos = part.getHost().getLocation();
        return new PartLocator(pos.getPos(), part.getSide());
    }

    public static MenuLocator forItemUseContext(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            throw new IllegalArgumentException("Cannot open a menu without a player");
        }
        int slot = MenuLocators.getPlayerInventorySlotFromHand(player, context.m_43724_());
        return new MenuItemLocator(slot, context.m_8083_());
    }

    public static MenuLocator forHand(Player player, InteractionHand hand) {
        int slot = MenuLocators.getPlayerInventorySlotFromHand(player, hand);
        return MenuLocators.forInventorySlot(slot);
    }

    public static MenuLocator forInventorySlot(int inventorySlot) {
        return new MenuItemLocator(inventorySlot, null);
    }

    private static int getPlayerInventorySlotFromHand(Player player, InteractionHand hand) {
        ItemStack is = player.m_21120_(hand);
        if (is.m_41619_()) {
            throw new IllegalArgumentException("Cannot open an item-inventory with empty hands");
        }
        int invSize = player.m_150109_().m_6643_();
        for (int i = 0; i < invSize; ++i) {
            if (player.m_150109_().m_8020_(i) != is) continue;
            return i;
        }
        throw new IllegalArgumentException("Could not find item held in hand " + hand + " in player inventory");
    }

    static {
        MenuLocators.register(BlockEntityLocator.class, BlockEntityLocator::writeToPacket, BlockEntityLocator::readFromPacket);
        MenuLocators.register(PartLocator.class, PartLocator::writeToPacket, PartLocator::readFromPacket);
        MenuLocators.register(MenuItemLocator.class, MenuItemLocator::writeToPacket, MenuItemLocator::readFromPacket);
    }

    private record Registration<T extends MenuLocator>(Class<T> locatorClass, BiConsumer<T, FriendlyByteBuf> writeToPacket, Function<FriendlyByteBuf, T> readFromPacket) {
    }
}

