/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu;

import appeng.api.behaviors.ContainerItemContext;
import appeng.api.behaviors.ContainerItemStrategies;
import appeng.api.behaviors.EmptyingAction;
import appeng.api.config.Actionable;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.parts.IPart;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.core.AELog;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.GuiDataSyncPacket;
import appeng.helpers.InventoryAction;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.me.helpers.PlayerSource;
import appeng.menu.SlotSemantic;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.DataSynchronization;
import appeng.menu.locator.MenuLocator;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.CraftingMatrixSlot;
import appeng.menu.slot.CraftingTermSlot;
import appeng.menu.slot.DisabledSlot;
import appeng.menu.slot.FakeSlot;
import appeng.menu.slot.InaccessibleSlot;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.util.ConfigMenuInventory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;

public abstract class AEBaseMenu
extends AbstractContainerMenu {
    private static final int MAX_STRING_LENGTH = Short.MAX_VALUE;
    private static final String HIDE_SLOT = "HideSlot";
    private final IActionSource mySrc;
    @Nullable
    private final BlockEntity blockEntity;
    @Nullable
    private final IPart part;
    @Nullable
    protected final ItemMenuHost itemMenuHost;
    private final DataSynchronization dataSync = new DataSynchronization((Object)this);
    private final Inventory playerInventory;
    private final Set<Integer> lockedPlayerInventorySlots = new HashSet<Integer>();
    private final Map<Slot, SlotSemantic> semanticBySlot = new HashMap<Slot, SlotSemantic>();
    private final ArrayListMultimap<SlotSemantic, Slot> slotsBySemantic = ArrayListMultimap.create();
    private final Map<String, ClientAction<?>> clientActions = new HashMap();
    private boolean menuValid = true;
    private MenuLocator locator;
    private final Set<Slot> clientSideSlot = new HashSet<Slot>();
    private boolean returnedFromSubScreen;

    public AEBaseMenu(MenuType<?> menuType, int id, Inventory playerInventory, Object host) {
        super(menuType, id);
        this.playerInventory = playerInventory;
        this.blockEntity = host instanceof BlockEntity ? (BlockEntity)host : null;
        this.part = host instanceof IPart ? (IPart)host : null;
        ItemMenuHost itemMenuHost = this.itemMenuHost = host instanceof ItemMenuHost ? (ItemMenuHost)host : null;
        if (host != null && this.blockEntity == null && this.part == null && this.itemMenuHost == null) {
            throw new IllegalArgumentException("Must have a valid host, instead " + host + " in " + playerInventory);
        }
        if (this.itemMenuHost != null && this.itemMenuHost.getSlot() != null) {
            this.lockPlayerInventorySlot(this.itemMenuHost.getSlot());
        }
        this.mySrc = new PlayerSource(this.getPlayer(), this.getActionHost());
        this.registerClientAction(HIDE_SLOT, String.class, this::hideSlot);
    }

    protected final IActionHost getActionHost() {
        if (this.itemMenuHost instanceof IActionHost) {
            return (IActionHost)((Object)this.itemMenuHost);
        }
        if (this.blockEntity instanceof IActionHost) {
            return (IActionHost)this.blockEntity;
        }
        if (this.part instanceof IActionHost) {
            return (IActionHost)((Object)this.part);
        }
        return null;
    }

    protected final boolean isActionHost() {
        return this.itemMenuHost instanceof IActionHost || this.blockEntity instanceof IActionHost || this.part instanceof IActionHost;
    }

    public Player getPlayer() {
        return this.getPlayerInventory().f_35978_;
    }

    public IActionSource getActionSource() {
        return this.mySrc;
    }

    public Inventory getPlayerInventory() {
        return this.playerInventory;
    }

    public void lockPlayerInventorySlot(int invSlot) {
        Preconditions.checkArgument((invSlot >= 0 && invSlot < this.playerInventory.m_6643_() ? 1 : 0) != 0, (String)"cannot lock player inventory slot: %s", (int)invSlot);
        this.lockedPlayerInventorySlots.add(invSlot);
    }

    public final boolean isPlayerInventorySlotLocked(int invSlot) {
        return this.lockedPlayerInventorySlots.contains(invSlot);
    }

    public Object getTarget() {
        if (this.blockEntity != null) {
            return this.blockEntity;
        }
        if (this.part != null) {
            return this.part;
        }
        return this.itemMenuHost;
    }

    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    protected final void createPlayerInventorySlots(Inventory playerInventory) {
        Preconditions.checkState((boolean)this.getSlots(SlotSemantics.PLAYER_INVENTORY).isEmpty(), (Object)"Player inventory was already created");
        for (int i = 0; i < playerInventory.f_35974_.size(); ++i) {
            DisabledSlot slot = this.lockedPlayerInventorySlots.contains(i) ? new DisabledSlot((Container)playerInventory, i) : new Slot((Container)playerInventory, i, 0, 0);
            SlotSemantic s = i < Inventory.m_36059_() ? SlotSemantics.PLAYER_HOTBAR : SlotSemantics.PLAYER_INVENTORY;
            this.addSlot(slot, s);
        }
    }

    protected Slot addSlot(Slot slot, SlotSemantic semantic) {
        Preconditions.checkState((!this.semanticBySlot.containsKey(slot = this.m_38897_(slot)) ? 1 : 0) != 0);
        this.semanticBySlot.put(slot, semantic);
        this.slotsBySemantic.put((Object)semantic, (Object)slot);
        return slot;
    }

    public Slot addClientSideSlot(Slot slot, SlotSemantic semantic) {
        Preconditions.checkState((boolean)this.isClientSide(), (Object)"Can only add client-side slots on the client");
        if (!this.clientSideSlot.add(slot)) {
            throw new IllegalStateException("Client-side slot already exists");
        }
        slot.f_40219_ = this.f_38839_.size();
        this.f_38839_.add((Object)slot);
        if (semantic != null) {
            this.semanticBySlot.put(slot, semantic);
            this.slotsBySemantic.put((Object)semantic, (Object)slot);
        }
        return slot;
    }

    public void removeClientSideSlot(Slot slot) {
        if (this.f_38839_.get(slot.f_40219_) != slot) {
            throw new IllegalStateException("Trying to remove slot which isn't currently in the menu");
        }
        if (!this.clientSideSlot.remove(slot)) {
            throw new IllegalStateException("Trying to remove slot which isn't a client-side slot");
        }
        this.f_38839_.remove(slot.f_40219_);
        this.semanticBySlot.remove(slot);
        this.slotsBySemantic.values().remove(slot);
        for (int i = slot.f_40219_; i < this.f_38839_.size(); ++i) {
            ((Slot)this.f_38839_.get((int)i)).f_40219_ = i;
        }
    }

    public boolean isClientSideSlot(Slot slot) {
        return this.clientSideSlot.contains(slot);
    }

    public List<Slot> getSlots(SlotSemantic semantic) {
        return this.slotsBySemantic.get((Object)semantic);
    }

    protected Slot m_38897_(Slot newSlot) {
        if (newSlot instanceof AppEngSlot) {
            AppEngSlot s = (AppEngSlot)newSlot;
            s.setMenu(this);
        }
        return super.m_38897_(newSlot);
    }

    public void m_182410_(int stateId, List<ItemStack> items, ItemStack carried) {
        for (int i = 0; i < items.size(); ++i) {
            Slot slot = this.m_38853_(i);
            if (slot instanceof AppEngSlot) {
                AppEngSlot aeSlot = (AppEngSlot)slot;
                aeSlot.initialize(items.get(i));
                continue;
            }
            slot.m_5852_(items.get(i));
        }
        this.m_142503_(carried);
        this.f_182405_ = stateId;
    }

    public void m_38946_() {
        if (!this.isValidMenu()) {
            return;
        }
        if (this.itemMenuHost != null && !this.itemMenuHost.onBroadcastChanges(this)) {
            this.setValidMenu(false);
            return;
        }
        if (this.isServerSide()) {
            if (this.blockEntity != null && this.blockEntity.m_58904_().m_7702_(this.blockEntity.m_58899_()) != this.blockEntity) {
                this.setValidMenu(false);
            }
            if (this.dataSync.hasChanges()) {
                this.sendPacketToClient(new GuiDataSyncPacket(this.f_38840_, this.dataSync::writeUpdate));
            }
        }
        super.m_38946_();
    }

    private boolean isPlayerSideSlot(Slot slot) {
        if (slot.f_40218_ == this.playerInventory) {
            return true;
        }
        SlotSemantic slotSemantic = this.semanticBySlot.get(slot);
        return slotSemantic == SlotSemantics.PLAYER_INVENTORY || slotSemantic == SlotSemantics.PLAYER_HOTBAR || slotSemantic == SlotSemantics.TOOLBOX || slotSemantic == SlotSemantics.CRAFTING_GRID;
    }

    @Nullable
    public SlotSemantic getSlotSemantic(Slot s) {
        return this.semanticBySlot.get(s);
    }

    public void hideSlot(String semantic) {
        SlotSemantic slotSemantic;
        if (this.isClientSide()) {
            this.sendClientAction(HIDE_SLOT, semantic);
        }
        if ((slotSemantic = SlotSemantics.get(semantic)) == null) {
            return;
        }
        if (this.canSlotsBeHidden(slotSemantic)) {
            for (Slot s : this.getSlots(slotSemantic)) {
                if (!(s instanceof AppEngSlot)) continue;
                AppEngSlot slot = (AppEngSlot)s;
                slot.setSlotEnabled(false);
            }
        }
    }

    protected boolean canSlotsBeHidden(SlotSemantic semantic) {
        return false;
    }

    public ItemStack m_7648_(Player player, int idx) {
        if (this.isClientSide()) {
            return ItemStack.f_41583_;
        }
        Slot clickSlot = (Slot)this.f_38839_.get(idx);
        boolean playerSide = this.isPlayerSideSlot(clickSlot);
        if (clickSlot instanceof DisabledSlot || clickSlot instanceof InaccessibleSlot) {
            return ItemStack.f_41583_;
        }
        if (clickSlot.m_6657_()) {
            ItemStack tis = clickSlot.m_7993_();
            if (tis.m_41619_()) {
                return ItemStack.f_41583_;
            }
            ArrayList<Slot> selectedSlots = new ArrayList<Slot>();
            if (playerSide) {
                if (!(tis = this.transferStackToMenu(tis)).m_41619_()) {
                    for (Slot cs : this.f_38839_) {
                        if (this.isPlayerSideSlot(cs) || cs instanceof FakeSlot || cs instanceof CraftingMatrixSlot || !cs.m_5857_(tis)) continue;
                        selectedSlots.add(cs);
                    }
                }
            } else {
                tis = tis.m_41777_();
                for (Slot cs : this.f_38839_) {
                    if (!this.isPlayerSideSlot(cs) || cs instanceof FakeSlot || cs instanceof CraftingMatrixSlot || !cs.m_5857_(tis)) continue;
                    selectedSlots.add(cs);
                }
            }
            if (selectedSlots.isEmpty() && playerSide && !tis.m_41619_()) {
                for (Slot cs : this.f_38839_) {
                    if (!(cs instanceof FakeSlot) || this.isPlayerSideSlot(cs)) continue;
                    ItemStack destination = cs.m_7993_();
                    if (ItemStack.m_150942_((ItemStack)destination, (ItemStack)tis)) break;
                    if (!destination.m_41619_()) continue;
                    cs.m_5852_(tis.m_41777_());
                    this.m_38946_();
                    break;
                }
            }
            if (!tis.m_41619_()) {
                for (Slot d : selectedSlots) {
                    if (!d.m_5857_(tis) || !d.m_6657_() || !this.x(clickSlot, tis, d)) continue;
                    return ItemStack.f_41583_;
                }
                for (Slot d : selectedSlots) {
                    ItemStack tmp;
                    if (!d.m_5857_(tis)) continue;
                    if (d.m_6657_()) {
                        if (!this.x(clickSlot, tis, d)) continue;
                        return ItemStack.f_41583_;
                    }
                    int maxSize = tis.m_41741_();
                    if (maxSize > d.m_6641_()) {
                        maxSize = d.m_6641_();
                    }
                    if ((tmp = tis.m_41777_()).m_41613_() > maxSize) {
                        tmp.m_41764_(maxSize);
                    }
                    tis.m_41764_(tis.m_41613_() - tmp.m_41613_());
                    d.m_5852_(tmp);
                    if (tis.m_41613_() <= 0) {
                        clickSlot.m_5852_(ItemStack.f_41583_);
                        d.m_6654_();
                        this.m_38946_();
                        return ItemStack.f_41583_;
                    }
                    this.m_38946_();
                }
            }
            clickSlot.m_5852_(!tis.m_41619_() ? tis : ItemStack.f_41583_);
        }
        this.m_38946_();
        return ItemStack.f_41583_;
    }

    private boolean x(Slot clickSlot, ItemStack tis, Slot d) {
        ItemStack t = d.m_7993_().m_41777_();
        if (ItemStack.m_150942_((ItemStack)t, (ItemStack)tis)) {
            int placeable;
            int maxSize = t.m_41741_();
            if (maxSize > d.m_6641_()) {
                maxSize = d.m_6641_();
            }
            if ((placeable = maxSize - t.m_41613_()) > 0) {
                if (tis.m_41613_() < placeable) {
                    placeable = tis.m_41613_();
                }
                t.m_41764_(t.m_41613_() + placeable);
                tis.m_41764_(tis.m_41613_() - placeable);
                d.m_5852_(t);
                if (tis.m_41613_() <= 0) {
                    clickSlot.m_5852_(ItemStack.f_41583_);
                    d.m_6654_();
                    this.m_38946_();
                    this.m_38946_();
                    return true;
                }
                this.m_38946_();
            }
        }
        return false;
    }

    public boolean m_6875_(Player PlayerEntity) {
        if (this.isValidMenu()) {
            if (this.blockEntity instanceof Container) {
                return ((Container)this.blockEntity).m_6542_(PlayerEntity);
            }
            return true;
        }
        return false;
    }

    public boolean m_5622_(Slot s) {
        if (s instanceof AppEngSlot) {
            return ((AppEngSlot)s).isDraggable();
        }
        return super.m_5622_(s);
    }

    public void setFilter(int slotIndex, ItemStack item) {
        if (slotIndex < 0 || slotIndex >= this.f_38839_.size()) {
            return;
        }
        Slot s = this.m_38853_(slotIndex);
        if (!(s instanceof AppEngSlot)) {
            return;
        }
        AppEngSlot appEngSlot = (AppEngSlot)s;
        if (!appEngSlot.isSlotEnabled()) {
            return;
        }
        if (s instanceof FakeSlot) {
            s.m_5852_(item);
        }
    }

    public void doAction(ServerPlayer player, InventoryAction action, int slot, long id) {
        ConfigMenuInventory configInv;
        AppEngSlot appEngSlot;
        Object object;
        if (slot < 0 || slot >= this.f_38839_.size()) {
            return;
        }
        Slot s = this.m_38853_(slot);
        if (s instanceof CraftingTermSlot) {
            CraftingTermSlot craftingTermSlot = (CraftingTermSlot)s;
            switch (action) {
                case CRAFT_SHIFT: 
                case CRAFT_ALL: 
                case CRAFT_ITEM: 
                case CRAFT_STACK: {
                    craftingTermSlot.doClick(action, (Player)player);
                }
            }
        }
        if (s instanceof FakeSlot) {
            FakeSlot fakeSlot = (FakeSlot)s;
            this.handleFakeSlotAction(fakeSlot, action);
            return;
        }
        if (s instanceof AppEngSlot && (object = (appEngSlot = (AppEngSlot)s).getInventory()) instanceof ConfigMenuInventory && (configInv = (ConfigMenuInventory)object).getDelegate().getMode() == GenericStackInv.Mode.STORAGE) {
            GenericStackInv realInv = configInv.getDelegate();
            int realInvSlot = appEngSlot.f_40217_;
            if (action == InventoryAction.FILL_ITEM) {
                AEKey what2 = realInv.getKey(realInvSlot);
                this.handleFillingHeldItem((amount, mode) -> realInv.extract(realInvSlot, what2, amount, mode), what2);
            } else if (action == InventoryAction.EMPTY_ITEM) {
                this.handleEmptyHeldItem((what, amount, mode) -> realInv.insert(realInvSlot, what, amount, mode));
            }
        }
        if (action == InventoryAction.MOVE_REGION) {
            SlotSemantic slotSemantic = this.getSlotSemantic(s);
            if (slotSemantic != null) {
                List<Slot> slotsToMove = List.copyOf(this.getSlots(slotSemantic));
                for (Slot slotToMove : slotsToMove) {
                    this.m_7648_((Player)player, slotToMove.f_40219_);
                }
            } else {
                this.m_7648_((Player)player, s.f_40219_);
            }
        }
    }

    protected final void handleFillingHeldItem(FillingSource source, AEKey what) {
        ContainerItemContext ctx = ContainerItemStrategies.findCarriedContextForKey(what, this.getPlayer(), this);
        if (ctx == null) {
            return;
        }
        long canPull = source.extract(Long.MAX_VALUE, Actionable.SIMULATE);
        if (canPull <= 0L) {
            return;
        }
        long amountAllowed = ctx.insert(what, canPull, Actionable.SIMULATE);
        if (amountAllowed == 0L) {
            return;
        }
        long extracted = source.extract(amountAllowed, Actionable.MODULATE);
        if (extracted <= 0L) {
            AELog.error("Unable to pull fluid out of the ME system even though the simulation said yes ", new Object[0]);
            return;
        }
        long inserted = ctx.insert(what, extracted, Actionable.MODULATE);
        if (inserted == 0L) {
            return;
        }
        ctx.playFillSound(this.getPlayer(), what);
    }

    protected final void handleEmptyHeldItem(EmptyingSink sink) {
        long amount;
        ContainerItemContext ctx = ContainerItemStrategies.findCarriedContext(null, this.getPlayer(), this);
        if (ctx == null) {
            return;
        }
        GenericStack content = ctx.getExtractableContent();
        if (content == null) {
            return;
        }
        AEKey what = content.what();
        long canInsert = sink.insert(what, amount = content.amount(), Actionable.SIMULATE);
        if (canInsert <= 0L) {
            return;
        }
        long extracted = ctx.extract(what, canInsert, Actionable.MODULATE);
        if (extracted != canInsert) {
            AELog.error("Fluid item [%s] reported a different possible amount to drain than it actually provided.", this.m_142621_());
            return;
        }
        if (sink.insert(what, extracted, Actionable.MODULATE) != extracted) {
            AELog.error("Failed to insert previously simulated %s into ME system", what);
            return;
        }
        ctx.playEmptySound(this.getPlayer(), what);
    }

    private void handleFakeSlotAction(FakeSlot fakeSlot, InventoryAction action) {
        ItemStack hand = this.m_142621_();
        switch (action) {
            case PICKUP_OR_SET_DOWN: {
                fakeSlot.increase(hand);
                break;
            }
            case PLACE_SINGLE: {
                if (hand.m_41619_()) break;
                ItemStack is = hand.m_41777_();
                is.m_41764_(1);
                fakeSlot.increase(is);
                break;
            }
            case SPLIT_OR_PLACE_SINGLE: {
                ItemStack is = fakeSlot.m_7993_();
                if (!is.m_41619_()) {
                    fakeSlot.decrease(hand);
                    break;
                }
                if (hand.m_41619_()) break;
                is = hand.m_41777_();
                is.m_41764_(1);
                fakeSlot.m_5852_(is);
                break;
            }
            case EMPTY_ITEM: {
                EmptyingAction emptyingAction = ContainerItemStrategies.getEmptyingAction(hand);
                if (emptyingAction == null) break;
                fakeSlot.m_5852_(GenericStack.wrapInItemStack(emptyingAction.what(), emptyingAction.maxAmount()));
                break;
            }
        }
    }

    protected ItemStack transferStackToMenu(ItemStack input) {
        return input;
    }

    public void swapSlotContents(int slotA, int slotB) {
        ItemStack testB;
        Slot a = this.m_38853_(slotA);
        Slot b = this.m_38853_(slotB);
        if (a == null || b == null) {
            return;
        }
        ItemStack isA = a.m_7993_();
        ItemStack isB = b.m_7993_();
        if (isA.m_41619_() && isB.m_41619_()) {
            return;
        }
        if (!isA.m_41619_() && !a.m_8010_(this.getPlayerInventory().f_35978_)) {
            return;
        }
        if (!isB.m_41619_() && !b.m_8010_(this.getPlayerInventory().f_35978_)) {
            return;
        }
        if (!isB.m_41619_() && !a.m_5857_(isB)) {
            return;
        }
        if (!isA.m_41619_() && !b.m_5857_(isA)) {
            return;
        }
        ItemStack testA = isB.m_41619_() ? ItemStack.f_41583_ : isB.m_41777_();
        ItemStack itemStack = testB = isA.m_41619_() ? ItemStack.f_41583_ : isA.m_41777_();
        if (!testA.m_41619_() && testA.m_41613_() > a.m_6641_()) {
            if (!testB.m_41619_()) {
                return;
            }
            int totalA = testA.m_41613_();
            testA.m_41764_(a.m_6641_());
            testB = testA.m_41777_();
            testB.m_41764_(totalA - testA.m_41613_());
        }
        if (!testB.m_41619_() && testB.m_41613_() > b.m_6641_()) {
            if (!testA.m_41619_()) {
                return;
            }
            int totalB = testB.m_41613_();
            testB.m_41764_(b.m_6641_());
            testA = testB.m_41777_();
            testA.m_41764_(totalB - testA.m_41613_());
        }
        a.m_5852_(testA);
        b.m_5852_(testB);
    }

    @MustBeInvokedByOverriders
    public void onServerDataSync() {
    }

    public void onSlotChange(Slot s) {
    }

    public boolean isValidForSlot(Slot s, ItemStack i) {
        return true;
    }

    public boolean isValidMenu() {
        return this.menuValid;
    }

    public void setValidMenu(boolean isContainerValid) {
        this.menuValid = isContainerValid;
    }

    public MenuLocator getLocator() {
        return this.locator;
    }

    public void setLocator(MenuLocator locator) {
        this.locator = locator;
    }

    public boolean isClientSide() {
        return this.getPlayer().m_20193_().m_5776_();
    }

    protected boolean isServerSide() {
        return !this.isClientSide();
    }

    protected final void sendPacketToClient(BasePacket packet) {
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHandler.instance().sendTo(packet, serverPlayer);
        }
    }

    public void m_150429_() {
        super.m_150429_();
        if (this.dataSync.hasFields()) {
            this.sendPacketToClient(new GuiDataSyncPacket(this.f_38840_, this.dataSync::writeFull));
        }
    }

    public final void receiveServerSyncData(GuiDataSyncPacket packet) {
        this.dataSync.readUpdate(packet.getData());
        this.onServerDataSync();
    }

    public final void receiveClientAction(GuiDataSyncPacket packet) {
        FriendlyByteBuf data = packet.getData();
        String name = data.m_130136_(256);
        ClientAction<?> action = this.clientActions.get(name);
        if (action == null) {
            throw new IllegalArgumentException("Unknown client action: '" + name + "'");
        }
        action.handle(data);
    }

    protected final <T> void registerClientAction(String name, Class<T> argClass, Consumer<T> handler) {
        if (this.clientActions.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate client action registered: " + name);
        }
        this.clientActions.put(name, new ClientAction<T>(name, argClass, handler));
    }

    protected final void registerClientAction(String name, Runnable callback) {
        this.registerClientAction(name, Void.class, arg -> callback.run());
    }

    protected final <T> void sendClientAction(String action, T arg) {
        String jsonPayload;
        ClientAction<?> clientAction = this.clientActions.get(action);
        if (clientAction == null) {
            throw new IllegalArgumentException("Trying to send unregistered client action: " + action);
        }
        if (clientAction.argClass == Void.class) {
            if (arg != null) {
                throw new IllegalArgumentException("Client action " + action + " requires no argument, but it was given");
            }
            jsonPayload = null;
        } else {
            if (arg == null) {
                throw new IllegalArgumentException("Client action " + action + " requires an argument, but none was given");
            }
            if (clientAction.argClass != arg.getClass()) {
                throw new IllegalArgumentException("Trying to send client action " + action + " with wrong argument type " + arg.getClass() + ", expected: " + clientAction.argClass);
            }
            jsonPayload = clientAction.gson.toJson(arg);
        }
        if (jsonPayload != null && jsonPayload.length() > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot send client action " + action + " because serialized argument is longer than 32767 (" + jsonPayload.length() + ")");
        }
        NetworkHandler.instance().sendToServer(new GuiDataSyncPacket(this.f_38840_, writer -> {
            writer.m_130070_(clientAction.name);
            if (jsonPayload != null) {
                writer.m_130070_(jsonPayload);
            }
        }));
    }

    protected final void sendClientAction(String action) {
        this.sendClientAction(action, null);
    }

    protected final void setupUpgrades(IUpgradeInventory upgrades) {
        for (int i = 0; i < upgrades.size(); ++i) {
            RestrictedInputSlot slot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, upgrades, i);
            slot.setNotDraggable();
            this.addSlot(slot, SlotSemantics.UPGRADE);
        }
    }

    public boolean isReturnedFromSubScreen() {
        return this.returnedFromSubScreen;
    }

    public void setReturnedFromSubScreen(boolean returnedFromSubScreen) {
        this.returnedFromSubScreen = returnedFromSubScreen;
    }

    protected static interface FillingSource {
        public long extract(long var1, Actionable var3);
    }

    protected static interface EmptyingSink {
        public long insert(AEKey var1, long var2, Actionable var4);
    }

    private static class ClientAction<T> {
        private final Gson gson = new GsonBuilder().create();
        private final String name;
        private final Class<T> argClass;
        private final Consumer<T> handler;

        public ClientAction(String name, Class<T> argClass, Consumer<T> handler) {
            this.name = name;
            this.argClass = argClass;
            this.handler = handler;
        }

        public void handle(FriendlyByteBuf buffer) {
            Object arg = null;
            if (this.argClass != Void.class) {
                String payload = buffer.m_130277_();
                AELog.debug("Handling client action '%s' with payload %s", this.name, payload);
                arg = this.gson.fromJson(payload, this.argClass);
            } else {
                AELog.debug("Handling client action '%s'", this.name);
            }
            this.handler.accept(arg);
        }
    }
}

