/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.grid;

import appeng.api.networking.GridHelper;
import appeng.api.networking.IManagedGridNode;
import appeng.api.orientation.BlockOrientation;
import appeng.api.util.AECableType;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.me.helpers.BlockEntityNodeListener;
import appeng.me.helpers.IGridConnectedBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class AENetworkBlockEntity
extends AEBaseBlockEntity
implements IGridConnectedBlockEntity {
    private final IManagedGridNode mainNode = this.createMainNode().setVisualRepresentation((ItemLike)this.getItemFromBlockEntity()).setInWorldNode(true).setTagName("proxy");

    public AENetworkBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
        this.onGridConnectableSidesChanged();
    }

    protected IManagedGridNode createMainNode() {
        return GridHelper.createManagedNode(this, BlockEntityNodeListener.INSTANCE);
    }

    @Override
    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.getMainNode().loadFromNBT(data);
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        this.getMainNode().saveToNBT(data);
    }

    @Override
    public final IManagedGridNode getMainNode() {
        return this.mainNode;
    }

    @Override
    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.getMainNode().destroy();
    }

    @Override
    public void onReady() {
        AEBaseEntityBlock block;
        BlockState newState;
        super.onReady();
        this.getMainNode().create(this.m_58904_(), this.getBlockEntity().m_58899_());
        BlockState currentState = this.m_58900_();
        Block block2 = currentState.m_60734_();
        if (block2 instanceof AEBaseEntityBlock && currentState != (newState = (block = (AEBaseEntityBlock)block2).getBlockEntityBlockState(currentState, this))) {
            this.markForUpdate();
        }
    }

    @Override
    protected void onOrientationChanged(BlockOrientation orientation) {
        super.onOrientationChanged(orientation);
        this.onGridConnectableSidesChanged();
    }

    protected final void onGridConnectableSidesChanged() {
        this.getMainNode().setExposedOnSides(this.getGridConnectableSides(this.getOrientation()));
    }

    public void m_7651_() {
        super.m_7651_();
        this.getMainNode().destroy();
    }

    public void m_6339_() {
        super.m_6339_();
        this.scheduleInit();
    }
}

