/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.tags;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;
import org.slf4j.Logger;

public abstract class TagsProvider<T>
implements DataProvider {
    private static final Logger f_126541_ = LogUtils.getLogger();
    protected final PackOutput.PathProvider f_236439_;
    private final CompletableFuture<HolderLookup.Provider> f_275752_;
    private final CompletableFuture<Void> f_275754_ = new CompletableFuture();
    private final CompletableFuture<TagLookup<T>> f_273855_;
    protected final ResourceKey<? extends Registry<T>> f_254716_;
    private final Map<ResourceLocation, TagBuilder> f_126543_ = Maps.newLinkedHashMap();

    protected TagsProvider(PackOutput p_256596_, ResourceKey<? extends Registry<T>> p_255886_, CompletableFuture<HolderLookup.Provider> p_256513_) {
        this(p_256596_, p_255886_, p_256513_, CompletableFuture.completedFuture(TagLookup.m_274566_()));
    }

    protected TagsProvider(PackOutput p_275432_, ResourceKey<? extends Registry<T>> p_275476_, CompletableFuture<HolderLookup.Provider> p_275222_, CompletableFuture<TagLookup<T>> p_275565_) {
        this.f_236439_ = p_275432_.m_245269_(PackOutput.Target.DATA_PACK, TagManager.m_203918_(p_275476_));
        this.f_254716_ = p_275476_;
        this.f_273855_ = p_275565_;
        this.f_275752_ = p_275222_;
    }

    @Override
    public final String m_6055_() {
        return "Tags for " + this.f_254716_.m_135782_();
    }

    protected abstract void m_6577_(HolderLookup.Provider var1);

    @Override
    public CompletableFuture<?> m_213708_(CachedOutput p_253684_) {
        record CombinedData<T>(HolderLookup.Provider f_273893_, TagLookup<T> f_273819_) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{CombinedData.class, "contents;parent", "f_273893_", "f_273819_"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CombinedData.class, "contents;parent", "f_273893_", "f_273819_"}, this);
            }

            @Override
            public final boolean equals(Object p_275663_) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CombinedData.class, "contents;parent", "f_273893_", "f_273819_"}, this, p_275663_);
            }
        }
        return ((CompletableFuture)((CompletableFuture)this.m_274574_().thenApply(p_275895_ -> {
            this.f_275754_.complete(null);
            return p_275895_;
        })).thenCombineAsync(this.f_273855_, (p_274778_, p_274779_) -> new CombinedData((HolderLookup.Provider)p_274778_, p_274779_))).thenCompose(p_274774_ -> {
            HolderLookup.RegistryLookup $$2 = p_274774_.f_273893_.m_255025_(this.f_254716_);
            Predicate<ResourceLocation> $$3 = p_255496_ -> $$2.m_254902_(ResourceKey.m_135785_(this.f_254716_, p_255496_)).isPresent();
            Predicate<ResourceLocation> $$4 = p_274776_ -> this.f_126543_.containsKey(p_274776_) || p_274775_.f_273819_.m_274455_(TagKey.m_203882_(this.f_254716_, p_274776_));
            return CompletableFuture.allOf((CompletableFuture[])this.f_126543_.entrySet().stream().map(p_255499_ -> {
                ResourceLocation $$4 = (ResourceLocation)p_255499_.getKey();
                TagBuilder $$5 = (TagBuilder)p_255499_.getValue();
                List<TagEntry> $$6 = $$5.m_215904_();
                List<TagEntry> $$7 = $$6.stream().filter(p_274771_ -> !p_274771_.m_215940_($$3, $$4)).toList();
                if (!$$7.isEmpty()) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Couldn't define tag %s as it is missing following references: %s", $$4, $$7.stream().map(Objects::toString).collect(Collectors.joining(","))));
                }
                JsonElement $$8 = (JsonElement)TagFile.f_215958_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new TagFile($$6, false)).getOrThrow(false, arg_0 -> ((Logger)f_126541_).error(arg_0));
                Path $$9 = this.f_236439_.m_245731_($$4);
                return DataProvider.m_253162_(p_253684_, $$8, $$9);
            }).toArray(CompletableFuture[]::new));
        });
    }

    protected TagAppender<T> m_206424_(TagKey<T> p_206425_) {
        TagBuilder $$1 = this.m_236451_(p_206425_);
        return new TagAppender($$1);
    }

    protected TagBuilder m_236451_(TagKey<T> p_236452_) {
        return this.f_126543_.computeIfAbsent(p_236452_.f_203868_(), p_236442_ -> TagBuilder.m_215899_());
    }

    public CompletableFuture<TagLookup<T>> m_274426_() {
        return this.f_275754_.thenApply(p_276016_ -> p_274772_ -> Optional.ofNullable(this.f_126543_.get(p_274772_.f_203868_())));
    }

    protected CompletableFuture<HolderLookup.Provider> m_274574_() {
        return this.f_275752_.thenApply(p_274768_ -> {
            this.f_126543_.clear();
            this.m_6577_((HolderLookup.Provider)p_274768_);
            return p_274768_;
        });
    }

    @FunctionalInterface
    public static interface TagLookup<T>
    extends Function<TagKey<T>, Optional<TagBuilder>> {
        public static <T> TagLookup<T> m_274566_() {
            return p_275247_ -> Optional.empty();
        }

        default public boolean m_274455_(TagKey<T> p_275413_) {
            return ((Optional)this.apply(p_275413_)).isPresent();
        }
    }

    protected static class TagAppender<T> {
        private final TagBuilder f_126568_;

        protected TagAppender(TagBuilder p_256426_) {
            this.f_126568_ = p_256426_;
        }

        public final TagAppender<T> m_255204_(ResourceKey<T> p_256138_) {
            this.f_126568_.m_215900_(p_256138_.m_135782_());
            return this;
        }

        @SafeVarargs
        public final TagAppender<T> m_211101_(ResourceKey<T> ... p_211102_) {
            for (ResourceKey<T> $$1 : p_211102_) {
                this.f_126568_.m_215900_($$1.m_135782_());
            }
            return this;
        }

        public TagAppender<T> m_176839_(ResourceLocation p_176840_) {
            this.f_126568_.m_215905_(p_176840_);
            return this;
        }

        public TagAppender<T> m_206428_(TagKey<T> p_206429_) {
            this.f_126568_.m_215907_(p_206429_.f_203868_());
            return this;
        }

        public TagAppender<T> m_176841_(ResourceLocation p_176842_) {
            this.f_126568_.m_215909_(p_176842_);
            return this;
        }
    }
}

