/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.fusion;

import java.util.EnumSet;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.ILangEntry;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tile.interfaces.IHasMode;
import mekanism.common.util.NBTUtils;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.base.IReactorLogic;
import mekanism.generators.common.base.IReactorLogicMode;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class TileEntityFusionReactorLogicAdapter
extends TileEntityFusionReactorBlock
implements IReactorLogic<FusionReactorLogic>,
IHasMode {
    public FusionReactorLogic logicType = FusionReactorLogic.DISABLED;
    private boolean activeCooled;
    private boolean prevOutputting;

    public TileEntityFusionReactorLogicAdapter(BlockPos pos, BlockState state) {
        super((IBlockProvider)GeneratorsBlocks.FUSION_REACTOR_LOGIC_ADAPTER, pos, state);
    }

    protected boolean onUpdateServer(FusionReactorMultiblockData multiblock) {
        boolean needsPacket = super.onUpdateServer((MultiblockData)multiblock);
        boolean outputting = this.checkMode();
        if (outputting != this.prevOutputting) {
            Level world = this.m_58904_();
            if (world != null) {
                Direction side = multiblock.getOutsideSide(this.f_58858_);
                if (side == null) {
                    world.m_46672_(this.m_58899_(), this.getBlockType());
                } else if (!ForgeEventFactory.onNeighborNotify((Level)world, (BlockPos)this.f_58858_, (BlockState)this.m_58900_(), EnumSet.of(side), (boolean)false).isCanceled()) {
                    world.m_46586_(this.f_58858_.m_121945_(side), this.getBlockType(), this.f_58858_);
                }
            }
            this.prevOutputting = outputting;
        }
        return needsPacket;
    }

    public int getRedstoneLevel(Direction side) {
        return !this.isRemote() && ((FusionReactorMultiblockData)this.getMultiblock()).isPositionOutsideBounds(this.f_58858_.m_121945_(side)) && this.checkMode() ? 15 : 0;
    }

    public boolean checkMode() {
        if (this.isRemote()) {
            return this.prevOutputting;
        }
        FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)this.getMultiblock();
        if (multiblock.isFormed()) {
            return switch (this.logicType) {
                default -> throw new IncompatibleClassChangeError();
                case FusionReactorLogic.READY -> {
                    if (multiblock.getLastPlasmaTemp() >= multiblock.getIgnitionTemperature(this.activeCooled)) {
                        yield true;
                    }
                    yield false;
                }
                case FusionReactorLogic.CAPACITY -> {
                    if (multiblock.getLastPlasmaTemp() >= multiblock.getMaxPlasmaTemperature(this.activeCooled)) {
                        yield true;
                    }
                    yield false;
                }
                case FusionReactorLogic.DEPLETED -> {
                    if (multiblock.fuelTank.isEmpty()) {
                        int injectionPortion = multiblock.getInjectionRate() / 2;
                        if (injectionPortion == 0 || multiblock.deuteriumTank.getStored() < (long)injectionPortion || multiblock.tritiumTank.getStored() < (long)injectionPortion) {
                            yield true;
                        }
                        yield false;
                    }
                    yield false;
                }
                case FusionReactorLogic.DISABLED -> false;
            };
        }
        return false;
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        NBTUtils.setEnumIfPresent((CompoundTag)nbt, (String)"logicType", FusionReactorLogic::byIndexStatic, logicType -> {
            this.logicType = logicType;
        });
        this.activeCooled = nbt.m_128471_("activeCooled");
    }

    public void m_183515_(@NotNull CompoundTag nbtTags) {
        super.m_183515_(nbtTags);
        NBTUtils.writeEnum((CompoundTag)nbtTags, (String)"logicType", (Enum)this.logicType);
        nbtTags.m_128379_("activeCooled", this.activeCooled);
    }

    @Override
    public boolean canBeMaster() {
        return false;
    }

    public void nextMode() {
        this.activeCooled = !this.activeCooled;
        this.markForSave();
    }

    public void previousMode() {
        this.nextMode();
    }

    @ComputerMethod(nameOverride="isActiveCooledLogic")
    public boolean isActiveCooled() {
        return this.activeCooled;
    }

    @Override
    @ComputerMethod(nameOverride="getLogicMode")
    public FusionReactorLogic getMode() {
        return this.logicType;
    }

    public FusionReactorLogic[] getModes() {
        return FusionReactorLogic.values();
    }

    @ComputerMethod(nameOverride="setLogicMode")
    public void setLogicTypeFromPacket(FusionReactorLogic logicType) {
        if (this.logicType != logicType) {
            this.logicType = logicType;
            this.markForSave();
        }
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableEnum.create(FusionReactorLogic::byIndexStatic, (Enum)FusionReactorLogic.DISABLED, this::getMode, value -> {
            this.logicType = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(this::isActiveCooled, value -> {
            this.activeCooled = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(() -> this.prevOutputting, value -> {
            this.prevOutputting = value;
        }));
    }

    @ComputerMethod
    void setActiveCooledLogic(boolean active) {
        if (this.activeCooled != active) {
            this.nextMode();
        }
    }

    @NothingNullByDefault
    public static enum FusionReactorLogic implements IReactorLogicMode<FusionReactorLogic>,
    IHasTranslationKey
    {
        DISABLED(GeneratorsLang.REACTOR_LOGIC_DISABLED, GeneratorsLang.DESCRIPTION_REACTOR_DISABLED, new ItemStack((ItemLike)Items.f_42403_)),
        READY(GeneratorsLang.REACTOR_LOGIC_READY, GeneratorsLang.DESCRIPTION_REACTOR_READY, new ItemStack((ItemLike)Items.f_42451_)),
        CAPACITY(GeneratorsLang.REACTOR_LOGIC_CAPACITY, GeneratorsLang.DESCRIPTION_REACTOR_CAPACITY, new ItemStack((ItemLike)Items.f_42451_)),
        DEPLETED(GeneratorsLang.REACTOR_LOGIC_DEPLETED, GeneratorsLang.DESCRIPTION_REACTOR_DEPLETED, new ItemStack((ItemLike)Items.f_42451_));

        private static final FusionReactorLogic[] MODES;
        private final ILangEntry name;
        private final ILangEntry description;
        private final ItemStack renderStack;

        private FusionReactorLogic(ILangEntry name, ILangEntry description, ItemStack stack) {
            this.name = name;
            this.description = description;
            this.renderStack = stack;
        }

        @Override
        public ItemStack getRenderStack() {
            return this.renderStack;
        }

        public String getTranslationKey() {
            return this.name.getTranslationKey();
        }

        @Override
        public Component getDescription() {
            return this.description.translate(new Object[0]);
        }

        @Override
        public EnumColor getColor() {
            return EnumColor.RED;
        }

        public static FusionReactorLogic byIndexStatic(int index) {
            return (FusionReactorLogic)MathUtils.getByIndexMod((Object[])MODES, (int)index);
        }

        static {
            MODES = FusionReactorLogic.values();
        }
    }
}

