/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.fusion;

import mekanism.api.providers.IBlockProvider;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.dynamic.SyncMapper;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.tile.prefab.TileEntityMultiblock;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.registries.GeneratorsContainerTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityFusionReactorBlock
extends TileEntityMultiblock<FusionReactorMultiblockData> {
    public TileEntityFusionReactorBlock(BlockPos pos, BlockState state) {
        this((IBlockProvider)GeneratorsBlocks.FUSION_REACTOR_FRAME, pos, state);
    }

    public TileEntityFusionReactorBlock(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
    }

    public FusionReactorMultiblockData createMultiblock() {
        return new FusionReactorMultiblockData(this);
    }

    public MultiblockManager<FusionReactorMultiblockData> getManager() {
        return MekanismGenerators.fusionReactorManager;
    }

    public boolean canBeMaster() {
        return false;
    }

    public void setInjectionRateFromPacket(int rate) {
        FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)this.getMultiblock();
        if (multiblock.isFormed()) {
            multiblock.setInjectionRate(Mth.m_14045_((int)(rate - rate % 2), (int)0, (int)98));
            this.markForSave();
        }
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        if (container.m_6772_() == GeneratorsContainerTypes.FUSION_REACTOR_FUEL.get()) {
            this.addTabContainerTracker(container, "fuel");
        } else if (container.m_6772_() == GeneratorsContainerTypes.FUSION_REACTOR_HEAT.get()) {
            this.addTabContainerTracker(container, "heat");
        } else if (container.m_6772_() == GeneratorsContainerTypes.FUSION_REACTOR_STATS.get()) {
            this.addTabContainerTracker(container, "stats");
        }
    }

    private void addTabContainerTracker(MekanismContainer container, String tab) {
        SyncMapper.INSTANCE.setup(container, FusionReactorMultiblockData.class, () -> ((TileEntityFusionReactorBlock)this).getMultiblock(), tab);
    }
}

