/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import java.util.List;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class TileEntityWindGenerator
extends TileEntityGenerator
implements IBoundingBlock {
    public static final float SPEED = 32.0f;
    public static final float SPEED_SCALED = 8.0f;
    private double angle;
    private FloatingLong currentMultiplier = FloatingLong.ZERO;
    private boolean isBlacklistDimension;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy item slot")
    EnergyInventorySlot energySlot;

    public TileEntityWindGenerator(BlockPos pos, BlockState state) {
        super((IBlockProvider)GeneratorsBlocks.WIND_GENERATOR, pos, state, (FloatingLongSupplier)MekanismGeneratorsConfig.generators.windGenerationMax);
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((TileEntityWindGenerator)this).getDirection());
        this.energySlot = EnergyInventorySlot.drain((IEnergyContainer)this.getEnergyContainer(), (IContentsListener)listener, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot);
        return builder.build();
    }

    @Override
    protected RelativeSide[] getEnergySides() {
        return new RelativeSide[]{RelativeSide.FRONT, RelativeSide.BOTTOM};
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.drainContainer();
        if (this.isBlacklistDimension) {
            return;
        }
        if (this.ticker % 20 == 0) {
            this.currentMultiplier = this.getMultiplier();
            this.setActive(MekanismUtils.canFunction((TileEntityMekanism)this) && !this.currentMultiplier.isZero());
        }
        if (!this.currentMultiplier.isZero() && MekanismUtils.canFunction((TileEntityMekanism)this) && !this.getEnergyContainer().getNeeded().isZero()) {
            this.getEnergyContainer().insert(((FloatingLong)MekanismGeneratorsConfig.generators.windGenerationMin.get()).multiply(this.currentMultiplier), Action.EXECUTE, AutomationType.INTERNAL);
        }
    }

    protected void onUpdateClient() {
        super.onUpdateClient();
        if (this.getActive()) {
            this.angle = (this.angle + (double)(((float)this.m_58899_().m_123342_() + 4.0f) / 8.0f)) % 360.0;
        }
    }

    private FloatingLong getMultiplier() {
        BlockPos top;
        if (this.f_58857_ != null && this.f_58857_.m_6425_(top = this.m_58899_().m_6630_(4)).m_76178_() && this.f_58857_.m_45527_(top)) {
            int minY = Math.max(MekanismGeneratorsConfig.generators.windGenerationMinY.get(), this.f_58857_.m_141937_());
            int maxY = Math.min(MekanismGeneratorsConfig.generators.windGenerationMaxY.get(), this.f_58857_.m_6042_().f_63865_());
            float clampedY = Math.min(maxY, Math.max(minY, top.m_123342_()));
            FloatingLong minG = (FloatingLong)MekanismGeneratorsConfig.generators.windGenerationMin.get();
            FloatingLong maxG = (FloatingLong)MekanismGeneratorsConfig.generators.windGenerationMax.get();
            FloatingLong slope = maxG.subtract(minG).divide((long)(maxY - minY));
            FloatingLong toGen = minG.add(slope.multiply((double)(clampedY - (float)minY)));
            return toGen.divide(minG);
        }
        return FloatingLong.ZERO;
    }

    public void m_142339_(@NotNull Level world) {
        super.m_142339_(world);
        this.isBlacklistDimension = ((List)MekanismGeneratorsConfig.generators.windGenerationDimBlacklist.get()).contains(world.m_46472_().m_135782_());
        if (this.isBlacklistDimension) {
            this.setActive(false);
        }
    }

    public FloatingLong getCurrentMultiplier() {
        return this.currentMultiplier;
    }

    public double getAngle() {
        return this.angle;
    }

    @ComputerMethod(nameOverride="isBlacklistedDimension")
    public boolean isBlacklistDimension() {
        return this.isBlacklistDimension;
    }

    public SoundSource getSoundCategory() {
        return SoundSource.WEATHER;
    }

    public BlockPos getSoundPos() {
        return super.getSoundPos().m_6630_(4);
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableFloatingLong.create(this::getCurrentMultiplier, value -> {
            this.currentMultiplier = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(this::isBlacklistDimension, value -> {
            this.isBlacklistDimension = value;
        }));
    }

    @NotNull
    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_.m_7918_(-2, 0, -2), this.f_58858_.m_7918_(3, 7, 3));
    }

    @Override
    FloatingLong getProductionRate() {
        return this.getActive() ? ((FloatingLong)MekanismGeneratorsConfig.generators.windGenerationMin.get()).multiply(this.getCurrentMultiplier()) : FloatingLong.ZERO;
    }
}

