/*
 * Decompiled with CFR 0.152.
 */
package com.haoict.tiab.commands;

import com.haoict.tiab.common.config.TiabConfig;
import com.haoict.tiab.common.core.api.APIRegistry;
import com.haoict.tiab.common.core.api.interfaces.ITimeInABottleCommandAPI;
import com.haoict.tiab.common.items.TimeInABottleItem;
import com.haoict.tiab.common.utils.SendMessage;
import com.magorage.tiab.api.ITimeInABottleAPI;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TiabCommands {
    private static final String ADD_TIME_COMMAND = "addTime";
    private static final String REMOVE_TIME_COMMAND = "removeTime";
    private static final String TIME_PARAM = "seconds";
    public static final Function<ServerPlayer, ItemStack> TIAB_GETTER = plr -> {
        ItemStack found = null;
        for (int i = 0; i < plr.m_150109_().m_6643_(); ++i) {
            ItemStack invStack = plr.m_150109_().m_8020_(i);
            Item item = invStack.m_41720_();
            if (!(item instanceof TimeInABottleItem)) continue;
            found = invStack;
            break;
        }
        return found;
    };
    private static ITimeInABottleAPI API;
    private static boolean CONFIGURED_API;
    private static boolean registered;
    public static LiteralArgumentBuilder<CommandSourceStack> addTimeCommand;
    public static LiteralArgumentBuilder<CommandSourceStack> removeTimeCommand;

    public static void setAPI(ITimeInABottleAPI api) {
        if (CONFIGURED_API) {
            return;
        }
        CONFIGURED_API = true;
        API = api;
    }

    public static void register() {
        if (registered) {
            return;
        }
        registered = true;
        class Provider
        implements ITimeInABottleCommandAPI {
            Provider() {
            }

            @Override
            public int processCommand(Function<ServerPlayer, ItemStack> itemStackFunction, ServerPlayer player, String messageValue, boolean isAdd) {
                return TiabCommands.handleCommand(itemStackFunction, player, messageValue, isAdd);
            }
        }
        APIRegistry.registerAccess(ITimeInABottleCommandAPI.class, new Provider());
    }

    private static int processTimeCommand(CommandContext<CommandSourceStack> ctx, boolean isAdd) throws CommandSyntaxException {
        Component messageValue = MessageArgument.m_96835_(ctx, (String)TIME_PARAM);
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = source.m_81375_();
        return TiabCommands.handleCommand(TIAB_GETTER, player, messageValue.getString(), isAdd);
    }

    private static int handleCommand(Function<ServerPlayer, ItemStack> itemStackFunction, ServerPlayer player, String messageValue, boolean isAdd) {
        if (!messageValue.isEmpty()) {
            try {
                ItemStack invStack = itemStackFunction.apply(player);
                if (invStack != null) {
                    int currentStoredEnergy = API.getStoredTime(invStack);
                    int timeToAdd = Integer.parseInt(messageValue);
                    if (timeToAdd < 0) {
                        throw new NumberFormatException();
                    }
                    if (timeToAdd > (Integer)TiabConfig.COMMON.maxStoredTime.get() / 20) {
                        timeToAdd = (Integer)TiabConfig.COMMON.maxStoredTime.get() / 20;
                    }
                    if (!isAdd) {
                        if (currentStoredEnergy / 20 < timeToAdd) {
                            timeToAdd = currentStoredEnergy / 20;
                        }
                        timeToAdd = -timeToAdd;
                    }
                    if (API.canUse()) {
                        SendMessage.sendStatusMessage(player, String.format("%s %d seconds", isAdd ? "Added" : "Removed ", timeToAdd));
                        API.setStoredTime(invStack, currentStoredEnergy + timeToAdd * 20);
                    } else if (!API.callCommandEvent(player, timeToAdd, isAdd)) {
                        SendMessage.sendStatusMessage(player, "TIAB has had its API access revoked.");
                    }
                } else {
                    SendMessage.sendStatusMessage(player, "No Time in a bottle item in inventory");
                }
                return 1;
            }
            catch (NumberFormatException ex) {
                SendMessage.sendStatusMessage(player, "Invalid time parameter! (is the number too big?)");
            }
        } else {
            SendMessage.sendStatusMessage(player, "Empty time parameter!");
        }
        return 0;
    }

    static {
        CONFIGURED_API = false;
        registered = false;
        addTimeCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)ADD_TIME_COMMAND).requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82129_((String)TIME_PARAM, (ArgumentType)MessageArgument.m_96832_()).executes(ctx -> {
            try {
                return TiabCommands.processTimeCommand((CommandContext<CommandSourceStack>)ctx, true);
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }));
        removeTimeCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)REMOVE_TIME_COMMAND).requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82129_((String)TIME_PARAM, (ArgumentType)MessageArgument.m_96832_()).executes(ctx -> {
            try {
                return TiabCommands.processTimeCommand((CommandContext<CommandSourceStack>)ctx, false);
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }));
    }
}

