/*
 * Decompiled with CFR 0.152.
 */
package cofh.ensorcellation.common.enchantment;

import cofh.core.init.CoreMobEffects;
import cofh.core.init.CoreParticles;
import cofh.ensorcellation.Ensorcellation;
import cofh.lib.common.enchantment.EnchantmentCoFH;
import cofh.lib.util.Constants;
import cofh.lib.util.Utils;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolActions;

public class FrostRebukeEnchantment
extends EnchantmentCoFH {
    public static int chance = 20;
    public static boolean mobsAffectPlayers = false;

    public FrostRebukeEnchantment() {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.ARMOR_CHEST, Constants.ARMOR_SLOTS);
        this.maxLevel = 3;
    }

    public int m_6183_(int level) {
        return 5 + 15 * (level - 1);
    }

    protected int maxDelegate(int level) {
        return super.m_6183_(level) + 50;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        Item item = stack.m_41720_();
        return this.enable && (super.canApplyAtEnchantingTable(stack) || item instanceof HorseArmorItem || item.canPerformAction(stack, ToolActions.SHIELD_BLOCK));
    }

    public boolean m_5975_(Enchantment ench) {
        return super.m_5975_(ench) && ench != Enchantments.f_44972_ && ench != Ensorcellation.ENCHANTMENTS.get("displacement") && ench != Ensorcellation.ENCHANTMENTS.get("fire_rebuke");
    }

    public void m_7675_(LivingEntity user, Entity attacker, int level) {
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        Map.Entry stack = EnchantmentHelper.m_44906_((Enchantment)this, (LivingEntity)user);
        if (FrostRebukeEnchantment.shouldHit(level, user.m_217043_())) {
            FrostRebukeEnchantment.onHit(user, attacker, level);
            if (stack != null) {
                ((ItemStack)stack.getValue()).m_41622_(2, user, entity -> entity.m_21166_((EquipmentSlot)stack.getKey()));
            }
        }
    }

    public static void onHit(LivingEntity user, Entity attacker, int level) {
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        if (user instanceof Player || !(attacker instanceof Player) || mobsAffectPlayers) {
            ((LivingEntity)attacker).m_147240_((double)(0.5f * (float)level), user.m_20185_() - attacker.m_20185_(), user.m_20189_() - attacker.m_20189_());
        }
        RandomSource rand = user.m_217043_();
        int i = 20 + 20 * rand.m_188503_(3 * level);
        if (attacker.m_6060_()) {
            attacker.m_20095_();
        }
        ((LivingEntity)attacker).m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.CHILLED.get(), i, level - 1, false, false));
        if (attacker.f_19853_ instanceof ServerLevel) {
            for (int j = 0; j < 3 * level; ++j) {
                Utils.spawnParticles((Level)attacker.f_19853_, (ParticleOptions)((SimpleParticleType)CoreParticles.FROST.get()), (double)(attacker.m_20185_() + rand.m_188500_()), (double)(attacker.m_20186_() + 1.0 + rand.m_188500_()), (double)(attacker.m_20189_() + rand.m_188500_()), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
            }
        }
    }

    public static boolean shouldHit(int level, RandomSource rand) {
        return rand.m_188503_(100) < chance * level;
    }
}

