/*
 * Decompiled with CFR 0.152.
 */
package cofh.ensorcellation.common.config;

import cofh.core.common.config.IBaseConfig;
import cofh.ensorcellation.Ensorcellation;
import cofh.ensorcellation.common.enchantment.AnglerEnchantment;
import cofh.ensorcellation.common.enchantment.DamageVillagerEnchantment;
import cofh.ensorcellation.common.enchantment.DisplacementEnchantment;
import cofh.ensorcellation.common.enchantment.FireRebukeEnchantment;
import cofh.ensorcellation.common.enchantment.FrostRebukeEnchantment;
import cofh.ensorcellation.common.enchantment.HunterEnchantment;
import cofh.ensorcellation.common.enchantment.PilferingEnchantment;
import cofh.ensorcellation.common.enchantment.SoulboundEnchantment;
import cofh.ensorcellation.common.enchantment.VitalityEnchantment;
import cofh.ensorcellation.common.enchantment.VorpalEnchantment;
import cofh.ensorcellation.common.enchantment.XpBoostEnchantment;
import cofh.lib.common.enchantment.EnchantmentCoFH;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;

public class BaseEnchantmentConfig
implements IBaseConfig {
    private Supplier<Boolean> enableProtectionMagic;
    private Supplier<Boolean> treasureProtectionMagic;
    private Supplier<Integer> levelProtectionMagic;
    private Supplier<Boolean> enableDisplacement;
    private Supplier<Boolean> treasureDisplacement;
    private Supplier<Integer> levelDisplacement;
    private Supplier<Integer> chanceDisplacement;
    private Supplier<Boolean> allowMobsDisplacement;
    private Supplier<Boolean> enableFireRebuke;
    private Supplier<Boolean> treasureFireRebuke;
    private Supplier<Integer> levelFireRebuke;
    private Supplier<Integer> chanceFireRebuke;
    private Supplier<Boolean> allowMobsFireRebuke;
    private Supplier<Boolean> enableFrostRebuke;
    private Supplier<Boolean> treasureFrostRebuke;
    private Supplier<Integer> levelFrostRebuke;
    private Supplier<Integer> chanceFrostRebuke;
    private Supplier<Boolean> allowMobsFrostRebuke;
    private Supplier<Boolean> enableAirAffinity;
    private Supplier<Boolean> treasureAirAffinity;
    private Supplier<Boolean> enableXpBoost;
    private Supplier<Boolean> treasureXpBoost;
    private Supplier<Integer> levelXpBoost;
    private Supplier<Integer> amountXpBoost;
    private Supplier<Boolean> enableGourmand;
    private Supplier<Boolean> treasureGourmand;
    private Supplier<Integer> levelGourmand;
    private Supplier<Boolean> enableReach;
    private Supplier<Boolean> treasureReach;
    private Supplier<Integer> levelReach;
    private Supplier<Boolean> enableVitality;
    private Supplier<Boolean> treasureVitality;
    private Supplier<Integer> levelVitality;
    private Supplier<Integer> healthLevelVitality;
    private Supplier<Boolean> enableDamageEnder;
    private Supplier<Boolean> treasureDamageEnder;
    private Supplier<Integer> levelDamageEnder;
    private Supplier<Boolean> enableDamageIllager;
    private Supplier<Boolean> treasureDamageIllager;
    private Supplier<Integer> levelDamageIllager;
    private Supplier<Boolean> enableDamageVillager;
    private Supplier<Boolean> treasureDamageVillager;
    private Supplier<Integer> levelDamageVillager;
    private Supplier<Boolean> dropsDamageVillager;
    private Supplier<Boolean> enableCavalier;
    private Supplier<Boolean> treasureCavalier;
    private Supplier<Integer> levelCavalier;
    private Supplier<Boolean> enableFrostAspect;
    private Supplier<Boolean> treasureFrostAspect;
    private Supplier<Integer> levelFrostAspect;
    private Supplier<Boolean> enableInstigating;
    private Supplier<Boolean> treasureInstigating;
    private Supplier<Boolean> enableLeech;
    private Supplier<Boolean> treasureLeech;
    private Supplier<Integer> levelLeech;
    private Supplier<Boolean> enableMagicEdge;
    private Supplier<Boolean> treasureMagicEdge;
    private Supplier<Integer> levelMagicEdge;
    private Supplier<Boolean> enableVorpal;
    private Supplier<Boolean> treasureVorpal;
    private Supplier<Integer> levelVorpal;
    private Supplier<Integer> critBaseVorpal;
    private Supplier<Integer> critLevelVorpal;
    private Supplier<Integer> critDamageVorpal;
    private Supplier<Integer> headBaseVorpal;
    private Supplier<Integer> headLevelVorpal;
    private Supplier<Boolean> enableExcavating;
    private Supplier<Boolean> treasureExcavating;
    private Supplier<Boolean> enableHunter;
    private Supplier<Boolean> treasureHunter;
    private Supplier<Integer> levelHunter;
    private Supplier<Integer> chanceHunter;
    private Supplier<Boolean> enableQuickDraw;
    private Supplier<Boolean> treasureQuickDraw;
    private Supplier<Integer> levelQuickDraw;
    private Supplier<Boolean> enableTrueshot;
    private Supplier<Boolean> treasureTrueshot;
    private Supplier<Integer> levelTrueshot;
    private Supplier<Boolean> enableVolley;
    private Supplier<Boolean> treasureVolley;
    private Supplier<Boolean> enableAngler;
    private Supplier<Boolean> treasureAngler;
    private Supplier<Integer> levelAngler;
    private Supplier<Integer> chanceAngler;
    private Supplier<Boolean> enablePilfering;
    private Supplier<Boolean> treasurePilfering;
    private Supplier<Boolean> playerStealPilfering;
    private Supplier<Boolean> enableFurrowing;
    private Supplier<Boolean> treasureFurrowing;
    private Supplier<Integer> levelFurrowing;
    private Supplier<Boolean> enableTilling;
    private Supplier<Boolean> treasureTilling;
    private Supplier<Integer> levelTilling;
    private Supplier<Boolean> enableWeeding;
    private Supplier<Boolean> treasureWeeding;
    private Supplier<Boolean> enableBulwark;
    private Supplier<Boolean> treasureBulwark;
    private Supplier<Boolean> enablePhalanx;
    private Supplier<Boolean> treasurePhalanx;
    private Supplier<Integer> levelPhalanx;
    private Supplier<Boolean> enableSoulbound;
    private Supplier<Boolean> treasureSoulbound;
    private Supplier<Integer> levelSoulbound;
    private Supplier<Boolean> permanentSoulbound;
    private Supplier<Boolean> enableCurseFool;
    private Supplier<Boolean> enableCurseMercy;

    public void apply(ForgeConfigSpec.Builder builder) {
        String treasure = "This sets whether or not the Enchantment is considered a 'treasure' enchantment.";
        String level = "This option adjusts the maximum allowable level for the Enchantment.";
        builder.push("Enchantments");
        builder.push("Magic Protection");
        this.enableProtectionMagic = builder.comment("If TRUE, the Magic Protection Enchantment is available for Armor and Horse Armor.").define("Enable", true);
        this.treasureProtectionMagic = builder.comment(treasure).define("Treasure", false);
        this.levelProtectionMagic = builder.comment(level).defineInRange("Max Level", 4, 1, 10);
        builder.pop();
        builder.push("Displacement");
        this.enableDisplacement = builder.comment("If TRUE, the Displacement Enchantment is available for Armor, Shields, and Horse Armor.").define("Enable", false);
        this.treasureDisplacement = builder.comment(treasure).define("Treasure", true);
        this.levelDisplacement = builder.comment(level).defineInRange("Max Level", 3, 1, 10);
        this.chanceDisplacement = builder.comment("Adjust this value to set the chance per level of the Enchantment firing (in percentage).").defineInRange("Effect Chance", 20, 1, 100);
        this.allowMobsDisplacement = builder.comment("If TRUE, mobs wearing armor with this Enchantment can teleport players.").define("Mobs Teleport Players", DisplacementEnchantment.mobsAffectPlayers);
        builder.pop();
        builder.push("Flaming Rebuke");
        this.enableFireRebuke = builder.comment("If TRUE, the Flaming Rebuke Enchantment is available for Armor, Shields, and Horse Armor.").define("Enable", false);
        this.treasureFireRebuke = builder.comment(treasure).define("Treasure", true);
        this.levelFireRebuke = builder.comment(level).defineInRange("Max Level", 3, 1, 10);
        this.chanceFireRebuke = builder.comment("Adjust this value to set the chance per level of the Enchantment firing (in percentage).").defineInRange("Effect Chance", 20, 1, 100);
        this.allowMobsFireRebuke = builder.comment("If TRUE, mobs wearing armor with this Enchantment can knockback players.").define("Mobs Knockback Players", FireRebukeEnchantment.mobsAffectPlayers);
        builder.pop();
        builder.push("Chilling Rebuke");
        this.enableFrostRebuke = builder.comment("If TRUE, the Chilling Rebuke Enchantment is available for Armor, Shields, and Horse Armor.").define("Enable", false);
        this.treasureFrostRebuke = builder.comment(treasure).define("Treasure", true);
        this.levelFrostRebuke = builder.comment(level).defineInRange("Max Level", 3, 1, 10);
        this.chanceFrostRebuke = builder.comment("Adjust this value to set the chance per level of the Enchantment firing (in percentage).").defineInRange("Effect Chance", 20, 1, 100);
        this.allowMobsFrostRebuke = builder.comment("If TRUE, mobs wearing armor with this Enchantment can knockback players.").define("Mobs Knockback Players", FrostRebukeEnchantment.mobsAffectPlayers);
        builder.pop();
        builder.push("Air Affinity");
        this.enableAirAffinity = builder.comment("If TRUE, the Air Affinity Enchantment is available for Helmets.").define("Enable", true);
        this.treasureAirAffinity = builder.comment(treasure).define("Treasure", false);
        builder.pop();
        builder.push("Insight");
        this.enableXpBoost = builder.comment("If TRUE, the Insight Enchantment is available for Helmets.").define("Enable", true);
        this.treasureXpBoost = builder.comment(treasure).define("Treasure", false);
        this.levelXpBoost = builder.comment(level).defineInRange("Max Level", 3, 1, 10);
        this.amountXpBoost = builder.comment("Adjust this to change the max experience awarded per level of the Enchantment.").defineInRange("Experience Amount", 4, 1, 1000);
        builder.pop();
        builder.push("Gourmand");
        this.enableGourmand = builder.comment("If TRUE, the Gourmand Enchantment is available for Helmets.").define("Enable", false);
        this.treasureGourmand = builder.comment(treasure).define("Treasure", false);
        this.levelGourmand = builder.comment(level).defineInRange("Max Level", 2, 1, 10);
        builder.pop();
        builder.push("Reach");
        this.enableReach = builder.comment("If TRUE, the Reach Enchantment is available for Chestplates.").define("Enable", true);
        this.treasureReach = builder.comment(treasure).define("Treasure", true);
        this.levelReach = builder.comment(level).defineInRange("Max Level", 3, 1, 10);
        builder.pop();
        builder.push("Vitality");
        this.enableVitality = builder.comment("If TRUE, the Vitality Enchantment is available for Chestplates and Horse Armor.").define("Enable", true);
        this.treasureVitality = builder.comment(treasure).define("Treasure", true);
        this.levelVitality = builder.comment(level).defineInRange("Max Level", 3, 1, 10);
        this.healthLevelVitality = builder.comment("Adjust this value to set the health granted per level of the Enchantment. (There are 2 health per heart icon.)").defineInRange("Health / Level", 4, 1, 10);
        builder.pop();
        builder.push("Ender Disruption");
        this.enableDamageEnder = builder.comment("If TRUE, the Ender Disruption Enchantment is available for various Weapons.").define("Enable", false);
        this.treasureDamageEnder = builder.comment(treasure).define("Treasure", true);
        this.levelDamageEnder = builder.comment(level).defineInRange("Max Level", 5, 1, 10);
        builder.pop();
        builder.push("Vigilante");
        this.enableDamageIllager = builder.comment("If TRUE, the Vigilante Enchantment is available for various Weapons.").define("Enable", true);
        this.treasureDamageIllager = builder.comment(treasure).define("Treasure", true);
        this.levelDamageIllager = builder.comment(level).defineInRange("Max Level", 5, 1, 10);
        builder.pop();
        builder.push("Outlaw");
        this.enableDamageVillager = builder.comment("If TRUE, the Outlaw Enchantment is available for various Weapons.").define("Enable", false);
        this.treasureDamageVillager = builder.comment(treasure).define("Treasure", false);
        this.levelDamageVillager = builder.comment(level).defineInRange("Max Level", 5, 1, 10);
        this.dropsDamageVillager = builder.comment("If TRUE, the Outlaw Enchantment causes Villagers (and Iron Golems) to drop Emeralds when killed.").define("Emerald Drops", true);
        builder.pop();
        builder.push("Cavalier");
        this.enableCavalier = builder.comment("If TRUE, the Cavalier Enchantment is available for various Weapons.").define("Enable", false);
        this.treasureCavalier = builder.comment(treasure).define("Treasure", true);
        this.levelCavalier = builder.comment(level).defineInRange("Max Level", 3, 1, 10);
        builder.pop();
        builder.push("Frost Aspect");
        this.enableFrostAspect = builder.comment("If TRUE, the Frost Aspect Enchantment is available for various Weapons.").define("Enable", true);
        this.treasureFrostAspect = builder.comment(treasure).define("Treasure", true);
        this.levelFrostAspect = builder.comment(level).defineInRange("Max Level", 2, 1, 10);
        builder.pop();
        builder.push("Instigating");
        this.enableInstigating = builder.comment("If TRUE, the Instigating Enchantment is available for various Weapons.").define("Enable", false);
        this.treasureInstigating = builder.comment(treasure).define("Treasure", true);
        builder.pop();
        builder.push("Leech");
        this.enableLeech = builder.comment("If TRUE, the Leech Enchantment is available for various Weapons.").define("Enable", true);
        this.treasureLeech = builder.comment(treasure).define("Treasure", false);
        this.levelLeech = builder.comment(level).defineInRange("Max Level", 4, 1, 10);
        builder.pop();
        builder.push("Magic Edge");
        this.enableMagicEdge = builder.comment("If TRUE, the Magic Edge Enchantment is available for various Weapons.").define("Enable", false);
        this.treasureMagicEdge = builder.comment(treasure).define("Treasure", true);
        this.levelMagicEdge = builder.comment(level).defineInRange("Max Level", 3, 1, 10);
        builder.pop();
        builder.push("Vorpal");
        this.enableVorpal = builder.comment("If TRUE, the Vorpal Enchantment is available for various Weapons.").define("Enable", true);
        this.treasureVorpal = builder.comment(treasure).define("Treasure", true);
        this.levelVorpal = builder.comment(level).defineInRange("Max Level", 3, 1, 10);
        this.critBaseVorpal = builder.comment("Adjust this value to set the base critical hit chance of the Enchantment (in percentage).").defineInRange("Base Critical Chance", 5, 0, 100);
        this.critLevelVorpal = builder.comment("Adjust this value to set the additional critical hit chance per level of the Enchantment (in percentage).").defineInRange("Critical Chance / Level", 5, 0, 100);
        this.critDamageVorpal = builder.comment("Adjust this value to set the critical hit damage multiplier.").defineInRange("Critical Damage Multiplier", 5, 0, 1000);
        this.headBaseVorpal = builder.comment("Adjust this value to set the base head drop chance for the Enchantment (in percentage).").defineInRange("Base Head Drop Chance", 10, 0, 100);
        this.headLevelVorpal = builder.comment("Adjust this value to set the head drop chance per level of the Enchantment (in percentage).").defineInRange("Head Drop Chance / Level", 10, 0, 100);
        builder.pop();
        builder.push("Excavating");
        this.enableExcavating = builder.comment("If TRUE, the Excavating Enchantment is available for various Tools.").define("Enable", true);
        this.treasureExcavating = builder.comment(treasure).define("Treasure", true);
        builder.pop();
        builder.push("Hunter's Bounty");
        this.enableHunter = builder.comment("If TRUE, the Hunter's Bounty Enchantment is available for Bows.").define("Enable", true);
        this.treasureHunter = builder.comment(treasure).define("Treasure", true);
        this.levelHunter = builder.comment(level).defineInRange("Max Level", 2, 1, 10);
        this.chanceHunter = builder.comment("Adjust this value to set the chance of an additional drop per level of the Enchantment (in percentage).").defineInRange("Effect Chance", 50, 1, 100);
        builder.pop();
        builder.push("Quick Draw");
        this.enableQuickDraw = builder.comment("If TRUE, the Quick Draw Enchantment is available for various Bows.").define("Enable", true);
        this.treasureQuickDraw = builder.comment(treasure).define("Treasure", false);
        this.levelQuickDraw = builder.comment(level).defineInRange("Max Level", 3, 1, 10);
        builder.pop();
        builder.push("Trueshot");
        this.enableTrueshot = builder.comment("If TRUE, the Trueshot Enchantment is available for various Bows.").define("Enable", true);
        this.treasureTrueshot = builder.comment(treasure).define("Treasure", false);
        this.levelTrueshot = builder.comment(level).defineInRange("Max Level", 2, 1, 10);
        builder.pop();
        builder.push("Volley");
        this.enableVolley = builder.comment("If TRUE, the Volley Enchantment is available for various Bows.").define("Enable", true);
        this.treasureVolley = builder.comment(treasure).define("Treasure", false);
        builder.pop();
        builder.push("Angler's Bounty");
        this.enableAngler = builder.comment("If TRUE, the Angler's Bounty Enchantment is available for Fishing Rods.").define("Enable", true);
        this.treasureAngler = builder.comment(treasure).define("Treasure", true);
        this.levelAngler = builder.comment(level).defineInRange("Max Level", 2, 1, 10);
        this.chanceAngler = builder.comment("Adjust this value to set the chance of an additional drop per level of the Enchantment (in percentage).").defineInRange("Effect Chance", 50, 1, 100);
        builder.pop();
        builder.push("Pilfering");
        this.enablePilfering = builder.comment("If TRUE, the Pilfering Enchantment is available for Fishing Rods.").define("Enable", false);
        this.treasurePilfering = builder.comment(treasure).define("Treasure", true);
        this.playerStealPilfering = builder.comment("This sets whether or not the Enchantment works on Players.").define("Allow Player Stealing", true);
        builder.pop();
        builder.push("Bulwark");
        this.enableBulwark = builder.comment("If TRUE, the Bulwark Enchantment is available for Shields.").define("Enable", true);
        this.treasureBulwark = builder.comment(treasure).define("Treasure", false);
        builder.pop();
        builder.push("Phalanx");
        this.enablePhalanx = builder.comment("If TRUE, the Phalanx Enchantment is available for Shields.").define("Enable", true);
        this.treasurePhalanx = builder.comment(treasure).define("Treasure", false);
        this.levelPhalanx = builder.comment(level).defineInRange("Max Level", 2, 1, 10);
        builder.pop();
        builder.push("Soulbound");
        this.enableSoulbound = builder.comment("If TRUE, the Soulbound Enchantment is available.").define("Enable", true);
        this.treasureSoulbound = builder.comment(treasure).define("Treasure", false);
        this.levelSoulbound = builder.comment("This option adjusts the maximum allowable level for the Enchantment. If permanent, this setting is ignored.").defineInRange("Max Level", 3, 1, 10);
        this.permanentSoulbound = builder.comment("If TRUE, the Soulbound Enchantment is permanent (and will remove excess levels when triggered).").define("Permanent", true);
        builder.pop();
        builder.push("Curse of Foolishness");
        this.enableCurseFool = builder.comment("If TRUE, the Curse of Foolishness Enchantment is available for Helmets.").define("Enable", true);
        builder.pop();
        builder.push("Curse of Mercy");
        this.enableCurseMercy = builder.comment("If TRUE, the Curse of Mercy Enchantment is available for various Weapons.").define("Enable", true);
        builder.pop();
        builder.pop();
    }

    public void refresh() {
        EnchantmentCoFH enc;
        Object object = Ensorcellation.ENCHANTMENTS.get("magic_protection");
        if (object instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableProtectionMagic.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureProtectionMagic.get().booleanValue());
            enc.setMaxLevel(this.levelProtectionMagic.get().intValue());
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("displacement")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableDisplacement.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureDisplacement.get().booleanValue());
            enc.setMaxLevel(this.levelDisplacement.get().intValue());
            DisplacementEnchantment.chance = this.chanceDisplacement.get();
            DisplacementEnchantment.mobsAffectPlayers = this.allowMobsDisplacement.get();
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("fire_rebuke")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableFireRebuke.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureFireRebuke.get().booleanValue());
            enc.setMaxLevel(this.levelFireRebuke.get().intValue());
            FireRebukeEnchantment.chance = this.chanceFireRebuke.get();
            FireRebukeEnchantment.mobsAffectPlayers = this.allowMobsFireRebuke.get();
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("frost_rebuke")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableFrostRebuke.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureFrostRebuke.get().booleanValue());
            enc.setMaxLevel(this.levelFrostRebuke.get().intValue());
            FrostRebukeEnchantment.chance = this.chanceFrostRebuke.get();
            FrostRebukeEnchantment.mobsAffectPlayers = this.allowMobsFrostRebuke.get();
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("air_affinity")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableAirAffinity.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureAirAffinity.get().booleanValue());
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("xp_boost")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableXpBoost.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureXpBoost.get().booleanValue());
            enc.setMaxLevel(this.levelXpBoost.get().intValue());
            XpBoostEnchantment.xp = this.amountXpBoost.get();
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("gourmand")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableGourmand.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureGourmand.get().booleanValue());
            enc.setMaxLevel(this.levelGourmand.get().intValue());
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("reach")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableReach.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureReach.get().booleanValue());
            enc.setMaxLevel(this.levelReach.get().intValue());
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("vitality")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableVitality.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureVitality.get().booleanValue());
            enc.setMaxLevel(this.levelVitality.get().intValue());
            VitalityEnchantment.health = this.healthLevelVitality.get();
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("damage_ender")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableDamageEnder.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureDamageEnder.get().booleanValue());
            enc.setMaxLevel(this.levelDamageEnder.get().intValue());
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("damage_illager")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableDamageIllager.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureDamageIllager.get().booleanValue());
            enc.setMaxLevel(this.levelDamageIllager.get().intValue());
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("damage_villager")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableDamageVillager.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureDamageVillager.get().booleanValue());
            enc.setMaxLevel(this.levelDamageVillager.get().intValue());
            DamageVillagerEnchantment.enableEmeraldDrops = this.dropsDamageVillager.get();
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("cavalier")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableCavalier.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureCavalier.get().booleanValue());
            enc.setMaxLevel(this.levelCavalier.get().intValue());
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("frost_aspect")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableFrostAspect.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureFrostAspect.get().booleanValue());
            enc.setMaxLevel(this.levelFrostAspect.get().intValue());
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("instigating")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableInstigating.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureInstigating.get().booleanValue());
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("leech")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableLeech.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureLeech.get().booleanValue());
            enc.setMaxLevel(this.levelLeech.get().intValue());
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("magic_edge")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableMagicEdge.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureMagicEdge.get().booleanValue());
            enc.setMaxLevel(this.levelMagicEdge.get().intValue());
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("vorpal")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableVorpal.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureVorpal.get().booleanValue());
            enc.setMaxLevel(this.levelVorpal.get().intValue());
            VorpalEnchantment.critBase = this.critBaseVorpal.get();
            VorpalEnchantment.critLevel = this.critLevelVorpal.get();
            VorpalEnchantment.critDamage = this.critDamageVorpal.get();
            VorpalEnchantment.headBase = this.headBaseVorpal.get();
            VorpalEnchantment.headLevel = this.headLevelVorpal.get();
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("excavating")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableExcavating.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureExcavating.get().booleanValue());
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("hunter")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableHunter.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureHunter.get().booleanValue());
            enc.setMaxLevel(this.levelHunter.get().intValue());
            HunterEnchantment.chance = this.chanceHunter.get();
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("quick_draw")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableQuickDraw.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureQuickDraw.get().booleanValue());
            enc.setMaxLevel(this.levelQuickDraw.get().intValue());
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("trueshot")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableTrueshot.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureTrueshot.get().booleanValue());
            enc.setMaxLevel(this.levelTrueshot.get().intValue());
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("volley")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableVolley.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureVolley.get().booleanValue());
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("angler")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableAngler.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureAngler.get().booleanValue());
            enc.setMaxLevel(this.levelAngler.get().intValue());
            AnglerEnchantment.chance = this.chanceAngler.get();
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("pilfering")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enablePilfering.get().booleanValue());
            enc.setTreasureEnchantment(this.treasurePilfering.get().booleanValue());
            PilferingEnchantment.allowPlayerStealing = this.playerStealPilfering.get();
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("furrowing")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableFurrowing.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureFurrowing.get().booleanValue());
            enc.setMaxLevel(this.levelFurrowing.get().intValue());
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("tilling")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableTilling.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureTilling.get().booleanValue());
            enc.setMaxLevel(this.levelTilling.get().intValue());
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("weeding")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableWeeding.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureWeeding.get().booleanValue());
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("bulwark")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableBulwark.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureBulwark.get().booleanValue());
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("phalanx")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enablePhalanx.get().booleanValue());
            enc.setTreasureEnchantment(this.treasurePhalanx.get().booleanValue());
            enc.setMaxLevel(this.levelPhalanx.get().intValue());
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("soulbound")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableSoulbound.get().booleanValue());
            enc.setTreasureEnchantment(this.treasureSoulbound.get().booleanValue());
            enc.setMaxLevel(this.levelSoulbound.get().intValue());
            SoulboundEnchantment.permanent = this.permanentSoulbound.get();
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("curse_fool")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableCurseFool.get().booleanValue());
        }
        if ((object = Ensorcellation.ENCHANTMENTS.get("curse_mercy")) instanceof EnchantmentCoFH) {
            enc = (EnchantmentCoFH)object;
            enc.setEnable(this.enableCurseMercy.get().booleanValue());
        }
    }
}

