/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.datagen;

import alexthw.ars_elemental.registry.ModAdvTriggers;
import alexthw.ars_elemental.registry.ModEntities;
import alexthw.ars_elemental.registry.ModItems;
import com.google.common.collect.ImmutableMap;
import com.hollingsworth.arsnouveau.common.datagen.advancement.ANAdvancementBuilder;
import com.hollingsworth.arsnouveau.common.datagen.advancement.ANAdvancements;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.advancements.critereon.SummonedEntityTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.registries.ForgeRegistries;

public class AEAdvancementsProvider
extends ForgeAdvancementProvider {
    public AEAdvancementsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(output, registries, existingFileHelper, List.of(new AEAdvancements()));
    }

    public String getOldName() {
        return "Ars Elemental Advancement Datagen";
    }

    public static class AEAdvancements
    extends ANAdvancements {
        static Consumer<Advancement> advancementConsumer;

        static Advancement dummy(String name) {
            return new Advancement(new ResourceLocation("ars_nouveau", name), null, null, AdvancementRewards.f_9978_, (Map)ImmutableMap.of(), null, false);
        }

        public void generate(HolderLookup.Provider registries, Consumer<Advancement> con, ExistingFileHelper existingFileHelper) {
            advancementConsumer = con;
            this.saveBasicItem((ItemLike)ModItems.SIREN_CHARM.get(), AEAdvancements.dummy("poof_mob"));
            this.saveBasicItem((ItemLike)ModItems.FIRENANDO_CHARM.get(), AEAdvancements.dummy("enchanting_apparatus"));
            this.saveBasicItem((ItemLike)ModItems.MARK_OF_MASTERY.get(), AEAdvancements.dummy("wilden_tribute"));
            this.saveBasicItem((ItemLike)ModItems.WATER_URN.get(), AEAdvancements.dummy("enchanting_apparatus"));
            this.builder("mirror_shield").display((ItemLike)ItemsRegistry.ENCHANTERS_SHIELD, FrameType.CHALLENGE, true).addCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(ModAdvTriggers.MIRROR.m_7295_(), EntityPredicate.m_285787_((EntityPredicate)EntityPredicate.f_36550_))).parent(AEAdvancements.dummy("enchanting_apparatus")).save(con);
            Advancement curioBag = this.saveBasicItem((ItemLike)ModItems.CURIO_BAG.get(), AEAdvancements.dummy("magebloom_crop"));
            this.saveBasicItem((ItemLike)ModItems.CASTER_BAG.get(), curioBag);
            Advancement air = this.saveBasicItem((ItemLike)ModItems.LESSER_AIR_FOCUS.get(), curioBag);
            Advancement fire = this.saveBasicItem((ItemLike)ModItems.LESSER_FIRE_FOCUS.get(), curioBag);
            Advancement earth = this.saveBasicItem((ItemLike)ModItems.LESSER_EARTH_FOCUS.get(), curioBag);
            Advancement water = this.saveBasicItem((ItemLike)ModItems.LESSER_WATER_FOCUS.get(), curioBag);
            this.buildBasicItem((ItemLike)ModItems.AIR_FOCUS.get(), "air_focus", FrameType.CHALLENGE, air).save(con);
            this.buildBasicItem((ItemLike)ModItems.FIRE_FOCUS.get(), "fire_focus", FrameType.CHALLENGE, fire).save(con);
            this.buildBasicItem((ItemLike)ModItems.EARTH_FOCUS.get(), "earth_focus", FrameType.CHALLENGE, earth).save(con);
            this.buildBasicItem((ItemLike)ModItems.WATER_FOCUS.get(), "water_focus", FrameType.CHALLENGE, water).save(con);
            Advancement necro = this.saveBasicItem((ItemLike)ModItems.NECRO_FOCUS.get(), AEAdvancements.dummy("summon_focus"));
            this.builder("summon_skeleton_horse").display((ItemLike)ModItems.NECRO_CTOME.get(), FrameType.GOAL).addCriterion((CriterionTriggerInstance)SummonedEntityTrigger.TriggerInstance.m_68275_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)ModEntities.SKELEHORSE_SUMMON.get()))).parent(necro).save(con);
            this.builder("summon_strider").display((ItemLike)ModItems.FIRE_CTOME.get(), FrameType.GOAL).addCriterion((CriterionTriggerInstance)SummonedEntityTrigger.TriggerInstance.m_68275_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)ModEntities.STRIDER_SUMMON.get()))).parent(fire).save(con);
            this.builder("summon_dolphin").display((ItemLike)ModItems.WATER_CTOME.get(), FrameType.GOAL).addCriterion((CriterionTriggerInstance)SummonedEntityTrigger.TriggerInstance.m_68275_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)ModEntities.DOLPHIN_SUMMON.get()))).parent(water).save(con);
            this.builder("levitation").display((ItemLike)ModItems.AIR_CTOME.get(), FrameType.GOAL).addCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(ModAdvTriggers.LEVITATE.m_7295_(), EntityPredicate.m_285787_((EntityPredicate)EntityPredicate.f_36550_))).parent(air).save(con);
            this.builder("spore_blossom").display((ItemLike)ModItems.GROUND_BLOSSOM.get(), FrameType.GOAL).addCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(ModAdvTriggers.BLOSSOM.m_7295_(), EntityPredicate.m_285787_((EntityPredicate)EntityPredicate.f_36550_))).parent(earth).save(con);
        }

        public Advancement saveBasicItem(ItemLike item, Advancement parent) {
            return this.buildBasicItem(item, ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()).m_135815_(), FrameType.TASK, parent).save(advancementConsumer);
        }

        public ANAdvancementBuilder buildBasicItem(ItemLike item, String id, FrameType frame, Advancement parent) {
            return this.builder(id).display(item, frame).requireItem(item).parent(parent);
        }

        public ANAdvancementBuilder builder(String key) {
            return ANAdvancementBuilder.builder((String)"ars_elemental", (String)key);
        }
    }
}

